/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.objects;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.telegram.telegrambots.meta.api.objects.Update;

public final class Reply {
    public final List<Predicate<Update>> conditions;
    public final Consumer<Update> action;

    private Reply(List<Predicate<Update>> conditions, Consumer<Update> action) {
        this.conditions = conditions;
        this.action = action;
    }

    @SafeVarargs
    public static Reply of(Consumer<Update> action, Predicate<Update> ... conditions) {
        return new Reply(Arrays.asList(conditions), action);
    }

    public boolean isOkFor(Update update) {
        BiFunction<Boolean, Predicate, Boolean> stateAnd = (state, cond) -> state != false && cond.test(update);
        return this.conditions.stream().reduce(true, stateAnd, Boolean::logicalAnd);
    }

    public void actOn(Update update) {
        this.action.accept(update);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reply reply = (Reply)o;
        return Objects.equals(this.conditions, reply.conditions) && Objects.equals(this.action, reply.action);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.action);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("conditions", this.conditions).add("action", this.action).toString();
    }
}

