/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.bot;

import com.google.common.base.Strings;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.telegram.abilitybots.api.bot.BaseAbilityBot;
import org.telegram.abilitybots.api.objects.Ability;
import org.telegram.abilitybots.api.objects.Flag;
import org.telegram.abilitybots.api.objects.Locality;
import org.telegram.abilitybots.api.objects.MessageContext;
import org.telegram.abilitybots.api.objects.Privacy;
import org.telegram.abilitybots.api.util.AbilityExtension;
import org.telegram.abilitybots.api.util.AbilityMessageCodes;
import org.telegram.abilitybots.api.util.AbilityUtils;
import org.telegram.abilitybots.api.util.Pair;
import org.telegram.telegrambots.meta.api.methods.GetFile;
import org.telegram.telegrambots.meta.api.methods.send.SendDocument;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.api.objects.User;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

public final class DefaultAbilities
implements AbilityExtension {
    public static final String CLAIM = "claim";
    public static final String BAN = "ban";
    public static final String PROMOTE = "promote";
    public static final String DEMOTE = "demote";
    public static final String UNBAN = "unban";
    public static final String BACKUP = "backup";
    public static final String RECOVER = "recover";
    public static final String COMMANDS = "commands";
    public static final String REPORT = "report";
    private static final Logger log = LoggerFactory.getLogger(DefaultAbilities.class);
    private final BaseAbilityBot bot;

    public DefaultAbilities(BaseAbilityBot bot) {
        this.bot = bot;
    }

    public Ability reportCommands() {
        return Ability.builder().name(REPORT).locality(Locality.ALL).privacy(Privacy.CREATOR).input(0).action(ctx -> {
            String commands = this.bot.abilities().values().stream().filter(ability -> Objects.nonNull(ability.info())).map(ability -> {
                String name = ability.name();
                String info = ability.info();
                return String.format("%s - %s", name, info);
            }).sorted().reduce((a, b) -> String.format("%s%n%s", a, b)).orElse(AbilityUtils.getLocalizedMessage(AbilityMessageCodes.ABILITY_COMMANDS_NOT_FOUND, ctx.user().getLanguageCode(), new Object[0]));
            this.bot.silent.send(commands, ctx.chatId());
        }).build();
    }

    public Ability commands() {
        return Ability.builder().name(COMMANDS).locality(Locality.USER).privacy(Privacy.PUBLIC).input(0).action(ctx -> {
            Privacy privacy = this.bot.getPrivacy(ctx.update(), ctx.user().getId());
            ListMultimap abilitiesPerPrivacy = this.bot.abilities().values().stream().map(ability -> {
                String name = ability.name();
                String info = ability.info();
                if (!StringUtils.isEmpty((CharSequence)info)) {
                    return Pair.of(ability.privacy(), String.format("/%s - %s", name, info));
                }
                return Pair.of(ability.privacy(), String.format("/%s", name));
            }).sorted(Comparator.comparing(Pair::b)).collect(() -> MultimapBuilder.hashKeys().arrayListValues().build(), (map, pair) -> map.put((Object)((Privacy)((Object)((Object)((Object)pair.a())))), (Object)((String)pair.b())), Multimap::putAll);
            String commands = abilitiesPerPrivacy.asMap().entrySet().stream().filter(entry -> privacy.compareTo((Privacy)((Object)((Object)((Object)entry.getKey())))) >= 0).sorted(Comparator.comparing(Map.Entry::getKey)).map(entry -> ((Collection)entry.getValue()).stream().reduce(((Privacy)((Object)((Object)((Object)entry.getKey())))).toString(), (a, b) -> String.format("%s\n%s", a, b))).collect(Collectors.joining("\n"));
            if (commands.isEmpty()) {
                commands = AbilityUtils.getLocalizedMessage(AbilityMessageCodes.ABILITY_COMMANDS_NOT_FOUND, ctx.user().getLanguageCode(), new Object[0]);
            }
            this.bot.silent.send(commands, ctx.chatId());
        }).build();
    }

    public Ability backupDB() {
        return Ability.builder().name(BACKUP).locality(Locality.USER).privacy(Privacy.CREATOR).input(0).action(ctx -> {
            File backup = new File("backup.json");
            try (PrintStream printStream = new PrintStream(backup);){
                printStream.print(this.bot.db.backup());
                this.bot.sender.sendDocument(new SendDocument().setDocument(backup).setChatId(ctx.chatId()));
            }
            catch (FileNotFoundException e) {
                log.error("Error while fetching backup", (Throwable)e);
            }
            catch (TelegramApiException e) {
                log.error("Error while sending document/backup file", (Throwable)e);
            }
        }).build();
    }

    public Ability recoverDB() {
        return Ability.builder().name(RECOVER).locality(Locality.USER).privacy(Privacy.CREATOR).input(0).action(ctx -> this.bot.silent.forceReply(AbilityUtils.getLocalizedMessage(AbilityMessageCodes.ABILITY_RECOVER_MESSAGE, ctx.user().getLanguageCode(), new Object[0]), ctx.chatId())).reply(update -> {
            String recoverMessage;
            String replyToMsg = update.getMessage().getReplyToMessage().getText();
            if (!replyToMsg.equals(recoverMessage = AbilityUtils.getLocalizedMessage(AbilityMessageCodes.ABILITY_RECOVER_MESSAGE, AbilityUtils.getUser(update).getLanguageCode(), new Object[0]))) {
                return;
            }
            String fileId = update.getMessage().getDocument().getFileId();
            try (FileReader reader = new FileReader(this.downloadFileWithId(fileId));){
                String backupData = IOUtils.toString((Reader)reader);
                if (this.bot.db.recover(backupData)) {
                    this.send(AbilityMessageCodes.ABILITY_RECOVER_SUCCESS, (Update)update);
                } else {
                    this.send(AbilityMessageCodes.ABILITY_RECOVER_FAIL, (Update)update);
                }
            }
            catch (Exception e) {
                log.error("Could not recover DB from backup", (Throwable)e);
                this.send(AbilityMessageCodes.ABILITY_RECOVER_ERROR, (Update)update);
            }
        }, Flag.MESSAGE, Flag.DOCUMENT, Flag.REPLY).build();
    }

    public Ability banUser() {
        return Ability.builder().name(BAN).locality(Locality.ALL).privacy(Privacy.ADMIN).input(1).action(ctx -> {
            String bannedUser;
            String username = AbilityUtils.stripTag(ctx.firstArg());
            int userId = this.getUserIdSendError(username, (MessageContext)ctx);
            if (userId == this.bot.creatorId()) {
                userId = ctx.user().getId();
                bannedUser = Strings.isNullOrEmpty((String)ctx.user().getUserName()) ? AbilityUtils.addTag(ctx.user().getUserName()) : AbilityUtils.shortName(ctx.user());
            } else {
                bannedUser = AbilityUtils.addTag(username);
            }
            Set<Integer> blacklist = this.bot.blacklist();
            if (blacklist.contains(userId)) {
                this.sendMd(AbilityMessageCodes.ABILITY_BAN_FAIL, (MessageContext)ctx, AbilityUtils.escape(bannedUser));
            } else {
                blacklist.add(userId);
                this.sendMd(AbilityMessageCodes.ABILITY_BAN_SUCCESS, (MessageContext)ctx, AbilityUtils.escape(bannedUser));
            }
        }).post(AbilityUtils.commitTo(this.bot.db)).build();
    }

    public Ability unbanUser() {
        return Ability.builder().name(UNBAN).locality(Locality.ALL).privacy(Privacy.ADMIN).input(1).action(ctx -> {
            String username = AbilityUtils.stripTag(ctx.firstArg());
            Integer userId = this.getUserIdSendError(username, (MessageContext)ctx);
            Set<Integer> blacklist = this.bot.blacklist();
            if (!blacklist.remove(userId)) {
                this.bot.silent.sendMd(AbilityUtils.getLocalizedMessage(AbilityMessageCodes.ABILITY_UNBAN_FAIL, ctx.user().getLanguageCode(), AbilityUtils.escape(username)), ctx.chatId());
            } else {
                this.bot.silent.sendMd(AbilityUtils.getLocalizedMessage(AbilityMessageCodes.ABILITY_UNBAN_SUCCESS, ctx.user().getLanguageCode(), AbilityUtils.escape(username)), ctx.chatId());
            }
        }).post(AbilityUtils.commitTo(this.bot.db)).build();
    }

    public Ability promoteAdmin() {
        return Ability.builder().name(PROMOTE).locality(Locality.ALL).privacy(Privacy.ADMIN).input(1).action(ctx -> {
            String username = AbilityUtils.stripTag(ctx.firstArg());
            Integer userId = this.getUserIdSendError(username, (MessageContext)ctx);
            Set<Integer> admins = this.bot.admins();
            if (admins.contains(userId)) {
                this.sendMd(AbilityMessageCodes.ABILITY_PROMOTE_FAIL, (MessageContext)ctx, AbilityUtils.escape(username));
            } else {
                admins.add(userId);
                this.sendMd(AbilityMessageCodes.ABILITY_PROMOTE_SUCCESS, (MessageContext)ctx, AbilityUtils.escape(username));
            }
        }).post(AbilityUtils.commitTo(this.bot.db)).build();
    }

    public Ability demoteAdmin() {
        return Ability.builder().name(DEMOTE).locality(Locality.ALL).privacy(Privacy.ADMIN).input(1).action(ctx -> {
            String username = AbilityUtils.stripTag(ctx.firstArg());
            Integer userId = this.getUserIdSendError(username, (MessageContext)ctx);
            Set<Integer> admins = this.bot.admins();
            if (admins.remove(userId)) {
                this.sendMd(AbilityMessageCodes.ABILITY_DEMOTE_SUCCESS, (MessageContext)ctx, AbilityUtils.escape(username));
            } else {
                this.sendMd(AbilityMessageCodes.ABILITY_DEMOTE_FAIL, (MessageContext)ctx, AbilityUtils.escape(username));
            }
        }).post(AbilityUtils.commitTo(this.bot.db)).build();
    }

    public Ability claimCreator() {
        return Ability.builder().name(CLAIM).locality(Locality.ALL).privacy(Privacy.CREATOR).input(0).action(ctx -> {
            int id;
            Set<Integer> admins = this.bot.admins();
            if (admins.contains(id = this.bot.creatorId())) {
                this.send(AbilityMessageCodes.ABILITY_CLAIM_FAIL, (MessageContext)ctx, new String[0]);
            } else {
                admins.add(id);
                this.send(AbilityMessageCodes.ABILITY_CLAIM_SUCCESS, (MessageContext)ctx, new String[0]);
            }
        }).post(AbilityUtils.commitTo(this.bot.db)).build();
    }

    private User getUser(String username) {
        Integer id = this.bot.userIds().get(username.toLowerCase());
        if (id == null) {
            throw new IllegalStateException(String.format("Could not find ID corresponding to username [%s]", username));
        }
        return this.getUser(id);
    }

    private User getUser(int id) {
        User user = this.bot.users().get(id);
        if (user == null) {
            throw new IllegalStateException(String.format("Could not find user corresponding to id [%d]", id));
        }
        return user;
    }

    private int getUserIdSendError(String username, MessageContext ctx) {
        try {
            return this.getUser(username).getId();
        }
        catch (IllegalStateException ex) {
            this.bot.silent.send(AbilityUtils.getLocalizedMessage(AbilityMessageCodes.USER_NOT_FOUND, ctx.user().getLanguageCode(), username), ctx.chatId());
            throw ex;
        }
    }

    private Optional<Message> send(String message, MessageContext ctx, String ... args) {
        return this.bot.silent.send(AbilityUtils.getLocalizedMessage(message, ctx.user().getLanguageCode(), (Object[])args), ctx.chatId());
    }

    private Optional<Message> sendMd(String message, MessageContext ctx, String ... args) {
        return this.bot.silent.sendMd(AbilityUtils.getLocalizedMessage(message, ctx.user().getLanguageCode(), (Object[])args), ctx.chatId());
    }

    private Optional<Message> send(String message, Update upd) {
        Long chatId = upd.getMessage().getChatId();
        return this.bot.silent.send(AbilityUtils.getLocalizedMessage(message, AbilityUtils.getUser(upd).getLanguageCode(), new Object[0]), chatId);
    }

    protected File downloadFileWithId(String fileId) throws TelegramApiException {
        return this.bot.sender.downloadFile((org.telegram.telegrambots.meta.api.objects.File)this.bot.sender.execute(new GetFile().setFileId(fileId)));
    }
}

