/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.bot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.telegram.abilitybots.api.bot.DefaultAbilities;
import org.telegram.abilitybots.api.db.DBContext;
import org.telegram.abilitybots.api.objects.Ability;
import org.telegram.abilitybots.api.objects.Locality;
import org.telegram.abilitybots.api.objects.MessageContext;
import org.telegram.abilitybots.api.objects.Privacy;
import org.telegram.abilitybots.api.objects.Reply;
import org.telegram.abilitybots.api.objects.Stats;
import org.telegram.abilitybots.api.sender.DefaultSender;
import org.telegram.abilitybots.api.sender.MessageSender;
import org.telegram.abilitybots.api.sender.SilentSender;
import org.telegram.abilitybots.api.toggle.AbilityToggle;
import org.telegram.abilitybots.api.util.AbilityExtension;
import org.telegram.abilitybots.api.util.AbilityMessageCodes;
import org.telegram.abilitybots.api.util.AbilityUtils;
import org.telegram.abilitybots.api.util.Pair;
import org.telegram.abilitybots.api.util.Trio;
import org.telegram.telegrambots.bots.DefaultAbsSender;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.meta.api.methods.groupadministration.GetChatAdministrators;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.api.objects.User;

public abstract class BaseAbilityBot
extends DefaultAbsSender
implements AbilityExtension {
    private static final Logger log = LoggerFactory.getLogger(BaseAbilityBot.class);
    protected static final String DEFAULT = "default";
    public static final String ADMINS = "ADMINS";
    public static final String USERS = "USERS";
    public static final String USER_ID = "USER_ID";
    public static final String BLACKLIST = "BLACKLIST";
    public static final String STATS = "ABILITYBOT_STATS";
    protected final DBContext db;
    protected MessageSender sender;
    protected SilentSender silent;
    private final AbilityToggle toggle;
    private final String botToken;
    private final String botUsername;
    private Map<String, Ability> abilities;
    private Map<String, Stats> stats;
    private List<Reply> replies;

    public abstract int creatorId();

    protected BaseAbilityBot(String botToken, String botUsername, DBContext db, AbilityToggle toggle, DefaultBotOptions botOptions) {
        super(botOptions);
        this.botToken = botToken;
        this.botUsername = botUsername;
        this.db = db;
        this.toggle = toggle;
        this.sender = new DefaultSender(this);
        this.silent = new SilentSender(this.sender);
        this.registerAbilities();
        this.initStats();
    }

    public Map<Integer, User> users() {
        return this.db.getMap(USERS);
    }

    public Map<String, Integer> userIds() {
        return this.db.getMap(USER_ID);
    }

    public Set<Integer> blacklist() {
        return this.db.getSet(BLACKLIST);
    }

    public Set<Integer> admins() {
        return this.db.getSet(ADMINS);
    }

    public Map<String, Stats> stats() {
        return this.stats;
    }

    public Map<String, Ability> abilities() {
        return this.abilities;
    }

    public List<Reply> replies() {
        return this.replies;
    }

    public void onUpdateReceived(Update update) {
        log.info(String.format("[%s] New update [%s] received at %s", this.botUsername, update.getUpdateId(), ZonedDateTime.now()));
        log.info(update.toString());
        long millisStarted = System.currentTimeMillis();
        Stream.of(update).filter(this::checkGlobalFlags).filter(this::checkBlacklist).map(this::addUser).filter(this::filterReply).filter(this::hasUser).map(this::getAbility).filter(this::validateAbility).filter(this::checkPrivacy).filter(this::checkLocality).filter(this::checkInput).filter(this::checkMessageFlags).map(this::getContext).map(this::consumeUpdate).map(this::updateStats).forEach(this::postConsumption);
        this.db.commit();
        long processingTime = System.currentTimeMillis() - millisStarted;
        log.info(String.format("[%s] Processing of update [%s] ended at %s%n---> Processing time: [%d ms] <---%n", this.botUsername, update.getUpdateId(), ZonedDateTime.now(), processingTime));
    }

    public String getBotToken() {
        return this.botToken;
    }

    public String getBotUsername() {
        return this.botUsername;
    }

    public Privacy getPrivacy(Update update, int id) {
        return this.isCreator(id) ? Privacy.CREATOR : (this.isAdmin(id) ? Privacy.ADMIN : ((AbilityUtils.isGroupUpdate(update) || AbilityUtils.isSuperGroupUpdate(update)) && this.isGroupAdmin(update, id) ? Privacy.GROUP_ADMIN : Privacy.PUBLIC));
    }

    public boolean isGroupAdmin(Update update, int id) {
        return this.isGroupAdmin(AbilityUtils.getChatId(update), id);
    }

    public boolean isGroupAdmin(long chatId, int id) {
        GetChatAdministrators admins = new GetChatAdministrators().setChatId(Long.valueOf(chatId));
        return this.silent.execute(admins).orElse(new ArrayList()).stream().anyMatch(member -> member.getUser().getId() == id);
    }

    public boolean isCreator(int id) {
        return id == this.creatorId();
    }

    public boolean isAdmin(Integer id) {
        return this.admins().contains(id);
    }

    protected boolean checkGlobalFlags(Update update) {
        return true;
    }

    protected String getCommandPrefix() {
        return "/";
    }

    protected String getCommandRegexSplit() {
        return " ";
    }

    protected boolean allowContinuousText() {
        return false;
    }

    private void registerAbilities() {
        try {
            List extensions = Arrays.stream(this.getClass().getMethods()).filter(BaseAbilityBot.checkReturnType(AbilityExtension.class)).map(this.returnExtension(this)).collect(Collectors.toList());
            extensions.add(this);
            DefaultAbilities defaultAbs = new DefaultAbilities(this);
            Stream<Ability> defaultAbsStream = Arrays.stream(DefaultAbilities.class.getMethods()).filter(BaseAbilityBot.checkReturnType(Ability.class)).map(BaseAbilityBot.returnAbility(defaultAbs)).filter(ab -> !this.toggle.isOff((Ability)ab)).map(this.toggle::processAbility);
            this.abilities = Stream.concat(defaultAbsStream, extensions.stream().flatMap(ext -> Arrays.stream(ext.getClass().getMethods()).filter(BaseAbilityBot.checkReturnType(Ability.class)).map(BaseAbilityBot.returnAbility(ext)))).collect(ImmutableMap::builder, (b, a) -> b.put((Object)a.name(), a), (b1, b2) -> b1.putAll((Map)b2.build())).build();
            Stream extensionReplies = extensions.stream().flatMap(ext -> Arrays.stream(ext.getClass().getMethods()).filter(BaseAbilityBot.checkReturnType(Reply.class)).map(BaseAbilityBot.returnReply(ext))).flatMap(Reply::stream);
            Stream abilityReplies = this.abilities.values().stream().flatMap(ability -> ability.replies().stream()).flatMap(Reply::stream);
            this.replies = Stream.concat(abilityReplies, extensionReplies).collect(ImmutableList::builder, ImmutableList.Builder::add, (b1, b2) -> b1.addAll((Iterable)b2.build())).build();
        }
        catch (IllegalStateException e) {
            log.error("Duplicate names found while registering abilities. Make sure that the abilities declared don't clash with the reserved ones.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private void initStats() {
        Set<String> enabledStats = Stream.concat(this.replies.stream().filter(Reply::statsEnabled).map(Reply::name), this.abilities.entrySet().stream().filter(entry -> ((Ability)entry.getValue()).statsEnabled()).map(Map.Entry::getKey)).collect(Collectors.toSet());
        this.stats = this.db.getMap(STATS);
        Sets.SetView toBeRemoved = Sets.difference(this.stats.keySet(), enabledStats);
        toBeRemoved.forEach(this.stats::remove);
        enabledStats.forEach(abName -> this.stats.computeIfAbsent((String)abName, name -> Stats.createStats(abName, 0L)));
    }

    private static Predicate<Method> checkReturnType(Class<?> clazz) {
        return method -> clazz.isAssignableFrom(method.getReturnType());
    }

    private Function<? super Method, AbilityExtension> returnExtension(Object obj) {
        return method -> {
            try {
                return (AbilityExtension)method.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error("Could not add ability extension", (Throwable)e);
                throw new RuntimeException(e);
            }
        };
    }

    private static Function<? super Method, Ability> returnAbility(Object obj) {
        return method -> {
            try {
                return (Ability)method.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error("Could not add ability", (Throwable)e);
                throw new RuntimeException(e);
            }
        };
    }

    private static Function<? super Method, Reply> returnReply(Object obj) {
        return method -> {
            try {
                return (Reply)method.invoke(obj, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                log.error("Could not add reply", (Throwable)e);
                throw new RuntimeException(e);
            }
        };
    }

    private void postConsumption(Pair<MessageContext, Ability> pair) {
        Optional.ofNullable(pair.b().postAction()).ifPresent(consumer -> consumer.accept((MessageContext)pair.a()));
    }

    Pair<MessageContext, Ability> consumeUpdate(Pair<MessageContext, Ability> pair) {
        pair.b().action().accept(pair.a());
        return pair;
    }

    Pair<MessageContext, Ability> updateStats(Pair<MessageContext, Ability> pair) {
        Ability ab = pair.b();
        if (ab.statsEnabled()) {
            this.updateStats(pair.b().name());
        }
        return pair;
    }

    private void updateReplyStats(Reply reply) {
        if (reply.statsEnabled()) {
            this.updateStats(reply.name());
        }
    }

    void updateStats(String name) {
        Stats statsObj = this.stats.get(name);
        statsObj.hit();
        this.stats.put(name, statsObj);
    }

    Pair<MessageContext, Ability> getContext(Trio<Update, Ability, String[]> trio) {
        Update update = trio.a();
        User user = AbilityUtils.getUser(update);
        return Pair.of(MessageContext.newContext(update, user, AbilityUtils.getChatId(update), trio.c()), trio.b());
    }

    boolean checkBlacklist(Update update) {
        User user = AbilityUtils.getUser(update);
        if (Objects.isNull(user)) {
            return true;
        }
        int id = user.getId();
        return id == this.creatorId() || !this.blacklist().contains(id);
    }

    boolean checkInput(Trio<Update, Ability, String[]> trio) {
        boolean isOk;
        String[] tokens = trio.c();
        int abilityTokens = trio.b().tokens();
        boolean bl = isOk = abilityTokens == 0 || tokens.length > 0 && tokens.length == abilityTokens;
        if (!isOk) {
            this.silent.send(AbilityUtils.getLocalizedMessage(AbilityMessageCodes.CHECK_INPUT_FAIL, AbilityUtils.getUser(trio.a()).getLanguageCode(), abilityTokens, abilityTokens == 1 ? "input" : "inputs"), AbilityUtils.getChatId(trio.a()));
        }
        return isOk;
    }

    boolean checkLocality(Trio<Update, Ability, String[]> trio) {
        boolean isOk;
        Update update = trio.a();
        Locality locality = AbilityUtils.isUserMessage(update) ? Locality.USER : Locality.GROUP;
        Locality abilityLocality = trio.b().locality();
        boolean bl = isOk = abilityLocality == Locality.ALL || locality == abilityLocality;
        if (!isOk) {
            this.silent.send(AbilityUtils.getLocalizedMessage(AbilityMessageCodes.CHECK_LOCALITY_FAIL, AbilityUtils.getUser(trio.a()).getLanguageCode(), abilityLocality.toString().toLowerCase()), AbilityUtils.getChatId(trio.a()));
        }
        return isOk;
    }

    boolean checkPrivacy(Trio<Update, Ability, String[]> trio) {
        boolean isOk;
        User user;
        int id;
        Update update = trio.a();
        Privacy privacy = this.getPrivacy(update, id = (user = AbilityUtils.getUser(update)).getId().intValue());
        boolean bl = isOk = privacy.compareTo(trio.b().privacy()) >= 0;
        if (!isOk) {
            this.silent.send(AbilityUtils.getLocalizedMessage(AbilityMessageCodes.CHECK_PRIVACY_FAIL, AbilityUtils.getUser(trio.a()).getLanguageCode(), new Object[0]), AbilityUtils.getChatId(trio.a()));
        }
        return isOk;
    }

    boolean validateAbility(Trio<Update, Ability, String[]> trio) {
        return trio.b() != null;
    }

    Trio<Update, Ability, String[]> getAbility(Update update) {
        Ability ability;
        String[] tokens;
        Message msg = update.getMessage();
        if (!update.hasMessage() || !msg.hasText()) {
            return Trio.of(update, this.abilities.get(DEFAULT), new String[0]);
        }
        if (this.allowContinuousText()) {
            String abName = this.abilities.keySet().stream().filter(name -> msg.getText().startsWith(String.format("%s%s", this.getCommandPrefix(), name))).max(Comparator.comparingInt(String::length)).orElse(DEFAULT);
            tokens = msg.getText().replaceFirst(this.getCommandPrefix() + abName, "").split(this.getCommandRegexSplit());
            ability = this.abilities.get(abName);
        } else {
            tokens = msg.getText().split(this.getCommandRegexSplit());
            if (tokens[0].startsWith(this.getCommandPrefix())) {
                String abilityToken = this.stripBotUsername(tokens[0].substring(1)).toLowerCase();
                ability = this.abilities.get(abilityToken);
                tokens = Arrays.copyOfRange(tokens, 1, tokens.length);
            } else {
                ability = this.abilities.get(DEFAULT);
            }
        }
        return Trio.of(update, ability, tokens);
    }

    private String stripBotUsername(String token) {
        return Pattern.compile(String.format("@%s", this.botUsername), 2).matcher(token).replaceAll("");
    }

    Update addUser(Update update) {
        User endUser = AbilityUtils.getUser(update);
        if (endUser.equals((Object)AbilityUtils.EMPTY_USER)) {
            return update;
        }
        this.users().compute(endUser.getId(), (id, user) -> {
            if (user == null) {
                this.updateUserId((User)user, endUser);
                return endUser;
            }
            if (!user.equals((Object)endUser)) {
                this.updateUserId((User)user, endUser);
                return endUser;
            }
            return user;
        });
        return update;
    }

    private boolean hasUser(Update update) {
        return !AbilityUtils.getUser(update).equals((Object)AbilityUtils.EMPTY_USER);
    }

    private void updateUserId(User oldUser, User newUser) {
        if (oldUser != null && oldUser.getUserName() != null) {
            this.userIds().remove(oldUser.getUserName());
        }
        if (newUser.getUserName() != null) {
            this.userIds().put(newUser.getUserName().toLowerCase(), newUser.getId());
        }
    }

    boolean filterReply(Update update) {
        return this.replies.stream().filter(reply -> this.runSilently(() -> reply.isOkFor(update), reply.name())).map(reply -> this.runSilently(() -> {
            reply.actOn(update);
            this.updateReplyStats((Reply)reply);
            return false;
        }, reply.name())).reduce(true, Boolean::logicalAnd);
    }

    boolean runSilently(Callable<Boolean> callable, String name) {
        try {
            return callable.call();
        }
        catch (Exception ex) {
            log.error(String.format("Reply [%s] failed to check for conditions. Make sure you're safeguarding against all possible updates.", name));
            return false;
        }
    }

    boolean checkMessageFlags(Trio<Update, Ability, String[]> trio) {
        Ability ability = trio.b();
        Update update = trio.a();
        BiFunction<Boolean, Predicate, Boolean> flagAnd = (flag, nextFlag) -> flag != false && nextFlag.test(update);
        return ability.flags().stream().reduce(true, flagAnd, Boolean::logicalAnd);
    }
}

