/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.sender;

import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.telegram.abilitybots.api.sender.MessageSender;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ForceReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.updateshandlers.SentCallback;

public class SilentSender {
    private static final Logger log = LoggerFactory.getLogger(SilentSender.class);
    private final MessageSender sender;

    public SilentSender(MessageSender sender) {
        this.sender = sender;
    }

    public Optional<Message> send(String message, long id) {
        return this.doSendMessage(message, id, false);
    }

    public Optional<Message> sendMd(String message, long id) {
        return this.doSendMessage(message, id, true);
    }

    public Optional<Message> forceReply(String message, long id) {
        SendMessage msg = new SendMessage();
        msg.setText(message);
        msg.setChatId(Long.toString(id));
        msg.setReplyMarkup((ReplyKeyboard)new ForceReplyKeyboard());
        return this.execute(msg);
    }

    public <T extends Serializable, Method extends BotApiMethod<T>> Optional<T> execute(Method method) {
        try {
            return Optional.ofNullable(this.sender.execute(method));
        }
        catch (TelegramApiException e) {
            log.error("Could not execute bot API method", (Throwable)e);
            return Optional.empty();
        }
    }

    public <T extends Serializable, Method extends BotApiMethod<T>, Callback extends SentCallback<T>> void executeAsync(Method method, Callback callable) {
        try {
            this.sender.executeAsync(method, callable);
        }
        catch (TelegramApiException e) {
            log.error("Could not execute bot API method", (Throwable)e);
        }
    }

    private Optional<Message> doSendMessage(String txt, long groupId, boolean format) {
        SendMessage smsg = new SendMessage();
        smsg.setChatId(Long.toString(groupId));
        smsg.setText(txt);
        smsg.enableMarkdown(format);
        return this.execute(smsg);
    }
}

