/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.objects;

import java.util.Objects;
import java.util.function.Predicate;
import org.telegram.telegrambots.meta.api.objects.Update;

public enum Flag implements Predicate<Update>
{
    NONE(update -> true),
    MESSAGE(Update::hasMessage),
    CALLBACK_QUERY(Update::hasCallbackQuery),
    CHANNEL_POST(Update::hasChannelPost),
    EDITED_CHANNEL_POST(Update::hasEditedChannelPost),
    EDITED_MESSAGE(Update::hasEditedMessage),
    INLINE_QUERY(Update::hasInlineQuery),
    CHOSEN_INLINE_QUERY(Update::hasChosenInlineQuery),
    SHIPPING_QUERY(Update::hasShippingQuery),
    PRECHECKOUT_QUERY(Update::hasPreCheckoutQuery),
    POLL(Update::hasPoll),
    POLL_ANSWER(Update::hasPollAnswer),
    MY_CHAT_MEMBER(Update::hasMyChatMember),
    CHAT_MEMBER(Update::hasChatMember),
    REPLY(upd -> MESSAGE.test((Update)upd) && upd.getMessage().isReply()),
    DOCUMENT(upd -> MESSAGE.test((Update)upd) && upd.getMessage().hasDocument()),
    TEXT(upd -> MESSAGE.test((Update)upd) && upd.getMessage().hasText()),
    PHOTO(upd -> MESSAGE.test((Update)upd) && upd.getMessage().hasPhoto()),
    LOCATION(upd -> MESSAGE.test((Update)upd) && upd.getMessage().hasLocation()),
    CAPTION(upd -> MESSAGE.test((Update)upd) && Objects.nonNull(upd.getMessage().getCaption()));

    private final Predicate<Update> predicate;

    private Flag(Predicate<Update> predicate) {
        this.predicate = predicate;
    }

    @Override
    public boolean test(Update update) {
        return Objects.nonNull(update) && this.predicate.test(update);
    }
}

