/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.abilitybots.api.toggle;

import java.util.HashMap;
import java.util.Map;
import org.telegram.abilitybots.api.objects.Ability;
import org.telegram.abilitybots.api.toggle.AbilityToggle;

public class CustomToggle
implements AbilityToggle {
    public static final String OFF = "turn_off_base_ability";
    private final Map<String, String> baseMapping = new HashMap<String, String>();

    @Override
    public boolean isOff(Ability ability) {
        return OFF.equalsIgnoreCase(this.baseMapping.get(ability.name()));
    }

    @Override
    public Ability processAbility(Ability ability) {
        if (this.baseMapping.containsKey(ability.name())) {
            return Ability.builder().basedOn(ability).name(this.baseMapping.get(ability.name())).build();
        }
        return ability;
    }

    public CustomToggle toggle(String abilityName, String targetName) {
        this.baseMapping.put(abilityName, targetName);
        return this;
    }

    public CustomToggle turnOff(String ability) {
        this.baseMapping.put(ability, OFF);
        return this;
    }
}

