/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.abilitybots.api.objects;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.telegram.telegrambots.abilitybots.api.bot.BaseAbilityBot;
import org.telegram.telegrambots.meta.api.objects.Update;

public class Reply {
    public final List<Predicate<Update>> conditions;
    public final BiConsumer<BaseAbilityBot, Update> action;
    private boolean statsEnabled;
    private String name;

    Reply(List<Predicate<Update>> conditions, BiConsumer<BaseAbilityBot, Update> action) {
        this.conditions = ImmutableList.builder().addAll(conditions).build();
        this.action = action;
        this.statsEnabled = false;
    }

    Reply(List<Predicate<Update>> conditions, BiConsumer<BaseAbilityBot, Update> action, String name) {
        this(conditions, action);
        if (Objects.nonNull(name)) {
            this.enableStats(name);
        }
    }

    public static Reply of(BiConsumer<BaseAbilityBot, Update> action, List<Predicate<Update>> conditions) {
        return new Reply(conditions, action);
    }

    @SafeVarargs
    public static Reply of(BiConsumer<BaseAbilityBot, Update> action, Predicate<Update> ... conditions) {
        return Reply.of(action, Lists.newArrayList((Object[])conditions));
    }

    public boolean isOkFor(Update update) {
        BiFunction<Boolean, Predicate, Boolean> stateAnd = (state, cond) -> state != false && cond.test(update);
        return this.conditions.stream().reduce(true, stateAnd, Boolean::logicalAnd);
    }

    public void actOn(BaseAbilityBot bot, Update update) {
        this.action.accept(bot, update);
    }

    public List<Predicate<Update>> conditions() {
        return this.conditions;
    }

    public BiConsumer<BaseAbilityBot, Update> action() {
        return this.action;
    }

    public Stream<Reply> stream() {
        return Stream.of(this);
    }

    public Reply enableStats(String name) {
        this.name = name;
        this.statsEnabled = true;
        return this;
    }

    public boolean statsEnabled() {
        return this.statsEnabled;
    }

    public String name() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Reply reply = (Reply)o;
        return Objects.equals(this.conditions, reply.conditions) && Objects.equals(this.action, reply.action);
    }

    public int hashCode() {
        return Objects.hash(this.conditions, this.action);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("conditions", this.conditions).add("action", this.action).toString();
    }
}

