/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.abilitybots.api.sender;

import java.io.Serializable;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.telegram.telegrambots.abilitybots.api.sender.SentCallback;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendMessage;
import org.telegram.telegrambots.meta.api.objects.message.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ForceReplyKeyboard;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.generics.TelegramClient;

public class SilentSender {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SilentSender.class);
    private final TelegramClient telegramClient;

    public SilentSender(TelegramClient telegramClient) {
        this.telegramClient = telegramClient;
    }

    public Optional<Message> send(String message, long id) {
        return this.doSendMessage(message, id, false);
    }

    public Optional<Message> sendMd(String message, long id) {
        return this.doSendMessage(message, id, true);
    }

    public Optional<Message> forceReply(String message, long id) {
        SendMessage msg = new SendMessage(Long.toString(id), message);
        ForceReplyKeyboard kb = new ForceReplyKeyboard();
        kb.setForceReply(Boolean.valueOf(true));
        kb.setSelective(Boolean.valueOf(true));
        msg.setReplyMarkup((ReplyKeyboard)kb);
        return this.execute(msg);
    }

    public <T extends Serializable, Method extends BotApiMethod<T>> Optional<T> execute(Method method) {
        try {
            return Optional.ofNullable(this.telegramClient.execute(method));
        }
        catch (TelegramApiException e) {
            log.error("Could not execute bot API method", (Throwable)e);
            return Optional.empty();
        }
    }

    public <T extends Serializable, Method extends BotApiMethod<T>, Callback extends SentCallback<T>> void executeAsync(Method method, Callback callable) {
        try {
            CompletableFuture futureResult = this.telegramClient.executeAsync(method);
            callable.onResult(method, (Serializable)((Serializable)futureResult.get(5L, TimeUnit.SECONDS)));
        }
        catch (InterruptedException | ExecutionException | TimeoutException | TelegramApiException e) {
            callable.onException(method, (Exception)e);
        }
    }

    private Optional<Message> doSendMessage(String txt, long groupId, boolean format) {
        SendMessage smsg = new SendMessage(Long.toString(groupId), txt);
        smsg.enableMarkdown(format);
        return this.execute(smsg);
    }
}

