/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.session;

import java.util.Optional;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.DefaultSessionManager;
import org.apache.shiro.session.mgt.SessionContext;
import org.apache.shiro.session.mgt.SessionKey;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.apache.shiro.session.mgt.eis.SessionIdGenerator;
import org.telegram.telegrambots.bots.DefaultBotOptions;
import org.telegram.telegrambots.bots.TelegramLongPollingBot;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.session.ChatIdConverter;
import org.telegram.telegrambots.session.DefaultChatIdConverter;
import org.telegram.telegrambots.session.DefaultChatSessionContext;

public abstract class TelegramLongPollingSessionBot
extends TelegramLongPollingBot {
    DefaultSessionManager sessionManager;
    ChatIdConverter chatIdConverter;

    public TelegramLongPollingSessionBot() {
        this(new DefaultChatIdConverter());
    }

    public TelegramLongPollingSessionBot(ChatIdConverter chatIdConverter) {
        this(chatIdConverter, new DefaultBotOptions());
    }

    public TelegramLongPollingSessionBot(ChatIdConverter chatIdConverter, DefaultBotOptions defaultBotOptions) {
        super(defaultBotOptions);
        this.setSessionManager(new DefaultSessionManager());
        this.setChatIdConverter(chatIdConverter);
        AbstractSessionDAO sessionDAO = (AbstractSessionDAO)this.sessionManager.getSessionDAO();
        sessionDAO.setSessionIdGenerator((SessionIdGenerator)chatIdConverter);
    }

    public void setSessionManager(DefaultSessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public void setChatIdConverter(ChatIdConverter chatIdConverter) {
        this.chatIdConverter = chatIdConverter;
    }

    public void onUpdateReceived(Update update) {
        Message message;
        if (update.hasMessage()) {
            message = update.getMessage();
        } else if (update.hasCallbackQuery()) {
            message = update.getCallbackQuery().getMessage();
        } else {
            Optional<Session> chatSession = Optional.empty();
            this.onUpdateReceived(update, chatSession);
            return;
        }
        this.chatIdConverter.setSessionId(message.getChatId());
        Optional<Session> chatSession = this.getSession(message);
        this.onUpdateReceived(update, chatSession);
    }

    public Optional<Session> getSession(Message message) {
        try {
            return Optional.of(this.sessionManager.getSession((SessionKey)this.chatIdConverter));
        }
        catch (UnknownSessionException e) {
            DefaultChatSessionContext botSession = new DefaultChatSessionContext(message.getChatId(), message.getFrom().getUserName());
            return Optional.of(this.sessionManager.start((SessionContext)botSession));
        }
    }

    public abstract void onUpdateReceived(Update var1, Optional<Session> var2);
}

