/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.client.jetty;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import lombok.NonNull;
import org.apache.commons.io.FileUtils;
import org.eclipse.jetty.client.CompletableResponseListener;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.client.InputStreamResponseListener;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.StringRequestContent;
import org.telegram.telegrambots.client.AbstractTelegramClient;
import org.telegram.telegrambots.client.ThrowingConsumer;
import org.telegram.telegrambots.client.jetty.JettyMultipartBuilder;
import org.telegram.telegrambots.meta.TelegramUrl;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.botapimethods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.methods.groupadministration.SetChatPhoto;
import org.telegram.telegrambots.meta.api.methods.send.SendAnimation;
import org.telegram.telegrambots.meta.api.methods.send.SendAudio;
import org.telegram.telegrambots.meta.api.methods.send.SendDocument;
import org.telegram.telegrambots.meta.api.methods.send.SendMediaBotMethod;
import org.telegram.telegrambots.meta.api.methods.send.SendMediaGroup;
import org.telegram.telegrambots.meta.api.methods.send.SendPaidMedia;
import org.telegram.telegrambots.meta.api.methods.send.SendPhoto;
import org.telegram.telegrambots.meta.api.methods.send.SendSticker;
import org.telegram.telegrambots.meta.api.methods.send.SendVideo;
import org.telegram.telegrambots.meta.api.methods.send.SendVideoNote;
import org.telegram.telegrambots.meta.api.methods.send.SendVoice;
import org.telegram.telegrambots.meta.api.methods.stickers.AddStickerToSet;
import org.telegram.telegrambots.meta.api.methods.stickers.CreateNewStickerSet;
import org.telegram.telegrambots.meta.api.methods.stickers.ReplaceStickerInSet;
import org.telegram.telegrambots.meta.api.methods.stickers.SetStickerSetThumbnail;
import org.telegram.telegrambots.meta.api.methods.stickers.UploadStickerFile;
import org.telegram.telegrambots.meta.api.methods.updates.SetWebhook;
import org.telegram.telegrambots.meta.api.methods.updatingmessages.EditMessageMedia;
import org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaAnimation;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaAudio;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaDocument;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaVideo;
import org.telegram.telegrambots.meta.api.objects.media.paid.InputPaidMedia;
import org.telegram.telegrambots.meta.api.objects.media.paid.InputPaidMediaVideo;
import org.telegram.telegrambots.meta.api.objects.message.Message;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;

public class JettyTelegramClient
extends AbstractTelegramClient {
    private final HttpClient client;
    private final String botToken;
    private final TelegramUrl telegramUrl;
    private final ObjectMapper objectMapper;

    public JettyTelegramClient(@NonNull ObjectMapper objectMapper, @NonNull HttpClient client, @NonNull String botToken, @NonNull TelegramUrl telegramUrl) {
        if (objectMapper == null) {
            throw new NullPointerException("objectMapper is marked non-null but is null");
        }
        if (client == null) {
            throw new NullPointerException("client is marked non-null but is null");
        }
        if (botToken == null) {
            throw new NullPointerException("botToken is marked non-null but is null");
        }
        if (telegramUrl == null) {
            throw new NullPointerException("telegramUrl is marked non-null but is null");
        }
        this.objectMapper = objectMapper;
        this.client = client;
        this.botToken = botToken;
        this.telegramUrl = telegramUrl;
    }

    public JettyTelegramClient(HttpClient client, String botToken, TelegramUrl telegramUrl) {
        this(new ObjectMapper(), client, botToken, telegramUrl);
    }

    public JettyTelegramClient(HttpClient client, String botToken) {
        this(client, botToken, TelegramUrl.DEFAULT_URL);
    }

    public JettyTelegramClient(String botToken, TelegramUrl telegramUrl) {
        this(JettyTelegramClient.createHttpClient(), botToken, telegramUrl);
    }

    public JettyTelegramClient(String botToken) {
        this(JettyTelegramClient.createHttpClient(), botToken);
    }

    public <T extends Serializable, Method extends BotApiMethod<T>> CompletableFuture<T> executeAsync(Method method) throws TelegramApiException {
        if (method == null) {
            throw new TelegramApiException("Parameter method can not be null");
        }
        method.validate();
        try {
            URI url = this.buildUrl(method.getMethod());
            String body = this.objectMapper.writeValueAsString(method);
            Request request = this.client.POST(url).headers(httpFields -> {
                httpFields.add("charset", StandardCharsets.UTF_8.name());
                httpFields.add("content-type", "application/json");
            }).body((Request.Content)new StringRequestContent("application/json", body));
            return this.sendRequest(method, request);
        }
        catch (IOException e) {
            throw new TelegramApiException("Unable to execute " + method.getMethod() + " method", (Throwable)e);
        }
    }

    public CompletableFuture<Message> executeAsync(SendDocument sendDocument) {
        return this.executeMediaMethod(sendDocument, builder -> {
            builder.addPart("caption", sendDocument.getCaption()).addPart("parse_mode", sendDocument.getParseMode()).addPart("disable_content_type_detection", sendDocument.getDisableContentTypeDetection()).addPart("business_connection_id", sendDocument.getBusinessConnectionId()).addJsonPart("caption_entities", sendDocument.getCaptionEntities());
            if (sendDocument.getThumbnail() != null) {
                builder.addInputFile("thumbnail", sendDocument.getThumbnail(), false);
                builder.addPart("thumbnail", sendDocument.getThumbnail().getAttachName());
            }
        });
    }

    public CompletableFuture<Message> executeAsync(SendPhoto sendPhoto) {
        return this.executeMediaMethod(sendPhoto, builder -> builder.addPart("caption", sendPhoto.getCaption()).addPart("parse_mode", sendPhoto.getParseMode()).addPart("has_spoiler", sendPhoto.getHasSpoiler()).addPart("business_connection_id", sendPhoto.getBusinessConnectionId()).addPart("show_caption_above_media", sendPhoto.getShowCaptionAboveMedia()).addJsonPart("caption_entities", sendPhoto.getCaptionEntities()));
    }

    public CompletableFuture<Boolean> executeAsync(SetWebhook setWebhook) {
        try {
            this.assertParamNotNull(setWebhook, "method");
            setWebhook.validate();
            URI url = this.buildUrl(setWebhook.getMethod());
            JettyMultipartBuilder builder = new JettyMultipartBuilder(this.objectMapper);
            builder.addPart("url", setWebhook.getUrl()).addPart("max_connections", setWebhook.getMaxConnections()).addJsonPart("allowed_updates", setWebhook.getAllowedUpdates()).addPart("ip_address", setWebhook.getIpAddress()).addPart("drop_pending_updates", setWebhook.getDropPendingUpdates()).addPart("secret_token", setWebhook.getSecretToken());
            builder.addInputFile("certificate", setWebhook.getCertificate(), true);
            Request httpPost = this.client.POST(url).body((Request.Content)builder.build());
            return this.sendRequest(setWebhook, httpPost);
        }
        catch (TelegramApiException e) {
            return CompletableFuture.failedFuture(e);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new TelegramApiException("Unable to execute " + setWebhook.getMethod(), (Throwable)e));
        }
    }

    public CompletableFuture<Message> executeAsync(SendVideo sendVideo) {
        return this.executeMediaMethod(sendVideo, builder -> {
            builder.addPart("caption", sendVideo.getCaption()).addPart("parse_mode", sendVideo.getParseMode()).addPart("supports_streaming", sendVideo.getSupportsStreaming()).addPart("duration", sendVideo.getDuration()).addPart("width", sendVideo.getWidth()).addPart("height", sendVideo.getHeight()).addPart("has_spoiler", sendVideo.getHasSpoiler()).addPart("business_connection_id", sendVideo.getBusinessConnectionId()).addPart("show_caption_above_media", sendVideo.getShowCaptionAboveMedia()).addJsonPart("caption_entities", sendVideo.getCaptionEntities());
            if (sendVideo.getThumbnail() != null) {
                builder.addInputFile("thumbnail", sendVideo.getThumbnail(), false);
                builder.addPart("thumbnail", sendVideo.getThumbnail().getAttachName());
            }
        });
    }

    public CompletableFuture<Message> executeAsync(SendVideoNote sendVideoNote) {
        return this.executeMediaMethod(sendVideoNote, builder -> {
            builder.addPart("duration", sendVideoNote.getDuration()).addPart("length", sendVideoNote.getLength()).addPart("business_connection_id", sendVideoNote.getBusinessConnectionId());
            if (sendVideoNote.getThumbnail() != null) {
                builder.addInputFile("thumbnail", sendVideoNote.getThumbnail(), false);
                builder.addPart("thumbnail", sendVideoNote.getThumbnail().getAttachName());
            }
        });
    }

    public CompletableFuture<Message> executeAsync(SendSticker sendSticker) {
        return this.executeMediaMethod(sendSticker, builder -> builder.addPart("emoji", sendSticker.getEmoji()).addPart("business_connection_id", sendSticker.getBusinessConnectionId()));
    }

    public CompletableFuture<Message> executeAsync(SendAudio sendAudio) {
        return this.executeMediaMethod(sendAudio, builder -> {
            builder.addPart("performer", sendAudio.getPerformer()).addPart("title", sendAudio.getTitle()).addPart("duration", sendAudio.getDuration()).addPart("caption", sendAudio.getCaption()).addPart("parse_mode", sendAudio.getParseMode()).addPart("business_connection_id", sendAudio.getBusinessConnectionId()).addJsonPart("caption_entities", sendAudio.getCaptionEntities());
            if (sendAudio.getThumbnail() != null) {
                builder.addInputFile("thumbnail", sendAudio.getThumbnail(), false);
                builder.addPart("thumbnail", sendAudio.getThumbnail().getAttachName());
            }
        });
    }

    public CompletableFuture<Message> executeAsync(SendVoice sendVoice) {
        return this.executeMediaMethod(sendVoice, builder -> builder.addPart("duration", sendVoice.getDuration()).addPart("caption", sendVoice.getCaption()).addPart("parse_mode", sendVoice.getParseMode()).addPart("business_connection_id", sendVoice.getBusinessConnectionId()).addPart("show_caption_above_media", sendVoice.getShowCaptionAboveMedia()).addJsonPart("caption_entities", sendVoice.getCaptionEntities()));
    }

    public CompletableFuture<List<Message>> executeAsync(SendPaidMedia sendPaidMedia) {
        try {
            this.assertParamNotNull(sendPaidMedia, "sendPaidMedia");
            sendPaidMedia.validate();
            URI url = this.buildUrl(sendPaidMedia.getMethod());
            JettyMultipartBuilder builder = new JettyMultipartBuilder(this.objectMapper);
            this.addPaidInputData(builder, "media", sendPaidMedia.getMedia());
            builder.addPart("chat_id", sendPaidMedia.getChatId()).addPart("star_count", sendPaidMedia.getStarCount()).addPart("caption", sendPaidMedia.getCaption()).addPart("parse_mode", sendPaidMedia.getParseMode()).addPart("show_caption_above_media", sendPaidMedia.getShowCaptionAboveMedia()).addPart("disable_notification", sendPaidMedia.getDisableNotification()).addPart("protect_content", sendPaidMedia.getProtectContent()).addPart("business_connection_id", sendPaidMedia.getBusinessConnectionId()).addPart("payload", sendPaidMedia.getPayload()).addPart("allow_paid_broadcast", sendPaidMedia.getAllowPaidBroadcast()).addJsonPart("caption_entities", sendPaidMedia.getCaptionEntities()).addJsonPart("reply_markup", sendPaidMedia.getReplyMarkup()).addJsonPart("reply_parameters", sendPaidMedia.getReplyParameters());
            Request httpPost = this.client.POST(url).body((Request.Content)builder.build());
            return this.sendRequest(sendPaidMedia, httpPost).thenApply(list -> list);
        }
        catch (TelegramApiException e) {
            return CompletableFuture.failedFuture(e);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new TelegramApiException("Unable to execute " + sendPaidMedia.getMethod(), (Throwable)e));
        }
    }

    public CompletableFuture<List<Message>> executeAsync(SendMediaGroup sendMediaGroup) {
        try {
            this.assertParamNotNull(sendMediaGroup, "sendMediaGroup");
            sendMediaGroup.validate();
            URI url = this.buildUrl(sendMediaGroup.getMethod());
            JettyMultipartBuilder builder = new JettyMultipartBuilder(this.objectMapper);
            this.addInputData(builder, "media", sendMediaGroup.getMedias());
            builder.addPart("chat_id", sendMediaGroup.getChatId()).addPart("disable_notification", sendMediaGroup.getDisableNotification()).addPart("reply_to_message_id", sendMediaGroup.getReplyToMessageId()).addPart("message_thread_id", sendMediaGroup.getMessageThreadId()).addPart("allow_sending_without_reply", sendMediaGroup.getAllowSendingWithoutReply()).addPart("protect_content", sendMediaGroup.getProtectContent()).addPart("business_connection_id", sendMediaGroup.getBusinessConnectionId()).addPart("message_effect_id", sendMediaGroup.getMessageEffectId()).addPart("allow_paid_broadcast", sendMediaGroup.getAllowSendingWithoutReply()).addJsonPart("reply_markup", sendMediaGroup.getReplyMarkup()).addJsonPart("reply_parameters", sendMediaGroup.getReplyParameters());
            Request httpPost = this.client.POST(url).body((Request.Content)builder.build());
            return this.sendRequest(sendMediaGroup, httpPost).thenApply(list -> list);
        }
        catch (TelegramApiException e) {
            return CompletableFuture.failedFuture(e);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new TelegramApiException("Unable to execute " + sendMediaGroup.getMethod(), (Throwable)e));
        }
    }

    public CompletableFuture<Message> executeAsync(SendAnimation sendAnimation) {
        return this.executeMediaMethod(sendAnimation, builder -> {
            builder.addPart("duration", sendAnimation.getDuration()).addPart("width", sendAnimation.getWidth()).addPart("height", sendAnimation.getHeight()).addPart("caption", sendAnimation.getCaption()).addJsonPart("caption_entities", sendAnimation.getCaptionEntities()).addPart("parse_mode", sendAnimation.getParseMode()).addPart("has_spoiler", sendAnimation.getHasSpoiler()).addPart("business_connection_id", sendAnimation.getBusinessConnectionId()).addPart("show_caption_above_media", sendAnimation.getShowCaptionAboveMedia()).addJsonPart("reply_markup", sendAnimation.getReplyMarkup());
            if (sendAnimation.getThumbnail() != null) {
                builder.addInputFile("thumbnail", sendAnimation.getThumbnail(), false);
                builder.addPart("thumbnail", sendAnimation.getThumbnail().getAttachName());
            }
        });
    }

    public CompletableFuture<Boolean> executeAsync(SetChatPhoto setChatPhoto) {
        try {
            this.assertParamNotNull(setChatPhoto, "setChatPhoto");
            setChatPhoto.validate();
            URI url = this.buildUrl(setChatPhoto.getMethod());
            JettyMultipartBuilder builder = new JettyMultipartBuilder(this.objectMapper);
            builder.addPart("chat_id", setChatPhoto.getChatId());
            builder.addInputFile("photo", setChatPhoto.getPhoto(), false);
            Request httpPost = this.client.POST(url).body((Request.Content)builder.build());
            return this.sendRequest(setChatPhoto, httpPost);
        }
        catch (TelegramApiException e) {
            return CompletableFuture.failedFuture(e);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new TelegramApiException("Unable to execute " + setChatPhoto.getMethod(), (Throwable)e));
        }
    }

    public CompletableFuture<Boolean> executeAsync(AddStickerToSet addStickerToSet) {
        try {
            this.assertParamNotNull(addStickerToSet, "addStickerToSet");
            addStickerToSet.validate();
            URI url = this.buildUrl(addStickerToSet.getMethod());
            JettyMultipartBuilder builder = new JettyMultipartBuilder(this.objectMapper);
            builder.addPart("user_id", addStickerToSet.getUserId()).addPart("name", addStickerToSet.getName());
            builder.addInputStickers("sticker", Collections.singletonList(addStickerToSet.getSticker()));
            Request httpPost = this.client.POST(url).body((Request.Content)builder.build());
            return this.sendRequest(addStickerToSet, httpPost);
        }
        catch (TelegramApiException e) {
            return CompletableFuture.failedFuture(e);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new TelegramApiException("Unable to execute " + addStickerToSet.getMethod(), (Throwable)e));
        }
    }

    public CompletableFuture<Boolean> executeAsync(ReplaceStickerInSet replaceStickerInSet) {
        try {
            this.assertParamNotNull(replaceStickerInSet, "replaceStickerInSet");
            replaceStickerInSet.validate();
            URI url = this.buildUrl(replaceStickerInSet.getMethod());
            JettyMultipartBuilder builder = new JettyMultipartBuilder(this.objectMapper);
            builder.addPart("user_id", replaceStickerInSet.getUserId()).addPart("old_sticker", replaceStickerInSet.getOldSticker()).addPart("name", replaceStickerInSet.getName());
            builder.addInputStickers("sticker", Collections.singletonList(replaceStickerInSet.getSticker()));
            Request httpPost = this.client.POST(url).body((Request.Content)builder.build());
            return this.sendRequest(replaceStickerInSet, httpPost);
        }
        catch (TelegramApiException e) {
            return CompletableFuture.failedFuture(e);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new TelegramApiException("Unable to execute " + replaceStickerInSet.getMethod(), (Throwable)e));
        }
    }

    public CompletableFuture<Boolean> executeAsync(SetStickerSetThumbnail setStickerSetThumbnail) {
        try {
            this.assertParamNotNull(setStickerSetThumbnail, "setStickerSetThumbail");
            setStickerSetThumbnail.validate();
            URI url = this.buildUrl(setStickerSetThumbnail.getMethod());
            JettyMultipartBuilder builder = new JettyMultipartBuilder(this.objectMapper);
            builder.addPart("user_id", setStickerSetThumbnail.getUserId()).addPart("name", setStickerSetThumbnail.getName()).addPart("format", setStickerSetThumbnail.getFormat()).addPart("thumbnail", setStickerSetThumbnail.getThumbnail());
            Request httpPost = this.client.POST(url).body((Request.Content)builder.build());
            return this.sendRequest(setStickerSetThumbnail, httpPost);
        }
        catch (TelegramApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    public CompletableFuture<Boolean> executeAsync(CreateNewStickerSet createNewStickerSet) {
        try {
            this.assertParamNotNull(createNewStickerSet, "createNewStickerSet");
            createNewStickerSet.validate();
            URI url = this.buildUrl(createNewStickerSet.getMethod());
            JettyMultipartBuilder builder = new JettyMultipartBuilder(this.objectMapper);
            builder.addPart("user_id", createNewStickerSet.getUserId()).addPart("name", createNewStickerSet.getName()).addPart("title", createNewStickerSet.getTitle()).addPart("sticker_type", createNewStickerSet.getStickerType()).addPart("needs_repainting", createNewStickerSet.getNeedsRepainting()).addInputStickers("stickers", createNewStickerSet.getStickers());
            Request httpPost = this.client.POST(url).body((Request.Content)builder.build());
            return this.sendRequest(createNewStickerSet, httpPost);
        }
        catch (TelegramApiException e) {
            return CompletableFuture.failedFuture(e);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new TelegramApiException("Unable to execute " + createNewStickerSet.getMethod(), (Throwable)e));
        }
    }

    public CompletableFuture<org.telegram.telegrambots.meta.api.objects.File> executeAsync(UploadStickerFile uploadStickerFile) {
        try {
            this.assertParamNotNull(uploadStickerFile, "uploadStickerFile");
            uploadStickerFile.validate();
            URI url = this.buildUrl(uploadStickerFile.getMethod());
            JettyMultipartBuilder builder = new JettyMultipartBuilder(this.objectMapper);
            builder.addPart("user_id", uploadStickerFile.getUserId()).addPart("sticker_format", uploadStickerFile.getStickerFormat()).addInputFile("sticker", uploadStickerFile.getSticker(), true);
            Request httpPost = this.client.POST(url).body((Request.Content)builder.build());
            return this.sendRequest(uploadStickerFile, httpPost);
        }
        catch (TelegramApiException e) {
            return CompletableFuture.failedFuture(e);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new TelegramApiException("Unable to execute " + uploadStickerFile.getMethod(), (Throwable)e));
        }
    }

    public CompletableFuture<Serializable> executeAsync(EditMessageMedia editMessageMedia) {
        try {
            this.assertParamNotNull(editMessageMedia, "editMessageMedia");
            editMessageMedia.validate();
            URI url = this.buildUrl(editMessageMedia.getMethod());
            JettyMultipartBuilder builder = new JettyMultipartBuilder(this.objectMapper);
            builder.addPart("chat_id", editMessageMedia.getChatId()).addPart("message_id", editMessageMedia.getMessageId()).addPart("inline_message_id", editMessageMedia.getInlineMessageId()).addPart("business_connection_id", editMessageMedia.getBusinessConnectionId()).addJsonPart("reply_markup", editMessageMedia.getReplyMarkup());
            this.addInputData(builder, "media", editMessageMedia.getMedia(), true);
            Request httpPost = this.client.POST(url).body((Request.Content)builder.build());
            return this.sendRequest(editMessageMedia, httpPost);
        }
        catch (TelegramApiException e) {
            return CompletableFuture.failedFuture(e);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new TelegramApiException("Unable to execute " + editMessageMedia.getMethod(), (Throwable)e));
        }
    }

    public CompletableFuture<File> downloadFileAsync(org.telegram.telegrambots.meta.api.objects.File file) {
        return this.downloadFileAsStreamAsync(file).thenApply(stream -> {
            try {
                File outputFile = this.getTempFile();
                FileUtils.copyInputStreamToFile((InputStream)stream, (File)outputFile);
                return outputFile;
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to write file to disk", e);
            }
            catch (TelegramApiException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public CompletableFuture<InputStream> downloadFileAsStreamAsync(org.telegram.telegrambots.meta.api.objects.File file) {
        try {
            if (file == null) {
                throw new TelegramApiException("Parameter file can not be null");
            }
            InputStreamResponseListener listener = new InputStreamResponseListener();
            this.client.newRequest(file.getFileUrl(this.botToken)).send((Response.CompleteListener)listener);
            return CompletableFuture.completedFuture(listener.getInputStream());
        }
        catch (TelegramApiException e) {
            return CompletableFuture.failedFuture(e);
        }
    }

    private <T extends Serializable, Method extends PartialBotApiMethod<T>> CompletableFuture<T> sendRequest(Method method, Request request) {
        CompletableFuture future = new CompletableResponseListener(request).send();
        return future.thenApply(response -> {
            try {
                return method.deserializeResponse(response.getContentAsString());
            }
            catch (TelegramApiRequestException e) {
                throw new CompletionException(e);
            }
        });
    }

    private <T extends Serializable, Method extends SendMediaBotMethod<T>> CompletableFuture<T> executeMediaMethod(Method method, ThrowingConsumer<JettyMultipartBuilder, IOException> setup) {
        try {
            this.assertParamNotNull(method, "method");
            this.assertParamNotNull(setup, "setup");
            method.validate();
            URI url = this.buildUrl(method.getMethod());
            JettyMultipartBuilder builder = new JettyMultipartBuilder(this.objectMapper);
            builder.addInputFile(method.getFileField(), method.getFile(), true);
            builder.addPart("chat_id", method.getChatId()).addPart("message_thread_id", method.getMessageThreadId()).addPart("reply_to_message_id", method.getReplyToMessageId()).addPart("disable_notification", method.getDisableNotification()).addPart("protect_content", method.getProtectContent()).addPart("allow_sending_without_reply", method.getAllowSendingWithoutReply()).addPart("message_effect_id", method.getMessageEffectId()).addJsonPart("reply_parameters", method.getReplyParameters()).addJsonPart("reply_markup", method.getReplyMarkup());
            setup.accept(builder);
            Request httpPost = this.client.POST(url).body((Request.Content)builder.build());
            return this.sendRequest(method, httpPost);
        }
        catch (TelegramApiException e) {
            return CompletableFuture.failedFuture(e);
        }
        catch (IOException e) {
            return CompletableFuture.failedFuture(new TelegramApiException("Unable to execute " + method.getMethod(), (Throwable)e));
        }
    }

    private URI buildUrl(String methodPath) {
        String path = "/bot" + this.botToken;
        if (this.telegramUrl.isTestServer()) {
            path = path + "/test";
        }
        path = path + "/" + methodPath;
        URI uri = new URI(this.telegramUrl.getSchema(), null, this.telegramUrl.getHost(), this.telegramUrl.getPort(), path, null, null);
        return uri;
    }

    private void addInputData(JettyMultipartBuilder builder, String mediaField, InputMedia media, boolean addField) throws IOException {
        InputMediaAnimation animation;
        if (media.isNewMedia()) {
            builder.addMedia(media);
        }
        if (media instanceof InputMediaAudio) {
            InputMediaAudio audio = (InputMediaAudio)media;
            if (audio.getThumbnail() != null) {
                builder.addInputFile("thumbnail", audio.getThumbnail(), false);
            }
        } else if (media instanceof InputMediaDocument) {
            InputMediaDocument document = (InputMediaDocument)media;
            if (document.getThumbnail() != null) {
                builder.addInputFile("thumbnail", document.getThumbnail(), false);
            }
        } else if (media instanceof InputMediaVideo) {
            InputMediaVideo video = (InputMediaVideo)media;
            if (video.getThumbnail() != null) {
                builder.addInputFile("thumbnail", video.getThumbnail(), false);
            }
        } else if (media instanceof InputMediaAnimation && (animation = (InputMediaAnimation)media).getThumbnail() != null) {
            builder.addInputFile("thumbnail", animation.getThumbnail(), false);
        }
        if (addField) {
            builder.addJsonPart(mediaField, media);
        }
    }

    private void addInputData(JettyMultipartBuilder builder, String mediaField, InputPaidMedia media, boolean addField) throws IOException {
        InputPaidMediaVideo document;
        if (media.isNewMedia()) {
            builder.addMedia(media);
        }
        if (media instanceof InputPaidMediaVideo && (document = (InputPaidMediaVideo)media).getThumbnail() != null) {
            builder.addInputFile("thumbnail", document.getThumbnail(), false);
        }
        if (addField) {
            builder.addJsonPart(mediaField, media);
        }
    }

    private void addPaidInputData(JettyMultipartBuilder builder, String mediaField, List<InputPaidMedia> media) throws IOException {
        for (InputPaidMedia inputMedia : media) {
            this.addInputData(builder, null, inputMedia, false);
        }
        builder.addJsonPart(mediaField, media);
    }

    private void addInputData(JettyMultipartBuilder builder, String mediaField, List<InputMedia> media) throws IOException {
        for (InputMedia inputMedia : media) {
            this.addInputData(builder, null, inputMedia, false);
        }
        builder.addJsonPart(mediaField, media);
    }

    private void assertParamNotNull(Object param, String paramName) throws TelegramApiException {
        if (param == null) {
            throw new TelegramApiException("Parameter " + paramName + " can not be null");
        }
    }

    private File getTempFile() throws TelegramApiException {
        try {
            return File.createTempFile(Long.toString(System.currentTimeMillis()), ".tmp");
        }
        catch (IOException e) {
            throw new TelegramApiException("Error downloading file", (Throwable)e);
        }
    }

    private static HttpClient createHttpClient() {
        HttpClient httpClient = new HttpClient();
        httpClient.start();
        return httpClient;
    }
}

