/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.client.okhttp;

import java.io.IOException;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.telegram.telegrambots.meta.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;

class OkHttpFutureCallback<T extends Serializable, Method extends PartialBotApiMethod<T>>
extends CompletableFuture<T>
implements Callback {
    private final Method method;

    OkHttpFutureCallback(Method method) {
        this.method = method;
    }

    public void onFailure(Call call, IOException e) {
        this.completeExceptionally(e);
    }

    public void onResponse(Call call, Response response) throws IOException {
        try (ResponseBody body = response.body();){
            if (body == null) {
                this.completeExceptionally(new TelegramApiException("Telegram api returned empty response"));
            } else {
                try {
                    this.complete(this.method.deserializeResponse(body.string()));
                }
                catch (TelegramApiRequestException e) {
                    this.completeExceptionally(e);
                }
            }
        }
    }
}

