/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.client.okhttp;

import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;

class OkHttpFutureDownloadCallback
extends CompletableFuture<InputStream>
implements Callback {
    OkHttpFutureDownloadCallback() {
    }

    public void onFailure(Call call, IOException e) {
        this.completeExceptionally(e);
    }

    public void onResponse(Call call, Response response) throws IOException {
        try (ResponseBody body = response.body();){
            if (body == null) {
                this.completeExceptionally(new TelegramApiException("Telegram api returned empty response"));
            } else {
                this.complete(body.byteStream());
            }
        }
    }
}

