/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.util.List;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import org.telegram.telegrambots.meta.api.objects.media.paid.InputPaidMedia;
import org.telegram.telegrambots.meta.api.objects.stickers.InputSticker;

public class TelegramMultipartBuilder {
    public final MultipartBody.Builder internalBuilder = new MultipartBody.Builder().setType(MultipartBody.FORM);
    private final ObjectMapper mapper;

    public TelegramMultipartBuilder(ObjectMapper mapper) {
        this.mapper = mapper;
    }

    public MultipartBody build() {
        return this.internalBuilder.build();
    }

    public TelegramMultipartBuilder addPart(String fieldName, String value) {
        if (value != null) {
            this.internalBuilder.addFormDataPart(fieldName, value);
        }
        return this;
    }

    public TelegramMultipartBuilder addPart(String fieldName, Object value) {
        if (value != null) {
            this.addPart(fieldName, value.toString());
        }
        return this;
    }

    public TelegramMultipartBuilder addJsonPart(String fieldName, Object value) throws JsonProcessingException {
        if (value != null) {
            this.internalBuilder.addFormDataPart(fieldName, this.mapper.writeValueAsString(value));
        }
        return this;
    }

    public TelegramMultipartBuilder addInputFile(String fileField, InputFile file, boolean addField) throws IOException {
        if (file == null) {
            return this;
        }
        if (file.isNew()) {
            RequestBody body = null;
            if (file.getNewMediaFile() != null) {
                body = RequestBody.create((File)file.getNewMediaFile(), (MediaType)MediaType.parse((String)"application/octet-stream"));
            } else if (file.getNewMediaStream() != null) {
                body = RequestBody.create((byte[])file.getNewMediaStream().readAllBytes(), (MediaType)MediaType.parse((String)"application/octet-stream"));
            }
            if (body != null) {
                this.internalBuilder.addFormDataPart(file.getMediaName(), file.getMediaName(), body);
            }
        }
        if (addField) {
            this.internalBuilder.addFormDataPart(fileField, file.getAttachName());
        }
        return this;
    }

    public TelegramMultipartBuilder addMedia(InputMedia media) throws IOException {
        if (media == null) {
            return this;
        }
        if (media.isNewMedia()) {
            RequestBody body = null;
            if (media.getNewMediaFile() != null) {
                body = RequestBody.create((File)media.getNewMediaFile(), (MediaType)MediaType.parse((String)"application/octet-stream"));
            } else if (media.getNewMediaStream() != null) {
                body = RequestBody.create((byte[])media.getNewMediaStream().readAllBytes(), (MediaType)MediaType.parse((String)"application/octet-stream"));
            }
            if (body != null) {
                this.internalBuilder.addFormDataPart(media.getMediaName(), media.getMediaName(), body);
            }
        }
        return this;
    }

    public TelegramMultipartBuilder addMedia(InputPaidMedia media) throws IOException {
        if (media == null) {
            return this;
        }
        if (media.isNewMedia()) {
            RequestBody body = null;
            if (media.getNewMediaFile() != null) {
                body = RequestBody.create((File)media.getNewMediaFile(), (MediaType)MediaType.parse((String)"application/octet-stream"));
            } else if (media.getNewMediaStream() != null) {
                body = RequestBody.create((byte[])media.getNewMediaStream().readAllBytes(), (MediaType)MediaType.parse((String)"application/octet-stream"));
            }
            if (body != null) {
                this.internalBuilder.addFormDataPart(media.getMediaName(), media.getMediaName(), body);
            }
        }
        return this;
    }

    public TelegramMultipartBuilder addInputStickers(String stickersField, List<InputSticker> stickers) throws IOException {
        for (InputSticker sticker : stickers) {
            this.addInputFile(null, sticker.getSticker(), false);
        }
        this.addJsonPart(stickersField, stickers);
        return this;
    }
}

