/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.longpolling;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.NonNull;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.telegram.telegrambots.longpolling.exceptions.TelegramApiErrorResponseException;
import org.telegram.telegrambots.longpolling.interfaces.BackOff;
import org.telegram.telegrambots.longpolling.interfaces.LongPollingUpdateConsumer;
import org.telegram.telegrambots.meta.TelegramUrl;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.methods.updates.DeleteWebhook;
import org.telegram.telegrambots.meta.api.methods.updates.GetUpdates;
import org.telegram.telegrambots.meta.api.objects.Update;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;

public class BotSession
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(BotSession.class);
    private AtomicBoolean running = new AtomicBoolean(false);
    private AtomicInteger lastReceivedUpdate = new AtomicInteger(0);
    private final ObjectMapper objectMapper;
    private final OkHttpClient okHttpClient;
    private final ScheduledExecutorService executor;
    private final String botToken;
    private final LongPollingUpdateConsumer updatesConsumer;
    private final Supplier<TelegramUrl> telegramUrlSupplier;
    private final Function<Integer, GetUpdates> getUpdatesGenerator;
    private final BackOff backOff;
    private volatile ScheduledFuture<?> runningPolling = null;

    public BotSession(ObjectMapper objectMapper, OkHttpClient okHttpClient, ScheduledExecutorService executor, String botToken, Supplier<TelegramUrl> telegramUrlSupplier, Function<Integer, GetUpdates> getUpdatesGenerator, Supplier<BackOff> backOffSupplier, LongPollingUpdateConsumer updatesConsumer) {
        this.executor = executor;
        this.okHttpClient = okHttpClient;
        this.updatesConsumer = updatesConsumer;
        this.botToken = botToken;
        this.telegramUrlSupplier = telegramUrlSupplier;
        this.getUpdatesGenerator = getUpdatesGenerator;
        this.objectMapper = objectMapper;
        this.backOff = backOffSupplier.get();
    }

    public void start() throws TelegramApiException {
        if (this.runningPolling == null) {
            this.runningPolling = this.createPollerTask();
        }
    }

    public void stop() {
        if (this.runningPolling != null) {
            this.runningPolling.cancel(false);
            this.runningPolling = null;
        }
    }

    public boolean isRunning() {
        return this.runningPolling != null && !this.runningPolling.isCancelled();
    }

    @Override
    public void close() throws TelegramApiException {
        this.stop();
    }

    @NonNull
    private ScheduledFuture<?> createPollerTask() throws TelegramApiException {
        this.executeDeleteWebhook();
        return this.executor.scheduleAtFixedRate(() -> {
            try {
                List<Update> updates = this.getUpdatesFromTelegram();
                this.backOff.reset();
                if (!updates.isEmpty()) {
                    updates.removeIf(x -> x.getUpdateId() <= this.lastReceivedUpdate.get());
                    this.lastReceivedUpdate.set(updates.parallelStream().mapToInt(Update::getUpdateId).max().orElse(this.lastReceivedUpdate.get()));
                    this.updatesConsumer.consume(updates);
                }
            }
            catch (TelegramApiErrorResponseException e) {
                long backOffMillis = this.backOff.nextBackOffMillis();
                log.error("Error received from Telegram GetUpdates Request, retrying in {} millis...", (Object)backOffMillis, (Object)e);
                try {
                    Thread.sleep(backOffMillis);
                }
                catch (InterruptedException ex) {
                    log.warn("GetUpdates got interrupted while sleeping in backoff mode.", (Throwable)ex);
                }
            }
            catch (TelegramApiException e) {
                log.error(e.getLocalizedMessage(), (Throwable)e);
            }
        }, 1L, 1L, TimeUnit.MICROSECONDS);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Update> getUpdatesFromTelegram() throws TelegramApiRequestException, TelegramApiErrorResponseException {
        try {
            TelegramUrl telegramUrl = this.telegramUrlSupplier.get();
            GetUpdates getUpdates = this.getUpdatesGenerator.apply(this.lastReceivedUpdate.get());
            Request request = this.createRequest(telegramUrl, (BotApiMethod<?>)getUpdates);
            try (Response response = this.okHttpClient.newCall(request).execute();){
                if (!response.isSuccessful()) throw new TelegramApiErrorResponseException(response.code(), response.message());
                try (ResponseBody body = response.body();){
                    if (body == null) return Collections.emptyList();
                    ArrayList updates = getUpdates.deserializeResponse(body.string());
                    this.backOff.reset();
                    ArrayList arrayList = updates;
                    return arrayList;
                }
            }
        }
        catch (Exception e) {
            throw new TelegramApiErrorResponseException(e);
        }
    }

    private void executeDeleteWebhook() throws TelegramApiRequestException, TelegramApiErrorResponseException {
        block16: {
            DeleteWebhook deleteWebhook = new DeleteWebhook();
            try {
                Request request = this.createRequest(this.telegramUrlSupplier.get(), (BotApiMethod<?>)deleteWebhook);
                try (Response response = this.okHttpClient.newCall(request).execute();){
                    if (response.isSuccessful()) {
                        try (ResponseBody body = response.body();){
                            Boolean result;
                            if (body != null && !Optional.ofNullable(result = deleteWebhook.deserializeResponse(body.string())).orElse(false).booleanValue()) {
                                throw new TelegramApiErrorResponseException("Unable to delete Webhook");
                            }
                            break block16;
                        }
                    }
                    throw new TelegramApiErrorResponseException(response.code(), response.message());
                }
            }
            catch (IOException e) {
                throw new TelegramApiErrorResponseException("Unable to execute " + deleteWebhook.getMethod() + " method", e);
            }
        }
    }

    @NonNull
    private Request createRequest(TelegramUrl telegramUrl, BotApiMethod<?> apiMethod) throws JsonProcessingException {
        return new Request.Builder().url(this.buildUrl(telegramUrl, apiMethod.getMethod())).header("charset", StandardCharsets.UTF_8.name()).header("content-type", "application/json").post(RequestBody.create((String)this.objectMapper.writeValueAsString(apiMethod), (MediaType)MediaType.parse((String)"application/json"))).build();
    }

    @NonNull
    private HttpUrl buildUrl(TelegramUrl telegramUrl, String methodPath) {
        return new HttpUrl.Builder().scheme(telegramUrl.getSchema()).host(telegramUrl.getHost()).port(telegramUrl.getPort()).addPathSegment("bot" + this.botToken).addPathSegment(methodPath).build();
    }

    public AtomicBoolean getRunning() {
        return this.running;
    }

    public AtomicInteger getLastReceivedUpdate() {
        return this.lastReceivedUpdate;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public OkHttpClient getOkHttpClient() {
        return this.okHttpClient;
    }

    public ScheduledExecutorService getExecutor() {
        return this.executor;
    }

    public String getBotToken() {
        return this.botToken;
    }

    public LongPollingUpdateConsumer getUpdatesConsumer() {
        return this.updatesConsumer;
    }

    public Supplier<TelegramUrl> getTelegramUrlSupplier() {
        return this.telegramUrlSupplier;
    }

    public Function<Integer, GetUpdates> getGetUpdatesGenerator() {
        return this.getUpdatesGenerator;
    }

    public BackOff getBackOff() {
        return this.backOff;
    }

    public ScheduledFuture<?> getRunningPolling() {
        return this.runningPolling;
    }

    public void setRunning(AtomicBoolean running) {
        this.running = running;
    }

    public void setLastReceivedUpdate(AtomicInteger lastReceivedUpdate) {
        this.lastReceivedUpdate = lastReceivedUpdate;
    }

    public void setRunningPolling(ScheduledFuture<?> runningPolling) {
        this.runningPolling = runningPolling;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BotSession)) {
            return false;
        }
        BotSession other = (BotSession)o;
        if (!other.canEqual(this)) {
            return false;
        }
        AtomicBoolean this$running = this.getRunning();
        AtomicBoolean other$running = other.getRunning();
        if (this$running == null ? other$running != null : !this$running.equals(other$running)) {
            return false;
        }
        AtomicInteger this$lastReceivedUpdate = this.getLastReceivedUpdate();
        AtomicInteger other$lastReceivedUpdate = other.getLastReceivedUpdate();
        if (this$lastReceivedUpdate == null ? other$lastReceivedUpdate != null : !this$lastReceivedUpdate.equals(other$lastReceivedUpdate)) {
            return false;
        }
        ObjectMapper this$objectMapper = this.getObjectMapper();
        ObjectMapper other$objectMapper = other.getObjectMapper();
        if (this$objectMapper == null ? other$objectMapper != null : !this$objectMapper.equals(other$objectMapper)) {
            return false;
        }
        OkHttpClient this$okHttpClient = this.getOkHttpClient();
        OkHttpClient other$okHttpClient = other.getOkHttpClient();
        if (this$okHttpClient == null ? other$okHttpClient != null : !this$okHttpClient.equals(other$okHttpClient)) {
            return false;
        }
        ScheduledExecutorService this$executor = this.getExecutor();
        ScheduledExecutorService other$executor = other.getExecutor();
        if (this$executor == null ? other$executor != null : !this$executor.equals(other$executor)) {
            return false;
        }
        String this$botToken = this.getBotToken();
        String other$botToken = other.getBotToken();
        if (this$botToken == null ? other$botToken != null : !this$botToken.equals(other$botToken)) {
            return false;
        }
        LongPollingUpdateConsumer this$updatesConsumer = this.getUpdatesConsumer();
        LongPollingUpdateConsumer other$updatesConsumer = other.getUpdatesConsumer();
        if (this$updatesConsumer == null ? other$updatesConsumer != null : !this$updatesConsumer.equals(other$updatesConsumer)) {
            return false;
        }
        Supplier<TelegramUrl> this$telegramUrlSupplier = this.getTelegramUrlSupplier();
        Supplier<TelegramUrl> other$telegramUrlSupplier = other.getTelegramUrlSupplier();
        if (this$telegramUrlSupplier == null ? other$telegramUrlSupplier != null : !this$telegramUrlSupplier.equals(other$telegramUrlSupplier)) {
            return false;
        }
        Function<Integer, GetUpdates> this$getUpdatesGenerator = this.getGetUpdatesGenerator();
        Function<Integer, GetUpdates> other$getUpdatesGenerator = other.getGetUpdatesGenerator();
        if (this$getUpdatesGenerator == null ? other$getUpdatesGenerator != null : !this$getUpdatesGenerator.equals(other$getUpdatesGenerator)) {
            return false;
        }
        BackOff this$backOff = this.getBackOff();
        BackOff other$backOff = other.getBackOff();
        if (this$backOff == null ? other$backOff != null : !this$backOff.equals(other$backOff)) {
            return false;
        }
        ScheduledFuture<?> this$runningPolling = this.getRunningPolling();
        ScheduledFuture<?> other$runningPolling = other.getRunningPolling();
        return !(this$runningPolling == null ? other$runningPolling != null : !this$runningPolling.equals(other$runningPolling));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BotSession;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        AtomicBoolean $running = this.getRunning();
        result = result * 59 + ($running == null ? 43 : $running.hashCode());
        AtomicInteger $lastReceivedUpdate = this.getLastReceivedUpdate();
        result = result * 59 + ($lastReceivedUpdate == null ? 43 : $lastReceivedUpdate.hashCode());
        ObjectMapper $objectMapper = this.getObjectMapper();
        result = result * 59 + ($objectMapper == null ? 43 : $objectMapper.hashCode());
        OkHttpClient $okHttpClient = this.getOkHttpClient();
        result = result * 59 + ($okHttpClient == null ? 43 : $okHttpClient.hashCode());
        ScheduledExecutorService $executor = this.getExecutor();
        result = result * 59 + ($executor == null ? 43 : $executor.hashCode());
        String $botToken = this.getBotToken();
        result = result * 59 + ($botToken == null ? 43 : $botToken.hashCode());
        LongPollingUpdateConsumer $updatesConsumer = this.getUpdatesConsumer();
        result = result * 59 + ($updatesConsumer == null ? 43 : $updatesConsumer.hashCode());
        Supplier<TelegramUrl> $telegramUrlSupplier = this.getTelegramUrlSupplier();
        result = result * 59 + ($telegramUrlSupplier == null ? 43 : $telegramUrlSupplier.hashCode());
        Function<Integer, GetUpdates> $getUpdatesGenerator = this.getGetUpdatesGenerator();
        result = result * 59 + ($getUpdatesGenerator == null ? 43 : $getUpdatesGenerator.hashCode());
        BackOff $backOff = this.getBackOff();
        result = result * 59 + ($backOff == null ? 43 : $backOff.hashCode());
        ScheduledFuture<?> $runningPolling = this.getRunningPolling();
        result = result * 59 + ($runningPolling == null ? 43 : $runningPolling.hashCode());
        return result;
    }

    public String toString() {
        return "BotSession(running=" + this.getRunning() + ", lastReceivedUpdate=" + this.getLastReceivedUpdate() + ", objectMapper=" + this.getObjectMapper() + ", okHttpClient=" + this.getOkHttpClient() + ", executor=" + this.getExecutor() + ", botToken=" + this.getBotToken() + ", updatesConsumer=" + this.getUpdatesConsumer() + ", telegramUrlSupplier=" + this.getTelegramUrlSupplier() + ", getUpdatesGenerator=" + this.getGetUpdatesGenerator() + ", backOff=" + this.getBackOff() + ", runningPolling=" + this.getRunningPolling() + ")";
    }
}

