/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.longpolling.util;

import java.net.Proxy;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import lombok.NonNull;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Dispatcher;
import okhttp3.OkHttpClient;

public class TelegramOkHttpClientFactory {
    private TelegramOkHttpClientFactory() {
    }

    public static class ProxyOkHttpClientCreator
    extends DefaultOkHttpClientCreator {
        private final Supplier<Proxy> proxySupplier;
        private final Supplier<Authenticator> authenticatorSupplier;

        @Override
        public OkHttpClient get() {
            OkHttpClient.Builder okHttpClientBuilder = ProxyOkHttpClientCreator.getBaseClient();
            Optional.ofNullable(this.proxySupplier.get()).ifPresent(arg_0 -> ((OkHttpClient.Builder)okHttpClientBuilder).proxy(arg_0));
            Optional.ofNullable(this.authenticatorSupplier.get()).ifPresent(arg_0 -> ((OkHttpClient.Builder)okHttpClientBuilder).proxyAuthenticator(arg_0));
            return okHttpClientBuilder.build();
        }

        public ProxyOkHttpClientCreator(Supplier<Proxy> proxySupplier, Supplier<Authenticator> authenticatorSupplier) {
            this.proxySupplier = proxySupplier;
            this.authenticatorSupplier = authenticatorSupplier;
        }
    }

    public static class DefaultOkHttpClientCreator
    implements Supplier<OkHttpClient> {
        @Override
        public OkHttpClient get() {
            return DefaultOkHttpClientCreator.getBaseClient().build();
        }

        @NonNull
        protected static OkHttpClient.Builder getBaseClient() {
            Dispatcher dispatcher = new Dispatcher();
            dispatcher.setMaxRequests(100);
            dispatcher.setMaxRequestsPerHost(100);
            return new OkHttpClient().newBuilder().dispatcher(dispatcher).connectionPool(new ConnectionPool(100, 75L, TimeUnit.SECONDS)).readTimeout(100L, TimeUnit.SECONDS).writeTimeout(70L, TimeUnit.SECONDS).connectTimeout(75L, TimeUnit.SECONDS);
        }
    }
}

