/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.api.methods.stickers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.telegram.telegrambots.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.exceptions.TelegramApiValidationException;

public class UploadStickerFile
extends PartialBotApiMethod<org.telegram.telegrambots.api.objects.File> {
    public static final String PATH = "uploadStickerFile";
    public static final String USERID_FIELD = "user_id";
    public static final String PNGSTICKER_FIELD = "png_sticker";
    private Integer userId;
    private File newPngStickerFile;
    private InputStream newPngStickerStream;
    private String newPngStickerName;

    public UploadStickerFile() {
    }

    public UploadStickerFile(Integer userId) {
        this.userId = (Integer)Preconditions.checkNotNull((Object)userId);
    }

    @Override
    public org.telegram.telegrambots.api.objects.File deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<org.telegram.telegrambots.api.objects.File>>(){});
            if (result.getOk().booleanValue()) {
                return (org.telegram.telegrambots.api.objects.File)result.getResult();
            }
            throw new TelegramApiRequestException("Error uploading sticker set", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.userId == null || this.userId <= 0) {
            throw new TelegramApiValidationException("userId can't be empty", this);
        }
        if (this.newPngStickerFile == null && this.newPngStickerStream == null) {
            throw new TelegramApiValidationException("file or stream must be present", this);
        }
        if (this.newPngStickerStream != null && (this.newPngStickerName == null || this.newPngStickerName.isEmpty())) {
            throw new TelegramApiValidationException("Stream name must be present", this);
        }
    }

    public Integer getUserId() {
        return this.userId;
    }

    public UploadStickerFile setUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    public File getNewPngStickerFile() {
        return this.newPngStickerFile;
    }

    public UploadStickerFile setNewPngSticker(File newPngStickerFile) {
        this.newPngStickerFile = newPngStickerFile;
        return this;
    }

    public InputStream getNewPngStickerStream() {
        return this.newPngStickerStream;
    }

    public UploadStickerFile setNewPngSticker(String newPngStickerName, InputStream newPngStickerStream) {
        this.newPngStickerName = newPngStickerName;
        this.newPngStickerStream = newPngStickerStream;
        return this;
    }

    public String getNewPngStickerName() {
        return this.newPngStickerName;
    }

    public String toString() {
        return "UploadStickerFile{userId=" + this.userId + ", newPngStickerFile=" + this.newPngStickerFile + ", newPngStickerStream=" + this.newPngStickerStream + ", newPngStickerName='" + this.newPngStickerName + '\'' + '}';
    }
}

