/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.passport.dataerror.PassportElementError;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetPassportDataErrors
extends BotApiMethod<Boolean> {
    public static final String PATH = "setPassportDataErrors";
    private static final String USERID_FIELD = "user_id";
    private static final String ERRORS_FIELD = "errors";
    @JsonProperty(value="user_id")
    private Integer userId;
    @JsonProperty(value="errors")
    private List<PassportElementError> errors;

    public SetPassportDataErrors(Integer userId, List<PassportElementError> errors) {
        this.userId = (Integer)Preconditions.checkNotNull((Object)userId);
        this.errors = (List)Preconditions.checkNotNull(errors);
    }

    public SetPassportDataErrors() {
    }

    public Integer getUserId() {
        return this.userId;
    }

    public SetPassportDataErrors setUserId(Integer userId) {
        this.userId = userId;
        return this;
    }

    public List<PassportElementError> getErrors() {
        return this.errors;
    }

    public SetPassportDataErrors setErrors(List<PassportElementError> errors) {
        this.errors = errors;
        return this;
    }

    public SetPassportDataErrors addError(PassportElementError error) {
        error = (PassportElementError)Preconditions.checkNotNull((Object)error);
        if (this.errors == null) {
            this.errors = new ArrayList<PassportElementError>();
        }
        this.errors.add(error);
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error setting passport data errors", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.userId == null) {
            throw new TelegramApiValidationException("User ID can't be empty", this);
        }
        if (this.errors == null || this.errors.isEmpty()) {
            throw new TelegramApiValidationException("Errors can't be empty", this);
        }
    }
}

