/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.passport.dataerror;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import org.telegram.telegrambots.meta.api.objects.passport.dataerror.PassportElementError;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class PassportElementErrorFile
implements PassportElementError {
    private static final String SOURCE_FIELD = "source";
    private static final String TYPE_FIELD = "type";
    private static final String FILEHASH_FIELD = "file_hash";
    private static final String MESSAGE_FIELD = "message";
    @JsonProperty(value="source")
    private final String source = "file";
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="file_hash")
    private String fileHash;
    @JsonProperty(value="message")
    private String message;

    public PassportElementErrorFile() {
    }

    public PassportElementErrorFile(String type, String fileHash, String message) {
        this.type = (String)Preconditions.checkNotNull((Object)type);
        this.fileHash = (String)Preconditions.checkNotNull((Object)fileHash);
        this.message = (String)Preconditions.checkNotNull((Object)message);
    }

    public String getType() {
        return this.type;
    }

    public PassportElementErrorFile setType(String type) {
        this.type = (String)Preconditions.checkNotNull((Object)type);
        return this;
    }

    public String getSource() {
        return "file";
    }

    public String getFileHash() {
        return this.fileHash;
    }

    public PassportElementErrorFile setFileHash(String fileHash) {
        this.fileHash = fileHash;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public PassportElementErrorFile setMessage(String message) {
        this.message = (String)Preconditions.checkNotNull((Object)message);
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.fileHash == null || this.fileHash.isEmpty()) {
            throw new TelegramApiValidationException("File hash parameter can't be empty", this);
        }
        if (this.message == null || this.message.isEmpty()) {
            throw new TelegramApiValidationException("Message parameter can't be empty", this);
        }
        if (this.type == null || this.type.isEmpty()) {
            throw new TelegramApiValidationException("Type parameter can't be empty", this);
        }
    }

    public String toString() {
        return "PassportElementErrorFile{source='file', type='" + this.type + '\'' + ", fileHash='" + this.fileHash + '\'' + ", message='" + this.message + '\'' + '}';
    }
}

