/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.objects.Audio;
import org.telegram.telegrambots.meta.api.objects.Chat;
import org.telegram.telegrambots.meta.api.objects.Contact;
import org.telegram.telegrambots.meta.api.objects.Document;
import org.telegram.telegrambots.meta.api.objects.Location;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.PhotoSize;
import org.telegram.telegrambots.meta.api.objects.User;
import org.telegram.telegrambots.meta.api.objects.Venue;
import org.telegram.telegrambots.meta.api.objects.Video;
import org.telegram.telegrambots.meta.api.objects.VideoNote;
import org.telegram.telegrambots.meta.api.objects.Voice;
import org.telegram.telegrambots.meta.api.objects.games.Animation;
import org.telegram.telegrambots.meta.api.objects.games.Game;
import org.telegram.telegrambots.meta.api.objects.passport.PassportData;
import org.telegram.telegrambots.meta.api.objects.payments.Invoice;
import org.telegram.telegrambots.meta.api.objects.payments.SuccessfulPayment;
import org.telegram.telegrambots.meta.api.objects.stickers.Sticker;

public class Message
implements BotApiObject {
    private static final String MESSAGEID_FIELD = "message_id";
    private static final String FROM_FIELD = "from";
    private static final String DATE_FIELD = "date";
    private static final String CHAT_FIELD = "chat";
    private static final String FORWARDFROM_FIELD = "forward_from";
    private static final String FORWARDFROMCHAT_FIELD = "forward_from_chat";
    private static final String FORWARDDATE_FIELD = "forward_date";
    private static final String TEXT_FIELD = "text";
    private static final String ENTITIES_FIELD = "entities";
    private static final String CAPTIONENTITIES_FIELD = "caption_entities";
    private static final String AUDIO_FIELD = "audio";
    private static final String DOCUMENT_FIELD = "document";
    private static final String PHOTO_FIELD = "photo";
    private static final String STICKER_FIELD = "sticker";
    private static final String VIDEO_FIELD = "video";
    private static final String CONTACT_FIELD = "contact";
    private static final String LOCATION_FIELD = "location";
    private static final String VENUE_FIELD = "venue";
    private static final String ANIMATION_FIELD = "animation";
    private static final String PINNED_MESSAGE_FIELD = "pinned_message";
    private static final String NEWCHATMEMBERS_FIELD = "new_chat_members";
    private static final String LEFTCHATMEMBER_FIELD = "left_chat_member";
    private static final String NEWCHATTITLE_FIELD = "new_chat_title";
    private static final String NEWCHATPHOTO_FIELD = "new_chat_photo";
    private static final String DELETECHATPHOTO_FIELD = "delete_chat_photo";
    private static final String GROUPCHATCREATED_FIELD = "group_chat_created";
    private static final String REPLYTOMESSAGE_FIELD = "reply_to_message";
    private static final String VOICE_FIELD = "voice";
    private static final String CAPTION_FIELD = "caption";
    private static final String SUPERGROUPCREATED_FIELD = "supergroup_chat_created";
    private static final String CHANNELCHATCREATED_FIELD = "channel_chat_created";
    private static final String MIGRATETOCHAT_FIELD = "migrate_to_chat_id";
    private static final String MIGRATEFROMCHAT_FIELD = "migrate_from_chat_id";
    private static final String EDITDATE_FIELD = "edit_date";
    private static final String GAME_FIELD = "game";
    private static final String FORWARDFROMMESSAGEID_FIELD = "forward_from_message_id";
    private static final String INVOICE_FIELD = "invoice";
    private static final String SUCCESSFUL_PAYMENT_FIELD = "successful_payment";
    private static final String VIDEO_NOTE_FIELD = "video_note";
    private static final String AUTHORSIGNATURE_FIELD = "author_signature";
    private static final String FORWARDSIGNATURE_FIELD = "forward_signature";
    private static final String MEDIAGROUPID_FIELD = "media_group_id";
    private static final String CONNECTEDWEBSITE_FIELD = "connected_website";
    private static final String PASSPORTDATA_FIELD = "passport_data";
    private static final String FORWARDSENDERNAME_FIELD = "forward_sender_name";
    @JsonProperty(value="message_id")
    private Integer messageId;
    @JsonProperty(value="from")
    private User from;
    @JsonProperty(value="date")
    private Integer date;
    @JsonProperty(value="chat")
    private Chat chat;
    @JsonProperty(value="forward_from")
    private User forwardFrom;
    @JsonProperty(value="forward_from_chat")
    private Chat forwardFromChat;
    @JsonProperty(value="forward_date")
    private Integer forwardDate;
    @JsonProperty(value="text")
    private String text;
    @JsonProperty(value="entities")
    private List<MessageEntity> entities;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;
    @JsonProperty(value="audio")
    private Audio audio;
    @JsonProperty(value="document")
    private Document document;
    @JsonProperty(value="photo")
    private List<PhotoSize> photo;
    @JsonProperty(value="sticker")
    private Sticker sticker;
    @JsonProperty(value="video")
    private Video video;
    @JsonProperty(value="contact")
    private Contact contact;
    @JsonProperty(value="location")
    private Location location;
    @JsonProperty(value="venue")
    private Venue venue;
    @JsonProperty(value="animation")
    private Animation animation;
    @JsonProperty(value="pinned_message")
    private Message pinnedMessage;
    @JsonProperty(value="new_chat_members")
    private List<User> newChatMembers;
    @JsonProperty(value="left_chat_member")
    private User leftChatMember;
    @JsonProperty(value="new_chat_title")
    private String newChatTitle;
    @JsonProperty(value="new_chat_photo")
    private List<PhotoSize> newChatPhoto;
    @JsonProperty(value="delete_chat_photo")
    private Boolean deleteChatPhoto;
    @JsonProperty(value="group_chat_created")
    private Boolean groupchatCreated;
    @JsonProperty(value="reply_to_message")
    private Message replyToMessage;
    @JsonProperty(value="voice")
    private Voice voice;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="supergroup_chat_created")
    private Boolean superGroupCreated;
    @JsonProperty(value="channel_chat_created")
    private Boolean channelChatCreated;
    @JsonProperty(value="migrate_to_chat_id")
    private Long migrateToChatId;
    @JsonProperty(value="migrate_from_chat_id")
    private Long migrateFromChatId;
    @JsonProperty(value="edit_date")
    private Integer editDate;
    @JsonProperty(value="game")
    private Game game;
    @JsonProperty(value="forward_from_message_id")
    private Integer forwardFromMessageId;
    @JsonProperty(value="invoice")
    private Invoice invoice;
    @JsonProperty(value="successful_payment")
    private SuccessfulPayment successfulPayment;
    @JsonProperty(value="video_note")
    private VideoNote videoNote;
    @JsonProperty(value="author_signature")
    private String authorSignature;
    @JsonProperty(value="forward_signature")
    private String forwardSignature;
    @JsonProperty(value="media_group_id")
    private String mediaGroupId;
    @JsonProperty(value="connected_website")
    private String connectedWebsite;
    @JsonProperty(value="passport_data")
    private PassportData passportData;
    @JsonProperty(value="forward_sender_name")
    private String forwardSenderName;

    public Integer getMessageId() {
        return this.messageId;
    }

    public User getFrom() {
        return this.from;
    }

    public Integer getDate() {
        return this.date;
    }

    public Chat getChat() {
        return this.chat;
    }

    public User getForwardFrom() {
        return this.forwardFrom;
    }

    public Integer getForwardDate() {
        return this.forwardDate;
    }

    public String getText() {
        return this.text;
    }

    public List<MessageEntity> getEntities() {
        if (this.entities != null) {
            this.entities.forEach(x -> x.computeText(this.text));
        }
        return this.entities;
    }

    public List<MessageEntity> getCaptionEntities() {
        if (this.captionEntities != null) {
            this.captionEntities.forEach(x -> x.computeText(this.caption));
        }
        return this.captionEntities;
    }

    public Audio getAudio() {
        return this.audio;
    }

    public Document getDocument() {
        return this.document;
    }

    public List<PhotoSize> getPhoto() {
        return this.photo;
    }

    public Sticker getSticker() {
        return this.sticker;
    }

    public boolean hasSticker() {
        return this.sticker != null;
    }

    public Video getVideo() {
        return this.video;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public Contact getContact() {
        return this.contact;
    }

    public Location getLocation() {
        return this.location;
    }

    public Venue getVenue() {
        return this.venue;
    }

    public Message getPinnedMessage() {
        return this.pinnedMessage;
    }

    public List<User> getNewChatMembers() {
        return this.newChatMembers == null ? new ArrayList() : this.newChatMembers;
    }

    public User getLeftChatMember() {
        return this.leftChatMember;
    }

    public String getNewChatTitle() {
        return this.newChatTitle;
    }

    public List<PhotoSize> getNewChatPhoto() {
        return this.newChatPhoto;
    }

    public Boolean getDeleteChatPhoto() {
        return this.deleteChatPhoto;
    }

    public Boolean getGroupchatCreated() {
        return this.groupchatCreated;
    }

    public Message getReplyToMessage() {
        return this.replyToMessage;
    }

    public Voice getVoice() {
        return this.voice;
    }

    public String getCaption() {
        return this.caption;
    }

    public Boolean getSuperGroupCreated() {
        return this.superGroupCreated;
    }

    public Boolean getChannelChatCreated() {
        return this.channelChatCreated;
    }

    public Long getMigrateToChatId() {
        return this.migrateToChatId;
    }

    public Long getMigrateFromChatId() {
        return this.migrateFromChatId;
    }

    public Integer getForwardFromMessageId() {
        return this.forwardFromMessageId;
    }

    public boolean isGroupMessage() {
        return this.chat.isGroupChat();
    }

    public boolean isUserMessage() {
        return this.chat.isUserChat();
    }

    public boolean isChannelMessage() {
        return this.chat.isChannelChat();
    }

    public boolean isSuperGroupMessage() {
        return this.chat.isSuperGroupChat();
    }

    public Long getChatId() {
        return this.chat.getId();
    }

    public boolean hasText() {
        return this.text != null && !this.text.isEmpty();
    }

    public boolean isCommand() {
        if (this.hasText() && this.entities != null) {
            for (MessageEntity entity : this.entities) {
                if (entity == null || entity.getOffset() != 0 || !"bot_command".equals(entity.getType())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasDocument() {
        return this.document != null;
    }

    public boolean hasVideo() {
        return this.video != null;
    }

    public boolean hasAudio() {
        return this.audio != null;
    }

    public boolean hasVoice() {
        return this.voice != null;
    }

    public boolean isReply() {
        return this.replyToMessage != null;
    }

    public boolean hasLocation() {
        return this.location != null;
    }

    public Chat getForwardFromChat() {
        return this.forwardFromChat;
    }

    public Integer getEditDate() {
        return this.editDate;
    }

    public Game getGame() {
        return this.game;
    }

    private boolean hasGame() {
        return this.game != null;
    }

    public boolean hasEntities() {
        return this.entities != null && !this.entities.isEmpty();
    }

    public boolean hasPhoto() {
        return this.photo != null && !this.photo.isEmpty();
    }

    public boolean hasInvoice() {
        return this.invoice != null;
    }

    public boolean hasSuccessfulPayment() {
        return this.successfulPayment != null;
    }

    public boolean hasContact() {
        return this.contact != null;
    }

    public Invoice getInvoice() {
        return this.invoice;
    }

    public SuccessfulPayment getSuccessfulPayment() {
        return this.successfulPayment;
    }

    public VideoNote getVideoNote() {
        return this.videoNote;
    }

    public boolean hasVideoNote() {
        return this.videoNote != null;
    }

    public String getAuthorSignature() {
        return this.authorSignature;
    }

    public String getForwardSignature() {
        return this.forwardSignature;
    }

    public String getMediaGroupId() {
        return this.mediaGroupId;
    }

    public String getConnectedWebsite() {
        return this.connectedWebsite;
    }

    public PassportData getPassportData() {
        return this.passportData;
    }

    public boolean hasPassportData() {
        return this.passportData != null;
    }

    public boolean hasAnimation() {
        return this.animation != null;
    }

    public String getForwardSenderName() {
        return this.forwardSenderName;
    }

    public void setForwardSenderName(String forwardSenderName) {
        this.forwardSenderName = forwardSenderName;
    }

    public String toString() {
        return "Message{messageId=" + this.messageId + ", from=" + this.from + ", date=" + this.date + ", chat=" + this.chat + ", forwardFrom=" + this.forwardFrom + ", forwardFromChat=" + this.forwardFromChat + ", forwardDate=" + this.forwardDate + ", text='" + this.text + '\'' + ", entities=" + this.entities + ", captionEntities=" + this.captionEntities + ", audio=" + this.audio + ", document=" + this.document + ", photo=" + this.photo + ", sticker=" + this.sticker + ", video=" + this.video + ", contact=" + this.contact + ", location=" + this.location + ", venue=" + this.venue + ", pinnedMessage=" + this.pinnedMessage + ", newChatMembers=" + this.newChatMembers + ", leftChatMember=" + this.leftChatMember + ", newChatTitle='" + this.newChatTitle + '\'' + ", newChatPhoto=" + this.newChatPhoto + ", deleteChatPhoto=" + this.deleteChatPhoto + ", groupchatCreated=" + this.groupchatCreated + ", replyToMessage=" + this.replyToMessage + ", voice=" + this.voice + ", caption='" + this.caption + '\'' + ", superGroupCreated=" + this.superGroupCreated + ", channelChatCreated=" + this.channelChatCreated + ", migrateToChatId=" + this.migrateToChatId + ", migrateFromChatId=" + this.migrateFromChatId + ", editDate=" + this.editDate + ", game=" + this.game + ", forwardFromMessageId=" + this.forwardFromMessageId + ", invoice=" + this.invoice + ", successfulPayment=" + this.successfulPayment + ", videoNote=" + this.videoNote + ", authorSignature='" + this.authorSignature + '\'' + ", forwardSignature='" + this.forwardSignature + '\'' + ", mediaGroupId='" + this.mediaGroupId + '\'' + ", connectedWebsite='" + this.connectedWebsite + '\'' + ", passportData=" + this.passportData + '}';
    }
}

