/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetChatPhoto
extends PartialBotApiMethod<Boolean> {
    public static final String PATH = "setChatPhoto";
    public static final String CHATID_FIELD = "chat_id";
    public static final String PHOTO_FIELD = "photo";
    private String chatId;
    private String photoName;
    private InputStream photoStream;
    private File photo;

    public SetChatPhoto() {
    }

    public SetChatPhoto(String chatId, File photo) {
        this.chatId = (String)Preconditions.checkNotNull((Object)chatId);
        this.photo = (File)Preconditions.checkNotNull((Object)photo);
    }

    public SetChatPhoto(String chatId, InputStream photoStream, String photoName) {
        this.chatId = (String)Preconditions.checkNotNull((Object)chatId);
        this.photoStream = (InputStream)Preconditions.checkNotNull((Object)photoStream);
        this.photoName = (String)Preconditions.checkNotNull((Object)photoName);
    }

    public SetChatPhoto(Long chatId, File photo) {
        this.chatId = ((Long)Preconditions.checkNotNull((Object)chatId)).toString();
        this.photo = (File)Preconditions.checkNotNull((Object)photo);
    }

    public SetChatPhoto(Long chatId, InputStream photoStream, String photoName) {
        this.chatId = ((Long)Preconditions.checkNotNull((Object)chatId)).toString();
        this.photoStream = (InputStream)Preconditions.checkNotNull((Object)photoStream);
        this.photoName = (String)Preconditions.checkNotNull((Object)photoName);
    }

    public String getChatId() {
        return this.chatId;
    }

    public SetChatPhoto setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public SetChatPhoto setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public SetChatPhoto setPhoto(File file) {
        this.photo = file;
        return this;
    }

    public SetChatPhoto setNewPhoto(String photoName, InputStream inputStream) {
        Objects.requireNonNull(photoName, "photoName cannot be null!");
        Objects.requireNonNull(inputStream, "inputStream cannot be null!");
        this.photoName = photoName;
        this.photoStream = inputStream;
        return this;
    }

    public String getPhotoName() {
        return this.photoName;
    }

    public InputStream getPhotoStream() {
        return this.photoStream;
    }

    public File getPhoto() {
        return this.photo;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error setting chat photo", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.photo == null) {
            if (this.photoStream == null) {
                throw new TelegramApiValidationException("Photo parameter is required", this);
            }
            if (this.photoName == null || this.photoName.isEmpty()) {
                throw new TelegramApiValidationException("Photo name can't be empty", this);
            }
        }
    }

    public String toString() {
        return "SetChatPhoto{chatId='" + this.chatId + '\'' + ", photoName='" + this.photoName + '\'' + ", photoStream=" + this.photoStream + ", photo=" + this.photo + '}';
    }
}

