/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetStickerPositionInSet
extends BotApiMethod<Boolean> {
    private static final String PATH = "setStickerPositionInSet";
    private static final String STICKER_FIELD = "sticker";
    private static final String POSITION_FIELD = "position";
    @JsonProperty(value="sticker")
    private String sticker;
    @JsonProperty(value="position")
    private Integer position;

    public SetStickerPositionInSet(String sticker, Integer position) {
        this.sticker = (String)Preconditions.checkNotNull((Object)sticker);
        this.position = (Integer)Preconditions.checkNotNull((Object)position);
    }

    public SetStickerPositionInSet() {
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error setting sticker position in set", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.sticker == null || this.sticker.isEmpty()) {
            throw new TelegramApiValidationException("sticker can't be null", this);
        }
        if (this.position == null || this.position < 0) {
            throw new TelegramApiValidationException("position can't be null", this);
        }
    }

    public String getSticker() {
        return this.sticker;
    }

    public SetStickerPositionInSet setSticker(String sticker) {
        this.sticker = (String)Preconditions.checkNotNull((Object)sticker);
        return this;
    }

    public Integer getPosition() {
        return this.position;
    }

    public SetStickerPositionInSet setPosition(Integer position) {
        this.position = (Integer)Preconditions.checkNotNull((Object)position);
        return this;
    }

    public String toString() {
        return "SetStickerPositionInSet{sticker='" + this.sticker + '\'' + ", position=" + this.position + '}';
    }
}

