/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.exceptions;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.json.JSONObject;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.ResponseParameters;
import org.telegram.telegrambots.meta.exceptions.TelegramApiException;
import org.telegram.telegrambots.meta.logging.BotLogger;

public class TelegramApiRequestException
extends TelegramApiException {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String ERRORDESCRIPTIONFIELD = "description";
    private static final String ERRORCODEFIELD = "error_code";
    private static final String PARAMETERSFIELD = "parameters";
    private String apiResponse = null;
    private Integer errorCode = 0;
    private ResponseParameters parameters;

    public TelegramApiRequestException(String message) {
        super(message);
    }

    public TelegramApiRequestException(String message, JSONObject object) {
        super(message);
        this.apiResponse = object.getString(ERRORDESCRIPTIONFIELD);
        this.errorCode = object.getInt(ERRORCODEFIELD);
        if (object.has(PARAMETERSFIELD)) {
            try {
                this.parameters = (ResponseParameters)OBJECT_MAPPER.readValue(object.getJSONObject(PARAMETERSFIELD).toString(), ResponseParameters.class);
            }
            catch (IOException e) {
                BotLogger.severe("APIEXCEPTION", e);
            }
        }
    }

    public TelegramApiRequestException(String message, ApiResponse response) {
        super(message);
        this.apiResponse = response.getErrorDescription();
        this.errorCode = response.getErrorCode();
        this.parameters = response.getParameters();
    }

    public TelegramApiRequestException(String message, Throwable cause) {
        super(message, cause);
    }

    public String getApiResponse() {
        return this.apiResponse;
    }

    public Integer getErrorCode() {
        return this.errorCode;
    }

    public ResponseParameters getParameters() {
        return this.parameters;
    }

    @Override
    public String toString() {
        if (this.apiResponse == null) {
            return super.toString();
        }
        if (this.errorCode == null) {
            return super.toString() + ": " + this.apiResponse;
        }
        return super.toString() + ": [" + this.errorCode + "] " + this.apiResponse;
    }
}

