/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ApiContext {
    private static final Logger log = LogManager.getLogger(ApiContext.class);
    private static final Object lock = new Object();
    private static Injector INJECTOR;
    private static Map<Class, Class> bindings;
    private static Map<Class, Class> singletonBindings;

    public static <T> T getInstance(Class<T> type) {
        return (T)ApiContext.getInjector().getInstance(type);
    }

    public static <T, S extends T> void register(Class<T> type, Class<S> implementation) {
        if (bindings.containsKey(type)) {
            log.debug(MessageFormat.format("Class {0} already registered", type.getName()));
        }
        bindings.put(type, implementation);
    }

    public static <T, S extends T> void registerSingleton(Class<T> type, Class<S> implementation) {
        if (singletonBindings.containsKey(type)) {
            log.debug(MessageFormat.format("Class {0} already registered", type.getName()));
        }
        singletonBindings.put(type, implementation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Injector getInjector() {
        if (INJECTOR == null) {
            Object object = lock;
            synchronized (object) {
                if (INJECTOR == null) {
                    INJECTOR = Guice.createInjector((Module[])new Module[]{new ApiModule()});
                }
            }
        }
        return INJECTOR;
    }

    static {
        bindings = new HashMap<Class, Class>();
        singletonBindings = new HashMap<Class, Class>();
    }

    private static class ApiModule
    extends AbstractModule {
        private ApiModule() {
        }

        protected void configure() {
            for (Map.Entry binding : bindings.entrySet()) {
                this.bind((Class)binding.getKey()).to((Class)binding.getValue());
            }
            for (Map.Entry binding : singletonBindings.entrySet()) {
                this.bind((Class)binding.getKey()).to((Class)binding.getValue()).in(Singleton.class);
            }
        }
    }
}

