/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.stickers.MaskPosition;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class CreateNewStickerSet
extends PartialBotApiMethod<Boolean> {
    public static final String PATH = "createNewStickerSet";
    public static final String USERID_FIELD = "user_id";
    public static final String NAME_FIELD = "name";
    public static final String TITLE_FIELD = "title";
    public static final String PNGSTICKER_FIELD = "png_sticker";
    public static final String EMOJIS_FIELD = "emojis";
    public static final String CONTAINSMASKS_FIELD = "contains_masks";
    public static final String MASKPOSITION_FIELD = "mask_position";
    private Integer userId;
    private String name;
    private String title;
    private String emojis;
    private Boolean containsMasks;
    private MaskPosition maskPosition;
    private InputFile pngSticker;

    public CreateNewStickerSet() {
    }

    public CreateNewStickerSet(Integer userId, String name, String title, String emojis) {
        this.userId = (Integer)Preconditions.checkNotNull((Object)userId);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.title = (String)Preconditions.checkNotNull((Object)title);
        this.emojis = (String)Preconditions.checkNotNull((Object)emojis);
    }

    public Integer getUserId() {
        return this.userId;
    }

    public void setUserId(Integer userId) {
        this.userId = userId;
    }

    public InputFile getPngSticker() {
        return this.pngSticker;
    }

    public CreateNewStickerSet setPngSticker(String pngSticker) {
        this.pngSticker = new InputFile(pngSticker);
        return this;
    }

    public CreateNewStickerSet setPngStickerFile(InputFile pngStickerFile) {
        Objects.requireNonNull(pngStickerFile, "pngStickerFile cannot be null!");
        this.pngSticker = pngStickerFile;
        return this;
    }

    public CreateNewStickerSet setPngStickerFile(File pngStickerFile) {
        Objects.requireNonNull(pngStickerFile, "pngStickerFile cannot be null!");
        this.pngSticker = new InputFile(pngStickerFile, pngStickerFile.getName());
        return this;
    }

    public CreateNewStickerSet setPngStickerStream(String pngStickerName, InputStream pngStickerStream) {
        Objects.requireNonNull(pngStickerName, "pngStickerName cannot be null!");
        Objects.requireNonNull(pngStickerStream, "pngStickerStream cannot be null!");
        this.pngSticker = new InputFile(pngStickerStream, pngStickerName);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getEmojis() {
        return this.emojis;
    }

    public void setEmojis(String emojis) {
        this.emojis = emojis;
    }

    public Boolean getContainsMasks() {
        return this.containsMasks;
    }

    public void setContainsMasks(Boolean containsMasks) {
        this.containsMasks = containsMasks;
    }

    public MaskPosition getMaskPosition() {
        return this.maskPosition;
    }

    public void setMaskPosition(MaskPosition maskPosition) {
        this.maskPosition = maskPosition;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error creating new sticker set", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.userId == null || this.userId <= 0) {
            throw new TelegramApiValidationException("userId can't be empty", this);
        }
        if (this.name == null || this.name.isEmpty()) {
            throw new TelegramApiValidationException("name can't be empty", this);
        }
        if (this.title == null || this.title.isEmpty()) {
            throw new TelegramApiValidationException("title can't be empty", this);
        }
        if (this.emojis == null || this.emojis.isEmpty()) {
            throw new TelegramApiValidationException("emojis can't be empty", this);
        }
        if (this.pngSticker == null) {
            throw new TelegramApiValidationException("PngSticker parameter can't be empty", this);
        }
        this.pngSticker.validate();
        if (this.maskPosition != null) {
            this.maskPosition.validate();
        }
    }

    public String toString() {
        return "CreateNewStickerSet{userId=" + this.userId + ", name='" + this.name + '\'' + ", title='" + this.title + '\'' + ", emojis='" + this.emojis + '\'' + ", containsMasks=" + this.containsMasks + ", maskPosition=" + this.maskPosition + ", pngSticker=" + this.pngSticker + '}';
    }
}

