/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.polls;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SendPoll
extends BotApiMethod<Message> {
    public static final String PATH = "sendPoll";
    private static final String CHATID_FIELD = "chat_id";
    private static final String QUESTION_FIELD = "question";
    private static final String OPTIONS_FIELD = "options";
    private static final String ISANONYMOUS_FIELD = "is_anonymous";
    private static final String TYPE_FIELD = "type";
    private static final String ALLOWMULTIPLEANSWERS_FIELD = "allows_multiple_answers";
    private static final String CORRECTOPTIONID_FIELD = "correct_option_id";
    private static final String ISCLOSED_FIELD = "is_closed";
    private static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    private static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    private static final String REPLYMARKUP_FIELD = "reply_markup";
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="question")
    private String question;
    @JsonProperty(value="options")
    private List<String> options = new ArrayList<String>();
    @JsonProperty(value="is_anonymous")
    private Boolean isAnonymous;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="allows_multiple_answers")
    private Boolean allowMultipleAnswers;
    @JsonProperty(value="correct_option_id")
    private Integer correctOptionId;
    @JsonProperty(value="is_closed")
    private Boolean isClosed;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="reply_to_message_id")
    private Integer replyToMessageId;
    @JsonProperty(value="reply_markup")
    @JsonDeserialize
    private ReplyKeyboard replyMarkup;

    public SendPoll() {
    }

    public SendPoll(String chatId, String question, List<String> options) {
        this.chatId = (String)Preconditions.checkNotNull((Object)chatId);
        this.question = (String)Preconditions.checkNotNull((Object)question);
        this.options = (List)Preconditions.checkNotNull(options);
    }

    public SendPoll(Long chatId, String question, List<String> options) {
        this.chatId = ((Long)Preconditions.checkNotNull((Object)chatId)).toString();
        this.question = (String)Preconditions.checkNotNull((Object)question);
        this.options = (List)Preconditions.checkNotNull(options);
    }

    public String getChatId() {
        return this.chatId;
    }

    public SendPoll setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public SendPoll setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public String getQuestion() {
        return this.question;
    }

    public SendPoll setQuestion(String question) {
        this.question = question;
        return this;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public SendPoll setOptions(List<String> options) {
        this.options = options;
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendPoll setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendPoll setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendPoll enableNotification() {
        this.disableNotification = null;
        return this;
    }

    public SendPoll disableNotification() {
        this.disableNotification = true;
        return this;
    }

    public Boolean getAnonymous() {
        return this.isAnonymous;
    }

    public SendPoll setAnonymous(Boolean anonymous) {
        this.isAnonymous = anonymous;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public SendPoll setType(String type) {
        this.type = type;
        return this;
    }

    public Boolean getAllowMultipleAnswers() {
        return this.allowMultipleAnswers;
    }

    public SendPoll setAllowMultipleAnswers(Boolean allowMultipleAnswers) {
        this.allowMultipleAnswers = allowMultipleAnswers;
        return this;
    }

    public Integer getCorrectOptionId() {
        return this.correctOptionId;
    }

    public SendPoll setCorrectOptionId(Integer correctOptionId) {
        this.correctOptionId = correctOptionId;
        return this;
    }

    public Boolean getClosed() {
        return this.isClosed;
    }

    public SendPoll setClosed(Boolean closed) {
        this.isClosed = closed;
        return this;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return (Message)result.getResult();
            }
            throw new TelegramApiRequestException("Error sending poll", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.question == null || this.question.isEmpty()) {
            throw new TelegramApiValidationException("Question parameter can't be empty", this);
        }
        if (this.options == null || this.options.size() < 2 || this.options.size() > 10) {
            throw new TelegramApiValidationException("Options parameter must be between 2 and 10 item", this);
        }
        if (this.options.parallelStream().anyMatch(x -> x.isEmpty() || x.length() > 100)) {
            throw new TelegramApiValidationException("Options parameter values must be between 1 and 100 chars length", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SendPoll)) {
            return false;
        }
        SendPoll sendPoll = (SendPoll)o;
        return Objects.equals(this.chatId, sendPoll.chatId) && Objects.equals(this.question, sendPoll.question) && Objects.equals(this.options, sendPoll.options) && Objects.equals(this.isAnonymous, sendPoll.isAnonymous) && Objects.equals(this.type, sendPoll.type) && Objects.equals(this.allowMultipleAnswers, sendPoll.allowMultipleAnswers) && Objects.equals(this.correctOptionId, sendPoll.correctOptionId) && Objects.equals(this.isClosed, sendPoll.isClosed) && Objects.equals(this.disableNotification, sendPoll.disableNotification) && Objects.equals(this.replyToMessageId, sendPoll.replyToMessageId) && Objects.equals(this.replyMarkup, sendPoll.replyMarkup);
    }

    public int hashCode() {
        return Objects.hash(this.chatId, this.question, this.options, this.isAnonymous, this.type, this.allowMultipleAnswers, this.correctOptionId, this.isClosed, this.disableNotification, this.replyToMessageId, this.replyMarkup);
    }

    public String toString() {
        return "SendPoll{chatId='" + this.chatId + '\'' + ", question='" + this.question + '\'' + ", options=" + this.options + ", isAnonymous=" + this.isAnonymous + ", type='" + this.type + '\'' + ", allowMultipleAnswers=" + this.allowMultipleAnswers + ", correctOptionId=" + this.correctOptionId + ", isClosed=" + this.isClosed + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + '}';
    }
}

