/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.interfaces.InputBotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class LoginUrl
implements InputBotApiObject,
Validable {
    private static final String URL_FIELD = "url";
    private static final String FORWARD_TEXT_FIELD = "forward_text";
    private static final String BOT_USERNAME_FIELD = "bot_username";
    private static final String REQUEST_WRITE_ACCESS_FIELD = "request_write_access";
    @JsonProperty(value="url")
    private String url;
    @JsonProperty(value="forward_text")
    private String forwardText;
    @JsonProperty(value="bot_username")
    private String botUsername;
    @JsonProperty(value="request_write_access")
    private Boolean requestWriteAccess;

    public LoginUrl() {
    }

    public LoginUrl(String url) {
        this.url = (String)Preconditions.checkNotNull((Object)url);
    }

    public String getUrl() {
        return this.url;
    }

    public LoginUrl setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getForwardText() {
        return this.forwardText;
    }

    public LoginUrl setForwardText(String forwardText) {
        this.forwardText = forwardText;
        return this;
    }

    public String getBotUsername() {
        return this.botUsername;
    }

    public LoginUrl setBotUsername(String botUsername) {
        this.botUsername = botUsername;
        return this;
    }

    public Boolean getRequestWriteAccess() {
        return this.requestWriteAccess;
    }

    public LoginUrl setRequestWriteAccess(Boolean requestWriteAccess) {
        this.requestWriteAccess = requestWriteAccess;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.url == null || this.url.isEmpty()) {
            throw new TelegramApiValidationException("Url parameter can't be empty", this);
        }
    }

    public String toString() {
        return "LoginUrl{url='" + this.url + '\'' + ", forwardText='" + this.forwardText + '\'' + ", botUsername='" + this.botUsername + '\'' + ", requestWriteAccess=" + this.requestWriteAccess + '}';
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LoginUrl)) {
            return false;
        }
        LoginUrl loginUrl = (LoginUrl)o;
        return Objects.equals(this.url, loginUrl.url) && Objects.equals(this.forwardText, loginUrl.forwardText) && Objects.equals(this.botUsername, loginUrl.botUsername) && Objects.equals(this.requestWriteAccess, loginUrl.requestWriteAccess);
    }

    public int hashCode() {
        return Objects.hash(this.url, this.forwardText, this.botUsername, this.requestWriteAccess);
    }
}

