/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.core.type.TypeReference;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.telegram.telegrambots.meta.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SendDocument
extends PartialBotApiMethod<Message> {
    public static final String PATH = "senddocument";
    public static final String CHATID_FIELD = "chat_id";
    public static final String DOCUMENT_FIELD = "document";
    public static final String CAPTION_FIELD = "caption";
    public static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    public static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    public static final String REPLYMARKUP_FIELD = "reply_markup";
    public static final String PARSEMODE_FIELD = "parse_mode";
    public static final String THUMB_FIELD = "thumb";
    private String chatId;
    private InputFile document;
    private String caption;
    private Boolean disableNotification;
    private Integer replyToMessageId;
    private ReplyKeyboard replyMarkup;
    private String parseMode;
    private InputFile thumb;

    public String getChatId() {
        return this.chatId;
    }

    public SendDocument setChatId(String chatId) {
        this.chatId = chatId;
        return this;
    }

    public SendDocument setChatId(Long chatId) {
        Objects.requireNonNull(chatId);
        this.chatId = chatId.toString();
        return this;
    }

    public InputFile getDocument() {
        return this.document;
    }

    public SendDocument setDocument(String document) {
        this.document = new InputFile(document);
        return this;
    }

    public SendDocument setDocument(File file) {
        Objects.requireNonNull(file, "documentName cannot be null!");
        this.document = new InputFile(file, file.getName());
        return this;
    }

    public SendDocument setDocument(InputFile document) {
        Objects.requireNonNull(document, "document cannot be null!");
        this.document = document;
        return this;
    }

    public SendDocument setDocument(String documentName, InputStream inputStream) {
        Objects.requireNonNull(documentName, "documentName cannot be null!");
        Objects.requireNonNull(inputStream, "inputStream cannot be null!");
        this.document = new InputFile(inputStream, documentName);
        return this;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public SendDocument setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
        return this;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public SendDocument enableNotification() {
        this.disableNotification = false;
        return this;
    }

    public SendDocument disableNotification() {
        this.disableNotification = true;
        return this;
    }

    public String getCaption() {
        return this.caption;
    }

    public SendDocument setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public SendDocument setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public SendDocument setParseMode(String parseMode) {
        this.parseMode = parseMode;
        return this;
    }

    public InputFile getThumb() {
        return this.thumb;
    }

    public SendDocument setThumb(InputFile thumb) {
        this.thumb = thumb;
        return this;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return (Message)result.getResult();
            }
            throw new TelegramApiRequestException("Error sending document", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.document == null) {
            throw new TelegramApiValidationException("Document parameter can't be empty", this);
        }
        this.document.validate();
        if (this.thumb != null) {
            this.thumb.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public String toString() {
        return "SendDocument{chatId='" + this.chatId + '\'' + ", document=" + this.document + ", caption='" + this.caption + '\'' + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", parseMode='" + this.parseMode + '\'' + ", thumb=" + this.thumb + '}';
    }
}

