/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result.cached;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InlineQueryResultCachedGif
implements InlineQueryResult {
    private static final List<String> VALIDTHUMBTYPES = Collections.unmodifiableList(Arrays.asList("image/jpeg", "image/gif", "video/mp4"));
    private static final String TYPE_FIELD = "type";
    private static final String ID_FIELD = "id";
    private static final String GIF_FILE_ID_FIELD = "gif_file_id";
    private static final String TITLE_FIELD = "title";
    private static final String CAPTION_FIELD = "caption";
    private static final String THUMBURL_FIELD = "thumb_url";
    private static final String THUMBMIMETYPE_FIELD = "thumb_mime_type";
    private static final String INPUTMESSAGECONTENT_FIELD = "input_message_content";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String PARSEMODE_FIELD = "parse_mode";
    @JsonProperty(value="type")
    private final String type = "gif";
    @JsonProperty(value="id")
    private String id;
    @JsonProperty(value="gif_file_id")
    private String gifFileId;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContent;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="thumb_url")
    private String thumbUrl;
    @JsonProperty(value="thumb_mime_type")
    private String thumbUrlType;

    public String getType() {
        return "gif";
    }

    public String getId() {
        return this.id;
    }

    public InlineQueryResultCachedGif setId(String id) {
        this.id = id;
        return this;
    }

    public String getGifFileId() {
        return this.gifFileId;
    }

    public InlineQueryResultCachedGif setGifFileId(String gifFileId) {
        this.gifFileId = gifFileId;
        return this;
    }

    public String getTitle() {
        return this.title;
    }

    public InlineQueryResultCachedGif setTitle(String title) {
        this.title = title;
        return this;
    }

    public String getCaption() {
        return this.caption;
    }

    public InlineQueryResultCachedGif setCaption(String caption) {
        this.caption = caption;
        return this;
    }

    public InputMessageContent getInputMessageContent() {
        return this.inputMessageContent;
    }

    public InlineQueryResultCachedGif setInputMessageContent(InputMessageContent inputMessageContent) {
        this.inputMessageContent = inputMessageContent;
        return this;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public InlineQueryResultCachedGif setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
        return this;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public InlineQueryResultCachedGif setParseMode(String parseMode) {
        this.parseMode = parseMode;
        return this;
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public InlineQueryResultCachedGif setThumbUrl(String thumbUrl) {
        this.thumbUrl = thumbUrl;
        return this;
    }

    public String getThumbUrlType() {
        return this.thumbUrlType;
    }

    public InlineQueryResultCachedGif setThumbUrlType(String thumbUrlType) {
        this.thumbUrlType = thumbUrlType;
        return this;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id == null || this.id.isEmpty()) {
            throw new TelegramApiValidationException("ID parameter can't be empty", this);
        }
        if (this.gifFileId == null || this.gifFileId.isEmpty()) {
            throw new TelegramApiValidationException("GifFileId parameter can't be empty", this);
        }
        if (this.thumbUrlType != null && !VALIDTHUMBTYPES.contains(this.thumbUrlType)) {
            throw new TelegramApiValidationException("ThumbUrlType parameter must be one of \u201cimage/jpeg\u201d, \u201cimage/gif\u201d, or \u201cvideo/mp4\u201d", this);
        }
        if (this.inputMessageContent != null) {
            this.inputMessageContent.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public String toString() {
        return "InlineQueryResultCachedGif{type='gif', id='" + this.id + '\'' + ", gifFileId='" + this.gifFileId + '\'' + ", title='" + this.title + '\'' + ", caption='" + this.caption + '\'' + ", inputMessageContent=" + this.inputMessageContent + ", replyMarkup=" + this.replyMarkup + ", parseMode='" + this.parseMode + '\'' + ", thumbUrl='" + this.thumbUrl + '\'' + ", thumbUrlType='" + this.thumbUrlType + '\'' + '}';
    }
}

