/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.groupadministration;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Strings;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.ChatInviteLink;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class RevokeChatInviteLink
extends BotApiMethod<ChatInviteLink> {
    public static final String PATH = "createChatInviteLink";
    private static final String CHATID_FIELD = "chat_id";
    private static final String INVITELINK_FIELD = "invite_link";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="invite_link")
    @NonNull
    private String inviteLink;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public ChatInviteLink deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<ChatInviteLink>>(){});
            if (result.getOk().booleanValue()) {
                return (ChatInviteLink)result.getResult();
            }
            throw new TelegramApiRequestException("Error creating invite link", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (Strings.isNullOrEmpty((String)this.chatId)) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (Strings.isNullOrEmpty((String)this.inviteLink)) {
            throw new TelegramApiValidationException("InviteLink can't be empty", this);
        }
    }

    public static RevokeChatInviteLinkBuilder builder() {
        return new RevokeChatInviteLinkBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RevokeChatInviteLink)) {
            return false;
        }
        RevokeChatInviteLink other = (RevokeChatInviteLink)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$inviteLink = this.getInviteLink();
        String other$inviteLink = other.getInviteLink();
        return !(this$inviteLink == null ? other$inviteLink != null : !this$inviteLink.equals(other$inviteLink));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RevokeChatInviteLink;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $inviteLink = this.getInviteLink();
        result = result * 59 + ($inviteLink == null ? 43 : $inviteLink.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public String getInviteLink() {
        return this.inviteLink;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="invite_link")
    public void setInviteLink(@NonNull String inviteLink) {
        if (inviteLink == null) {
            throw new NullPointerException("inviteLink is marked non-null but is null");
        }
        this.inviteLink = inviteLink;
    }

    public String toString() {
        return "RevokeChatInviteLink(chatId=" + this.getChatId() + ", inviteLink=" + this.getInviteLink() + ")";
    }

    public RevokeChatInviteLink() {
    }

    public RevokeChatInviteLink(@NonNull String chatId, @NonNull String inviteLink) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (inviteLink == null) {
            throw new NullPointerException("inviteLink is marked non-null but is null");
        }
        this.chatId = chatId;
        this.inviteLink = inviteLink;
    }

    public static class RevokeChatInviteLinkBuilder {
        private String chatId;
        private String inviteLink;

        RevokeChatInviteLinkBuilder() {
        }

        @JsonProperty(value="chat_id")
        public RevokeChatInviteLinkBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="invite_link")
        public RevokeChatInviteLinkBuilder inviteLink(@NonNull String inviteLink) {
            if (inviteLink == null) {
                throw new NullPointerException("inviteLink is marked non-null but is null");
            }
            this.inviteLink = inviteLink;
            return this;
        }

        public RevokeChatInviteLink build() {
            return new RevokeChatInviteLink(this.chatId, this.inviteLink);
        }

        public String toString() {
            return "RevokeChatInviteLink.RevokeChatInviteLinkBuilder(chatId=" + this.chatId + ", inviteLink=" + this.inviteLink + ")";
        }
    }
}

