/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.passport.dataerror;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.passport.dataerror.PassportElementError;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class PassportElementErrorFiles
implements PassportElementError {
    private static final String SOURCE_FIELD = "source";
    private static final String TYPE_FIELD = "type";
    private static final String FILEHASHES_FIELD = "file_hashes";
    private static final String MESSAGE_FIELD = "message";
    @JsonProperty(value="source")
    private final String source = "file";
    @JsonProperty(value="type")
    @NonNull
    private String type;
    @JsonProperty(value="file_hashes")
    @NonNull
    private List<String> fileHashes;
    @JsonProperty(value="message")
    @NonNull
    private String message;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.fileHashes == null || this.fileHashes.isEmpty()) {
            throw new TelegramApiValidationException("File hash parameter can't be empty", this);
        }
        if (this.message == null || this.message.isEmpty()) {
            throw new TelegramApiValidationException("Message parameter can't be empty", this);
        }
        if (this.type == null || this.type.isEmpty()) {
            throw new TelegramApiValidationException("Type parameter can't be empty", this);
        }
    }

    public static PassportElementErrorFilesBuilder builder() {
        return new PassportElementErrorFilesBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PassportElementErrorFiles)) {
            return false;
        }
        PassportElementErrorFiles other = (PassportElementErrorFiles)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<String> this$fileHashes = this.getFileHashes();
        List<String> other$fileHashes = other.getFileHashes();
        if (this$fileHashes == null ? other$fileHashes != null : !((Object)this$fileHashes).equals(other$fileHashes)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        return !(this$message == null ? other$message != null : !this$message.equals(other$message));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PassportElementErrorFiles;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<String> $fileHashes = this.getFileHashes();
        result = result * 59 + ($fileHashes == null ? 43 : ((Object)$fileHashes).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        return result;
    }

    public String getSource() {
        return this.source;
    }

    @NonNull
    public String getType() {
        return this.type;
    }

    @NonNull
    public List<String> getFileHashes() {
        return this.fileHashes;
    }

    @NonNull
    public String getMessage() {
        return this.message;
    }

    @JsonProperty(value="type")
    public void setType(@NonNull String type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
    }

    @JsonProperty(value="file_hashes")
    public void setFileHashes(@NonNull List<String> fileHashes) {
        if (fileHashes == null) {
            throw new NullPointerException("fileHashes is marked non-null but is null");
        }
        this.fileHashes = fileHashes;
    }

    @JsonProperty(value="message")
    public void setMessage(@NonNull String message) {
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.message = message;
    }

    public String toString() {
        return "PassportElementErrorFiles(source=" + this.getSource() + ", type=" + this.getType() + ", fileHashes=" + this.getFileHashes() + ", message=" + this.getMessage() + ")";
    }

    public PassportElementErrorFiles() {
    }

    public PassportElementErrorFiles(@NonNull String type, @NonNull List<String> fileHashes, @NonNull String message) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        if (fileHashes == null) {
            throw new NullPointerException("fileHashes is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        this.type = type;
        this.fileHashes = fileHashes;
        this.message = message;
    }

    public static class PassportElementErrorFilesBuilder {
        private String type;
        private ArrayList<String> fileHashes;
        private String message;

        PassportElementErrorFilesBuilder() {
        }

        @JsonProperty(value="type")
        public PassportElementErrorFilesBuilder type(@NonNull String type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public PassportElementErrorFilesBuilder fileHash(String fileHash) {
            if (this.fileHashes == null) {
                this.fileHashes = new ArrayList();
            }
            this.fileHashes.add(fileHash);
            return this;
        }

        @JsonProperty(value="file_hashes")
        public PassportElementErrorFilesBuilder fileHashes(Collection<? extends String> fileHashes) {
            if (fileHashes == null) {
                throw new NullPointerException("fileHashes cannot be null");
            }
            if (this.fileHashes == null) {
                this.fileHashes = new ArrayList();
            }
            this.fileHashes.addAll(fileHashes);
            return this;
        }

        public PassportElementErrorFilesBuilder clearFileHashes() {
            if (this.fileHashes != null) {
                this.fileHashes.clear();
            }
            return this;
        }

        @JsonProperty(value="message")
        public PassportElementErrorFilesBuilder message(@NonNull String message) {
            if (message == null) {
                throw new NullPointerException("message is marked non-null but is null");
            }
            this.message = message;
            return this;
        }

        public PassportElementErrorFiles build() {
            List<String> fileHashes;
            switch (this.fileHashes == null ? 0 : this.fileHashes.size()) {
                case 0: {
                    fileHashes = Collections.emptyList();
                    break;
                }
                case 1: {
                    fileHashes = Collections.singletonList(this.fileHashes.get(0));
                    break;
                }
                default: {
                    fileHashes = Collections.unmodifiableList(new ArrayList<String>(this.fileHashes));
                }
            }
            return new PassportElementErrorFiles(this.type, fileHashes, this.message);
        }

        public String toString() {
            return "PassportElementErrorFiles.PassportElementErrorFilesBuilder(type=" + this.type + ", fileHashes=" + this.fileHashes + ", message=" + this.message + ")";
        }
    }
}

