/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.commands;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.commands.scope.BotCommandScope;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class DeleteMyCommands
extends BotApiMethod<Boolean> {
    public static final String PATH = "deleteMyCommands";
    private static final String SCOPE_FIELD = "scope";
    private static final String LANGUAGECODE_FIELD = "language_code";
    @JsonProperty(value="scope")
    private BotCommandScope scope;
    @JsonProperty(value="language_code")
    private String languageCode;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error sending commands", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.scope != null) {
            this.scope.validate();
        }
        if (this.languageCode != null && this.languageCode.isEmpty()) {
            throw new TelegramApiValidationException("LanguageCode parameter can't be empty string", this);
        }
    }

    public static DeleteMyCommandsBuilder builder() {
        return new DeleteMyCommandsBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteMyCommands)) {
            return false;
        }
        DeleteMyCommands other = (DeleteMyCommands)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BotCommandScope this$scope = this.getScope();
        BotCommandScope other$scope = other.getScope();
        if (this$scope == null ? other$scope != null : !this$scope.equals(other$scope)) {
            return false;
        }
        String this$languageCode = this.getLanguageCode();
        String other$languageCode = other.getLanguageCode();
        return !(this$languageCode == null ? other$languageCode != null : !this$languageCode.equals(other$languageCode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DeleteMyCommands;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BotCommandScope $scope = this.getScope();
        result = result * 59 + ($scope == null ? 43 : $scope.hashCode());
        String $languageCode = this.getLanguageCode();
        result = result * 59 + ($languageCode == null ? 43 : $languageCode.hashCode());
        return result;
    }

    public BotCommandScope getScope() {
        return this.scope;
    }

    public String getLanguageCode() {
        return this.languageCode;
    }

    @JsonProperty(value="scope")
    public void setScope(BotCommandScope scope) {
        this.scope = scope;
    }

    @JsonProperty(value="language_code")
    public void setLanguageCode(String languageCode) {
        this.languageCode = languageCode;
    }

    public String toString() {
        return "DeleteMyCommands(scope=" + this.getScope() + ", languageCode=" + this.getLanguageCode() + ")";
    }

    public DeleteMyCommands() {
    }

    public DeleteMyCommands(BotCommandScope scope, String languageCode) {
        this.scope = scope;
        this.languageCode = languageCode;
    }

    public static class DeleteMyCommandsBuilder {
        private BotCommandScope scope;
        private String languageCode;

        DeleteMyCommandsBuilder() {
        }

        @JsonProperty(value="scope")
        public DeleteMyCommandsBuilder scope(BotCommandScope scope) {
            this.scope = scope;
            return this;
        }

        @JsonProperty(value="language_code")
        public DeleteMyCommandsBuilder languageCode(String languageCode) {
            this.languageCode = languageCode;
            return this;
        }

        public DeleteMyCommands build() {
            return new DeleteMyCommands(this.scope, this.languageCode);
        }

        public String toString() {
            return "DeleteMyCommands.DeleteMyCommandsBuilder(scope=" + this.scope + ", languageCode=" + this.languageCode + ")";
        }
    }
}

