/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SendContact
extends BotApiMethod<Message> {
    public static final String PATH = "sendContact";
    private static final String CHATID_FIELD = "chat_id";
    private static final String PHONE_NUMBER_FIELD = "phone_number";
    private static final String FIRST_NAME_FIELD = "first_name";
    private static final String LAST_NAME_FIELD = "last_name";
    private static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    private static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    private static final String REPLYMARKUP_FIELD = "reply_markup";
    private static final String VCARD_FIELD = "vcard";
    private static final String ALLOWSENDINGWITHOUTREPLY_FIELD = "allow_sending_without_reply";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="phone_number")
    @NonNull
    private String phoneNumber;
    @JsonProperty(value="first_name")
    @NonNull
    private String firstName;
    @JsonProperty(value="last_name")
    private String lastName;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="reply_to_message_id")
    private Integer replyToMessageId;
    @JsonProperty(value="reply_markup")
    private ReplyKeyboard replyMarkup;
    @JsonProperty(value="vcard")
    private String vCard;
    @JsonProperty(value="allow_sending_without_reply")
    private Boolean allowSendingWithoutReply;

    public void enableNotification() {
        this.disableNotification = false;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Message deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Message>>(){});
            if (result.getOk().booleanValue()) {
                return (Message)result.getResult();
            }
            throw new TelegramApiRequestException("Error sending contact", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId == null || this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.phoneNumber == null) {
            throw new TelegramApiValidationException("PhoneNumber parameter can't be empty", this);
        }
        if (this.firstName == null) {
            throw new TelegramApiValidationException("FirstName parameter can't be empty", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public static SendContactBuilder builder() {
        return new SendContactBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendContact)) {
            return false;
        }
        SendContact other = (SendContact)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Integer this$replyToMessageId = this.getReplyToMessageId();
        Integer other$replyToMessageId = other.getReplyToMessageId();
        if (this$replyToMessageId == null ? other$replyToMessageId != null : !((Object)this$replyToMessageId).equals(other$replyToMessageId)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$phoneNumber = this.getPhoneNumber();
        String other$phoneNumber = other.getPhoneNumber();
        if (this$phoneNumber == null ? other$phoneNumber != null : !this$phoneNumber.equals(other$phoneNumber)) {
            return false;
        }
        String this$firstName = this.getFirstName();
        String other$firstName = other.getFirstName();
        if (this$firstName == null ? other$firstName != null : !this$firstName.equals(other$firstName)) {
            return false;
        }
        String this$lastName = this.getLastName();
        String other$lastName = other.getLastName();
        if (this$lastName == null ? other$lastName != null : !this$lastName.equals(other$lastName)) {
            return false;
        }
        ReplyKeyboard this$replyMarkup = this.getReplyMarkup();
        ReplyKeyboard other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !this$replyMarkup.equals(other$replyMarkup)) {
            return false;
        }
        String this$vCard = this.getVCard();
        String other$vCard = other.getVCard();
        return !(this$vCard == null ? other$vCard != null : !this$vCard.equals(other$vCard));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendContact;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Integer $replyToMessageId = this.getReplyToMessageId();
        result = result * 59 + ($replyToMessageId == null ? 43 : ((Object)$replyToMessageId).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $phoneNumber = this.getPhoneNumber();
        result = result * 59 + ($phoneNumber == null ? 43 : $phoneNumber.hashCode());
        String $firstName = this.getFirstName();
        result = result * 59 + ($firstName == null ? 43 : $firstName.hashCode());
        String $lastName = this.getLastName();
        result = result * 59 + ($lastName == null ? 43 : $lastName.hashCode());
        ReplyKeyboard $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : $replyMarkup.hashCode());
        String $vCard = this.getVCard();
        result = result * 59 + ($vCard == null ? 43 : $vCard.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public String getPhoneNumber() {
        return this.phoneNumber;
    }

    @NonNull
    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public String getVCard() {
        return this.vCard;
    }

    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="phone_number")
    public void setPhoneNumber(@NonNull String phoneNumber) {
        if (phoneNumber == null) {
            throw new NullPointerException("phoneNumber is marked non-null but is null");
        }
        this.phoneNumber = phoneNumber;
    }

    @JsonProperty(value="first_name")
    public void setFirstName(@NonNull String firstName) {
        if (firstName == null) {
            throw new NullPointerException("firstName is marked non-null but is null");
        }
        this.firstName = firstName;
    }

    @JsonProperty(value="last_name")
    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    @JsonProperty(value="disable_notification")
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @JsonProperty(value="reply_to_message_id")
    public void setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="vcard")
    public void setVCard(String vCard) {
        this.vCard = vCard;
    }

    @JsonProperty(value="allow_sending_without_reply")
    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    public String toString() {
        return "SendContact(chatId=" + this.getChatId() + ", phoneNumber=" + this.getPhoneNumber() + ", firstName=" + this.getFirstName() + ", lastName=" + this.getLastName() + ", disableNotification=" + this.getDisableNotification() + ", replyToMessageId=" + this.getReplyToMessageId() + ", replyMarkup=" + this.getReplyMarkup() + ", vCard=" + this.getVCard() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ")";
    }

    public SendContact(@NonNull String chatId, @NonNull String phoneNumber, @NonNull String firstName) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (phoneNumber == null) {
            throw new NullPointerException("phoneNumber is marked non-null but is null");
        }
        if (firstName == null) {
            throw new NullPointerException("firstName is marked non-null but is null");
        }
        this.chatId = chatId;
        this.phoneNumber = phoneNumber;
        this.firstName = firstName;
    }

    public SendContact() {
    }

    public SendContact(@NonNull String chatId, @NonNull String phoneNumber, @NonNull String firstName, String lastName, Boolean disableNotification, Integer replyToMessageId, ReplyKeyboard replyMarkup, String vCard, Boolean allowSendingWithoutReply) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (phoneNumber == null) {
            throw new NullPointerException("phoneNumber is marked non-null but is null");
        }
        if (firstName == null) {
            throw new NullPointerException("firstName is marked non-null but is null");
        }
        this.chatId = chatId;
        this.phoneNumber = phoneNumber;
        this.firstName = firstName;
        this.lastName = lastName;
        this.disableNotification = disableNotification;
        this.replyToMessageId = replyToMessageId;
        this.replyMarkup = replyMarkup;
        this.vCard = vCard;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    public static class SendContactBuilder {
        private String chatId;
        private String phoneNumber;
        private String firstName;
        private String lastName;
        private Boolean disableNotification;
        private Integer replyToMessageId;
        private ReplyKeyboard replyMarkup;
        private String vCard;
        private Boolean allowSendingWithoutReply;

        SendContactBuilder() {
        }

        @JsonProperty(value="chat_id")
        public SendContactBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="phone_number")
        public SendContactBuilder phoneNumber(@NonNull String phoneNumber) {
            if (phoneNumber == null) {
                throw new NullPointerException("phoneNumber is marked non-null but is null");
            }
            this.phoneNumber = phoneNumber;
            return this;
        }

        @JsonProperty(value="first_name")
        public SendContactBuilder firstName(@NonNull String firstName) {
            if (firstName == null) {
                throw new NullPointerException("firstName is marked non-null but is null");
            }
            this.firstName = firstName;
            return this;
        }

        @JsonProperty(value="last_name")
        public SendContactBuilder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        @JsonProperty(value="disable_notification")
        public SendContactBuilder disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        @JsonProperty(value="reply_to_message_id")
        public SendContactBuilder replyToMessageId(Integer replyToMessageId) {
            this.replyToMessageId = replyToMessageId;
            return this;
        }

        @JsonProperty(value="reply_markup")
        public SendContactBuilder replyMarkup(ReplyKeyboard replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        @JsonProperty(value="vcard")
        public SendContactBuilder vCard(String vCard) {
            this.vCard = vCard;
            return this;
        }

        @JsonProperty(value="allow_sending_without_reply")
        public SendContactBuilder allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return this;
        }

        public SendContact build() {
            return new SendContact(this.chatId, this.phoneNumber, this.firstName, this.lastName, this.disableNotification, this.replyToMessageId, this.replyMarkup, this.vCard, this.allowSendingWithoutReply);
        }

        public String toString() {
            return "SendContact.SendContactBuilder(chatId=" + this.chatId + ", phoneNumber=" + this.phoneNumber + ", firstName=" + this.firstName + ", lastName=" + this.lastName + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", vCard=" + this.vCard + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ")";
        }
    }
}

