/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.adminrights;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import java.io.IOException;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.ApiResponse;
import org.telegram.telegrambots.meta.api.objects.adminrights.ChatAdministratorRights;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetMyDefaultAdministratorRights
extends BotApiMethod<Boolean> {
    public static final String PATH = "setMyDefaultAdministratorRights";
    private static final String RIGHTS_FIELD = "rights";
    private static final String FORCHANNELS_FIELD = "for_channels";
    @JsonProperty(value="rights")
    private ChatAdministratorRights rights;
    @JsonProperty(value="for_channels")
    private Boolean forChannels;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        try {
            ApiResponse result = (ApiResponse)OBJECT_MAPPER.readValue(answer, (TypeReference)new TypeReference<ApiResponse<Boolean>>(){});
            if (result.getOk().booleanValue()) {
                return (Boolean)result.getResult();
            }
            throw new TelegramApiRequestException("Error setting default administrator rights", result);
        }
        catch (IOException e) {
            throw new TelegramApiRequestException("Unable to deserialize response", e);
        }
    }

    @Override
    public void validate() throws TelegramApiValidationException {
    }

    public static SetMyDefaultAdministratorRightsBuilder builder() {
        return new SetMyDefaultAdministratorRightsBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetMyDefaultAdministratorRights)) {
            return false;
        }
        SetMyDefaultAdministratorRights other = (SetMyDefaultAdministratorRights)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$forChannels = this.getForChannels();
        Boolean other$forChannels = other.getForChannels();
        if (this$forChannels == null ? other$forChannels != null : !((Object)this$forChannels).equals(other$forChannels)) {
            return false;
        }
        ChatAdministratorRights this$rights = this.getRights();
        ChatAdministratorRights other$rights = other.getRights();
        return !(this$rights == null ? other$rights != null : !((Object)this$rights).equals(other$rights));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetMyDefaultAdministratorRights;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $forChannels = this.getForChannels();
        result = result * 59 + ($forChannels == null ? 43 : ((Object)$forChannels).hashCode());
        ChatAdministratorRights $rights = this.getRights();
        result = result * 59 + ($rights == null ? 43 : ((Object)$rights).hashCode());
        return result;
    }

    public ChatAdministratorRights getRights() {
        return this.rights;
    }

    public Boolean getForChannels() {
        return this.forChannels;
    }

    @JsonProperty(value="rights")
    public void setRights(ChatAdministratorRights rights) {
        this.rights = rights;
    }

    @JsonProperty(value="for_channels")
    public void setForChannels(Boolean forChannels) {
        this.forChannels = forChannels;
    }

    public String toString() {
        return "SetMyDefaultAdministratorRights(rights=" + this.getRights() + ", forChannels=" + this.getForChannels() + ")";
    }

    public SetMyDefaultAdministratorRights() {
    }

    public SetMyDefaultAdministratorRights(ChatAdministratorRights rights, Boolean forChannels) {
        this.rights = rights;
        this.forChannels = forChannels;
    }

    public static class SetMyDefaultAdministratorRightsBuilder {
        private ChatAdministratorRights rights;
        private Boolean forChannels;

        SetMyDefaultAdministratorRightsBuilder() {
        }

        @JsonProperty(value="rights")
        public SetMyDefaultAdministratorRightsBuilder rights(ChatAdministratorRights rights) {
            this.rights = rights;
            return this;
        }

        @JsonProperty(value="for_channels")
        public SetMyDefaultAdministratorRightsBuilder forChannels(Boolean forChannels) {
            this.forChannels = forChannels;
            return this;
        }

        public SetMyDefaultAdministratorRights build() {
            return new SetMyDefaultAdministratorRights(this.rights, this.forChannels);
        }

        public String toString() {
            return "SetMyDefaultAdministratorRights.SetMyDefaultAdministratorRightsBuilder(rights=" + this.rights + ", forChannels=" + this.forChannels + ")";
        }
    }
}

