/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.api.objects.passport.dataerror.PassportElementError;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SetPassportDataErrors
extends BotApiMethodBoolean {
    public static final String PATH = "setPassportDataErrors";
    private static final String USERID_FIELD = "user_id";
    private static final String ERRORS_FIELD = "errors";
    @JsonProperty(value="user_id")
    @NonNull
    private Long userId;
    @JsonProperty(value="errors")
    @NonNull
    private List<PassportElementError> errors;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.errors.isEmpty()) {
            throw new TelegramApiValidationException("Errors can't be empty", this);
        }
    }

    public static SetPassportDataErrorsBuilder builder() {
        return new SetPassportDataErrorsBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SetPassportDataErrors)) {
            return false;
        }
        SetPassportDataErrors other = (SetPassportDataErrors)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        List<PassportElementError> this$errors = this.getErrors();
        List<PassportElementError> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SetPassportDataErrors;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        List<PassportElementError> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }

    @NonNull
    public Long getUserId() {
        return this.userId;
    }

    @NonNull
    public List<PassportElementError> getErrors() {
        return this.errors;
    }

    @JsonProperty(value="user_id")
    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    @JsonProperty(value="errors")
    public void setErrors(@NonNull List<PassportElementError> errors) {
        if (errors == null) {
            throw new NullPointerException("errors is marked non-null but is null");
        }
        this.errors = errors;
    }

    public String toString() {
        return "SetPassportDataErrors(userId=" + this.getUserId() + ", errors=" + this.getErrors() + ")";
    }

    public SetPassportDataErrors() {
    }

    public SetPassportDataErrors(@NonNull Long userId, @NonNull List<PassportElementError> errors) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (errors == null) {
            throw new NullPointerException("errors is marked non-null but is null");
        }
        this.userId = userId;
        this.errors = errors;
    }

    public static class SetPassportDataErrorsBuilder {
        private Long userId;
        private ArrayList<PassportElementError> errors;

        SetPassportDataErrorsBuilder() {
        }

        @JsonProperty(value="user_id")
        public SetPassportDataErrorsBuilder userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        public SetPassportDataErrorsBuilder error(PassportElementError error) {
            if (this.errors == null) {
                this.errors = new ArrayList();
            }
            this.errors.add(error);
            return this;
        }

        @JsonProperty(value="errors")
        public SetPassportDataErrorsBuilder errors(Collection<? extends PassportElementError> errors) {
            if (errors == null) {
                throw new NullPointerException("errors cannot be null");
            }
            if (this.errors == null) {
                this.errors = new ArrayList();
            }
            this.errors.addAll(errors);
            return this;
        }

        public SetPassportDataErrorsBuilder clearErrors() {
            if (this.errors != null) {
                this.errors.clear();
            }
            return this;
        }

        public SetPassportDataErrors build() {
            List<PassportElementError> errors;
            switch (this.errors == null ? 0 : this.errors.size()) {
                case 0: {
                    errors = Collections.emptyList();
                    break;
                }
                case 1: {
                    errors = Collections.singletonList(this.errors.get(0));
                    break;
                }
                default: {
                    errors = Collections.unmodifiableList(new ArrayList<PassportElementError>(this.errors));
                }
            }
            return new SetPassportDataErrors(this.userId, errors);
        }

        public String toString() {
            return "SetPassportDataErrors.SetPassportDataErrorsBuilder(userId=" + this.userId + ", errors=" + this.errors + ")";
        }
    }
}

