/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.polls;

import com.fasterxml.jackson.annotation.JsonProperty;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.polls.Poll;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class StopPoll
extends BotApiMethod<Poll> {
    public static final String PATH = "stopPoll";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGEID_FIELD = "message_id";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_id")
    @NonNull
    private Integer messageId;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Poll deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Poll.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.messageId == 0) {
            throw new TelegramApiValidationException("Message Id parameter can't be empty", this);
        }
    }

    public static StopPollBuilder builder() {
        return new StopPollBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StopPoll)) {
            return false;
        }
        StopPoll other = (StopPoll)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        return !(this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof StopPoll;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    @NonNull
    public Integer getMessageId() {
        return this.messageId;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_id")
    public void setMessageId(@NonNull Integer messageId) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.messageId = messageId;
    }

    public String toString() {
        return "StopPoll(chatId=" + this.getChatId() + ", messageId=" + this.getMessageId() + ")";
    }

    public StopPoll() {
    }

    public StopPoll(@NonNull String chatId, @NonNull Integer messageId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageId = messageId;
    }

    public static class StopPollBuilder {
        private String chatId;
        private Integer messageId;

        public StopPollBuilder chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        StopPollBuilder() {
        }

        @JsonProperty(value="chat_id")
        public StopPollBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="message_id")
        public StopPollBuilder messageId(@NonNull Integer messageId) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.messageId = messageId;
            return this;
        }

        public StopPoll build() {
            return new StopPoll(this.chatId, this.messageId);
        }

        public String toString() {
            return "StopPoll.StopPollBuilder(chatId=" + this.chatId + ", messageId=" + this.messageId + ")";
        }
    }
}

