/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.stickers.InputSticker;
import org.telegram.telegrambots.meta.api.objects.stickers.MaskPosition;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class AddStickerToSet
extends PartialBotApiMethod<Boolean> {
    public static final String PATH = "addStickerToSet";
    public static final String USERID_FIELD = "user_id";
    public static final String NAME_FIELD = "name";
    public static final String STICKER_FIELD = "sticker";
    @Deprecated
    public static final String PNGSTICKER_FIELD = "png_sticker";
    @Deprecated
    public static final String TGSSTICKER_FIELD = "tgs_sticker";
    @Deprecated
    public static final String WEBMSTICKER_FIELD = "webm_sticker";
    @Deprecated
    public static final String EMOJIS_FIELD = "emojis";
    @Deprecated
    public static final String MASKPOSITION_FIELD = "mask_position";
    @NonNull
    private Long userId;
    @NonNull
    private String name;
    private InputSticker sticker;
    @Deprecated
    @NonNull
    private String emojis;
    @Deprecated
    private MaskPosition maskPosition;
    @Deprecated
    private InputFile pngSticker;
    @Deprecated
    private InputFile tgsSticker;
    @Deprecated
    private InputFile webmSticker;

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Boolean.class);
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.userId <= 0L) {
            throw new TelegramApiValidationException("userId can't be empty", this);
        }
        if (this.name.isEmpty()) {
            throw new TelegramApiValidationException("name can't be empty", this);
        }
        if (this.pngSticker == null && this.tgsSticker == null && this.webmSticker == null) {
            if (this.sticker == null) {
                throw new TelegramApiValidationException("Sticker can't be empty", this);
            }
            this.sticker.validate();
        } else {
            if (this.emojis.isEmpty()) {
                throw new TelegramApiValidationException("emojis can't be empty", this);
            }
            if (this.pngSticker != null && this.tgsSticker != null || this.pngSticker != null && this.webmSticker != null || this.tgsSticker != null && this.webmSticker != null) {
                throw new TelegramApiValidationException("Only one of pngSticker, tgsSticker or webmSticker are allowed", this);
            }
            if (this.pngSticker != null) {
                this.pngSticker.validate();
            }
            if (this.tgsSticker != null) {
                this.tgsSticker.validate();
            }
            if (this.webmSticker != null) {
                this.webmSticker.validate();
            }
            if (this.maskPosition != null) {
                this.maskPosition.validate();
            }
        }
    }

    public static AddStickerToSetBuilder builder() {
        return new AddStickerToSetBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddStickerToSet)) {
            return false;
        }
        AddStickerToSet other = (AddStickerToSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        InputSticker this$sticker = this.getSticker();
        InputSticker other$sticker = other.getSticker();
        if (this$sticker == null ? other$sticker != null : !((Object)this$sticker).equals(other$sticker)) {
            return false;
        }
        String this$emojis = this.getEmojis();
        String other$emojis = other.getEmojis();
        if (this$emojis == null ? other$emojis != null : !this$emojis.equals(other$emojis)) {
            return false;
        }
        MaskPosition this$maskPosition = this.getMaskPosition();
        MaskPosition other$maskPosition = other.getMaskPosition();
        if (this$maskPosition == null ? other$maskPosition != null : !((Object)this$maskPosition).equals(other$maskPosition)) {
            return false;
        }
        InputFile this$pngSticker = this.getPngSticker();
        InputFile other$pngSticker = other.getPngSticker();
        if (this$pngSticker == null ? other$pngSticker != null : !((Object)this$pngSticker).equals(other$pngSticker)) {
            return false;
        }
        InputFile this$tgsSticker = this.getTgsSticker();
        InputFile other$tgsSticker = other.getTgsSticker();
        if (this$tgsSticker == null ? other$tgsSticker != null : !((Object)this$tgsSticker).equals(other$tgsSticker)) {
            return false;
        }
        InputFile this$webmSticker = this.getWebmSticker();
        InputFile other$webmSticker = other.getWebmSticker();
        return !(this$webmSticker == null ? other$webmSticker != null : !((Object)this$webmSticker).equals(other$webmSticker));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddStickerToSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        InputSticker $sticker = this.getSticker();
        result = result * 59 + ($sticker == null ? 43 : ((Object)$sticker).hashCode());
        String $emojis = this.getEmojis();
        result = result * 59 + ($emojis == null ? 43 : $emojis.hashCode());
        MaskPosition $maskPosition = this.getMaskPosition();
        result = result * 59 + ($maskPosition == null ? 43 : ((Object)$maskPosition).hashCode());
        InputFile $pngSticker = this.getPngSticker();
        result = result * 59 + ($pngSticker == null ? 43 : ((Object)$pngSticker).hashCode());
        InputFile $tgsSticker = this.getTgsSticker();
        result = result * 59 + ($tgsSticker == null ? 43 : ((Object)$tgsSticker).hashCode());
        InputFile $webmSticker = this.getWebmSticker();
        result = result * 59 + ($webmSticker == null ? 43 : ((Object)$webmSticker).hashCode());
        return result;
    }

    @NonNull
    public Long getUserId() {
        return this.userId;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public InputSticker getSticker() {
        return this.sticker;
    }

    @Deprecated
    @NonNull
    public String getEmojis() {
        return this.emojis;
    }

    @Deprecated
    public MaskPosition getMaskPosition() {
        return this.maskPosition;
    }

    @Deprecated
    public InputFile getPngSticker() {
        return this.pngSticker;
    }

    @Deprecated
    public InputFile getTgsSticker() {
        return this.tgsSticker;
    }

    @Deprecated
    public InputFile getWebmSticker() {
        return this.webmSticker;
    }

    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setSticker(InputSticker sticker) {
        this.sticker = sticker;
    }

    @Deprecated
    public void setEmojis(@NonNull String emojis) {
        if (emojis == null) {
            throw new NullPointerException("emojis is marked non-null but is null");
        }
        this.emojis = emojis;
    }

    @Deprecated
    public void setMaskPosition(MaskPosition maskPosition) {
        this.maskPosition = maskPosition;
    }

    @Deprecated
    public void setPngSticker(InputFile pngSticker) {
        this.pngSticker = pngSticker;
    }

    @Deprecated
    public void setTgsSticker(InputFile tgsSticker) {
        this.tgsSticker = tgsSticker;
    }

    @Deprecated
    public void setWebmSticker(InputFile webmSticker) {
        this.webmSticker = webmSticker;
    }

    public String toString() {
        return "AddStickerToSet(userId=" + this.getUserId() + ", name=" + this.getName() + ", sticker=" + this.getSticker() + ", emojis=" + this.getEmojis() + ", maskPosition=" + this.getMaskPosition() + ", pngSticker=" + this.getPngSticker() + ", tgsSticker=" + this.getTgsSticker() + ", webmSticker=" + this.getWebmSticker() + ")";
    }

    public AddStickerToSet(@NonNull Long userId, @NonNull String name, @NonNull String emojis) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (emojis == null) {
            throw new NullPointerException("emojis is marked non-null but is null");
        }
        this.userId = userId;
        this.name = name;
        this.emojis = emojis;
    }

    public AddStickerToSet() {
    }

    public AddStickerToSet(@NonNull Long userId, @NonNull String name, InputSticker sticker, @NonNull String emojis, MaskPosition maskPosition, InputFile pngSticker, InputFile tgsSticker, InputFile webmSticker) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (emojis == null) {
            throw new NullPointerException("emojis is marked non-null but is null");
        }
        this.userId = userId;
        this.name = name;
        this.sticker = sticker;
        this.emojis = emojis;
        this.maskPosition = maskPosition;
        this.pngSticker = pngSticker;
        this.tgsSticker = tgsSticker;
        this.webmSticker = webmSticker;
    }

    public static class AddStickerToSetBuilder {
        private Long userId;
        private String name;
        private InputSticker sticker;
        private String emojis;
        private MaskPosition maskPosition;
        private InputFile pngSticker;
        private InputFile tgsSticker;
        private InputFile webmSticker;

        AddStickerToSetBuilder() {
        }

        public AddStickerToSetBuilder userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        public AddStickerToSetBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public AddStickerToSetBuilder sticker(InputSticker sticker) {
            this.sticker = sticker;
            return this;
        }

        @Deprecated
        public AddStickerToSetBuilder emojis(@NonNull String emojis) {
            if (emojis == null) {
                throw new NullPointerException("emojis is marked non-null but is null");
            }
            this.emojis = emojis;
            return this;
        }

        @Deprecated
        public AddStickerToSetBuilder maskPosition(MaskPosition maskPosition) {
            this.maskPosition = maskPosition;
            return this;
        }

        @Deprecated
        public AddStickerToSetBuilder pngSticker(InputFile pngSticker) {
            this.pngSticker = pngSticker;
            return this;
        }

        @Deprecated
        public AddStickerToSetBuilder tgsSticker(InputFile tgsSticker) {
            this.tgsSticker = tgsSticker;
            return this;
        }

        @Deprecated
        public AddStickerToSetBuilder webmSticker(InputFile webmSticker) {
            this.webmSticker = webmSticker;
            return this;
        }

        public AddStickerToSet build() {
            return new AddStickerToSet(this.userId, this.name, this.sticker, this.emojis, this.maskPosition, this.pngSticker, this.tgsSticker, this.webmSticker);
        }

        public String toString() {
            return "AddStickerToSet.AddStickerToSetBuilder(userId=" + this.userId + ", name=" + this.name + ", sticker=" + this.sticker + ", emojis=" + this.emojis + ", maskPosition=" + this.maskPosition + ", pngSticker=" + this.pngSticker + ", tgsSticker=" + this.tgsSticker + ", webmSticker=" + this.webmSticker + ")";
        }
    }
}

