/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodBoolean;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResultsButton;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class AnswerInlineQuery
extends BotApiMethodBoolean {
    public static final String PATH = "answerInlineQuery";
    private static final String INLINEQUERYID_FIELD = "inline_query_id";
    private static final String RESULTS_FIELD = "results";
    private static final String CACHETIME_FIELD = "cache_time";
    private static final String ISPERSONAL_FIELD = "is_personal";
    private static final String NEXTOFFSET_FIELD = "next_offset";
    private static final String SWITCH_PM_TEXT_FIELD = "switch_pm_text";
    private static final String SWITCH_PM_PARAMETER_FIELD = "switch_pm_parameter";
    private static final String BUTTON_FIELD = "button";
    @JsonProperty(value="inline_query_id")
    @NonNull
    private String inlineQueryId;
    @JsonProperty(value="results")
    @NonNull
    private List<InlineQueryResult> results;
    @JsonProperty(value="cache_time")
    private Integer cacheTime;
    @JsonProperty(value="is_personal")
    private Boolean isPersonal;
    @JsonProperty(value="next_offset")
    private String nextOffset;
    @JsonProperty(value="button")
    private InlineQueryResultsButton button;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.inlineQueryId.isEmpty()) {
            throw new TelegramApiValidationException("InlineQueryId can't be empty", this);
        }
        for (InlineQueryResult result : this.results) {
            result.validate();
        }
        if (this.button != null) {
            this.button.validate();
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    public static AnswerInlineQueryBuilder builder() {
        return new AnswerInlineQueryBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AnswerInlineQuery)) {
            return false;
        }
        AnswerInlineQuery other = (AnswerInlineQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$cacheTime = this.getCacheTime();
        Integer other$cacheTime = other.getCacheTime();
        if (this$cacheTime == null ? other$cacheTime != null : !((Object)this$cacheTime).equals(other$cacheTime)) {
            return false;
        }
        Boolean this$isPersonal = this.getIsPersonal();
        Boolean other$isPersonal = other.getIsPersonal();
        if (this$isPersonal == null ? other$isPersonal != null : !((Object)this$isPersonal).equals(other$isPersonal)) {
            return false;
        }
        String this$inlineQueryId = this.getInlineQueryId();
        String other$inlineQueryId = other.getInlineQueryId();
        if (this$inlineQueryId == null ? other$inlineQueryId != null : !this$inlineQueryId.equals(other$inlineQueryId)) {
            return false;
        }
        List<InlineQueryResult> this$results = this.getResults();
        List<InlineQueryResult> other$results = other.getResults();
        if (this$results == null ? other$results != null : !((Object)this$results).equals(other$results)) {
            return false;
        }
        String this$nextOffset = this.getNextOffset();
        String other$nextOffset = other.getNextOffset();
        if (this$nextOffset == null ? other$nextOffset != null : !this$nextOffset.equals(other$nextOffset)) {
            return false;
        }
        InlineQueryResultsButton this$button = this.getButton();
        InlineQueryResultsButton other$button = other.getButton();
        return !(this$button == null ? other$button != null : !((Object)this$button).equals(other$button));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AnswerInlineQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $cacheTime = this.getCacheTime();
        result = result * 59 + ($cacheTime == null ? 43 : ((Object)$cacheTime).hashCode());
        Boolean $isPersonal = this.getIsPersonal();
        result = result * 59 + ($isPersonal == null ? 43 : ((Object)$isPersonal).hashCode());
        String $inlineQueryId = this.getInlineQueryId();
        result = result * 59 + ($inlineQueryId == null ? 43 : $inlineQueryId.hashCode());
        List<InlineQueryResult> $results = this.getResults();
        result = result * 59 + ($results == null ? 43 : ((Object)$results).hashCode());
        String $nextOffset = this.getNextOffset();
        result = result * 59 + ($nextOffset == null ? 43 : $nextOffset.hashCode());
        InlineQueryResultsButton $button = this.getButton();
        result = result * 59 + ($button == null ? 43 : ((Object)$button).hashCode());
        return result;
    }

    @NonNull
    public String getInlineQueryId() {
        return this.inlineQueryId;
    }

    @NonNull
    public List<InlineQueryResult> getResults() {
        return this.results;
    }

    public Integer getCacheTime() {
        return this.cacheTime;
    }

    public Boolean getIsPersonal() {
        return this.isPersonal;
    }

    public String getNextOffset() {
        return this.nextOffset;
    }

    public InlineQueryResultsButton getButton() {
        return this.button;
    }

    @JsonProperty(value="inline_query_id")
    public void setInlineQueryId(@NonNull String inlineQueryId) {
        if (inlineQueryId == null) {
            throw new NullPointerException("inlineQueryId is marked non-null but is null");
        }
        this.inlineQueryId = inlineQueryId;
    }

    @JsonProperty(value="results")
    public void setResults(@NonNull List<InlineQueryResult> results) {
        if (results == null) {
            throw new NullPointerException("results is marked non-null but is null");
        }
        this.results = results;
    }

    @JsonProperty(value="cache_time")
    public void setCacheTime(Integer cacheTime) {
        this.cacheTime = cacheTime;
    }

    @JsonProperty(value="is_personal")
    public void setIsPersonal(Boolean isPersonal) {
        this.isPersonal = isPersonal;
    }

    @JsonProperty(value="next_offset")
    public void setNextOffset(String nextOffset) {
        this.nextOffset = nextOffset;
    }

    @JsonProperty(value="button")
    public void setButton(InlineQueryResultsButton button) {
        this.button = button;
    }

    public String toString() {
        return "AnswerInlineQuery(inlineQueryId=" + this.getInlineQueryId() + ", results=" + this.getResults() + ", cacheTime=" + this.getCacheTime() + ", isPersonal=" + this.getIsPersonal() + ", nextOffset=" + this.getNextOffset() + ", button=" + this.getButton() + ")";
    }

    public AnswerInlineQuery(@NonNull String inlineQueryId, @NonNull List<InlineQueryResult> results) {
        if (inlineQueryId == null) {
            throw new NullPointerException("inlineQueryId is marked non-null but is null");
        }
        if (results == null) {
            throw new NullPointerException("results is marked non-null but is null");
        }
        this.inlineQueryId = inlineQueryId;
        this.results = results;
    }

    public AnswerInlineQuery() {
    }

    public AnswerInlineQuery(@NonNull String inlineQueryId, @NonNull List<InlineQueryResult> results, Integer cacheTime, Boolean isPersonal, String nextOffset, InlineQueryResultsButton button) {
        if (inlineQueryId == null) {
            throw new NullPointerException("inlineQueryId is marked non-null but is null");
        }
        if (results == null) {
            throw new NullPointerException("results is marked non-null but is null");
        }
        this.inlineQueryId = inlineQueryId;
        this.results = results;
        this.cacheTime = cacheTime;
        this.isPersonal = isPersonal;
        this.nextOffset = nextOffset;
        this.button = button;
    }

    public static class AnswerInlineQueryBuilder {
        private String inlineQueryId;
        private ArrayList<InlineQueryResult> results;
        private Integer cacheTime;
        private Boolean isPersonal;
        private String nextOffset;
        private InlineQueryResultsButton button;

        AnswerInlineQueryBuilder() {
        }

        @JsonProperty(value="inline_query_id")
        public AnswerInlineQueryBuilder inlineQueryId(@NonNull String inlineQueryId) {
            if (inlineQueryId == null) {
                throw new NullPointerException("inlineQueryId is marked non-null but is null");
            }
            this.inlineQueryId = inlineQueryId;
            return this;
        }

        public AnswerInlineQueryBuilder result(InlineQueryResult result) {
            if (this.results == null) {
                this.results = new ArrayList();
            }
            this.results.add(result);
            return this;
        }

        @JsonProperty(value="results")
        public AnswerInlineQueryBuilder results(Collection<? extends InlineQueryResult> results) {
            if (results == null) {
                throw new NullPointerException("results cannot be null");
            }
            if (this.results == null) {
                this.results = new ArrayList();
            }
            this.results.addAll(results);
            return this;
        }

        public AnswerInlineQueryBuilder clearResults() {
            if (this.results != null) {
                this.results.clear();
            }
            return this;
        }

        @JsonProperty(value="cache_time")
        public AnswerInlineQueryBuilder cacheTime(Integer cacheTime) {
            this.cacheTime = cacheTime;
            return this;
        }

        @JsonProperty(value="is_personal")
        public AnswerInlineQueryBuilder isPersonal(Boolean isPersonal) {
            this.isPersonal = isPersonal;
            return this;
        }

        @JsonProperty(value="next_offset")
        public AnswerInlineQueryBuilder nextOffset(String nextOffset) {
            this.nextOffset = nextOffset;
            return this;
        }

        @JsonProperty(value="button")
        public AnswerInlineQueryBuilder button(InlineQueryResultsButton button) {
            this.button = button;
            return this;
        }

        public AnswerInlineQuery build() {
            return new AnswerInlineQuery(this.inlineQueryId, switch (this.results == null ? 0 : this.results.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.results.get(0));
                default -> Collections.unmodifiableList(new ArrayList<InlineQueryResult>(this.results));
            }, this.cacheTime, this.isPersonal, this.nextOffset, this.button);
        }

        public String toString() {
            return "AnswerInlineQuery.AnswerInlineQueryBuilder(inlineQueryId=" + this.inlineQueryId + ", results=" + this.results + ", cacheTime=" + this.cacheTime + ", isPersonal=" + this.isPersonal + ", nextOffset=" + this.nextOffset + ", button=" + this.button + ")";
        }
    }
}

