/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.MessageId;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class CopyMessages
extends BotApiMethod<ArrayList<MessageId>> {
    public static final String PATH = "copyMessages";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_THREAD_ID_FIELD = "message_thread_id";
    private static final String FROM_CHAT_ID_FIELD = "from_chat_id";
    private static final String MESSAGE_IDS_FIELD = "message_ids";
    private static final String DISABLE_NOTIFICATION_FIELD = "disable_notification";
    private static final String PROTECT_CONTENT_FIELD = "protect_content";
    private static final String REMOVE_CAPTION_FIELD = "remove_caption";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_thread_id")
    private Integer messageThreadId;
    @JsonProperty(value="from_chat_id")
    @NonNull
    private String fromChatId;
    @JsonProperty(value="message_ids")
    @NonNull
    private List<Integer> messageIds;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="protect_content")
    private Boolean protectContent;
    @JsonProperty(value="remove_caption")
    private Boolean removeCaption;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void setFromChatId(@NonNull Long fromChatId) {
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        this.fromChatId = fromChatId.toString();
    }

    public void enableNotification() {
        this.disableNotification = null;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public ArrayList<MessageId> deserializeResponse(String answer) throws TelegramApiRequestException {
        return (ArrayList)this.deserializeResponseArray(answer, MessageId.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.messageIds.isEmpty() || this.messageIds.size() > 100) {
            throw new TelegramApiValidationException("MessageIds parameter items count must be between 1 and 100", this);
        }
    }

    public static CopyMessagesBuilder builder() {
        return new CopyMessagesBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CopyMessages)) {
            return false;
        }
        CopyMessages other = (CopyMessages)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        Boolean this$removeCaption = this.getRemoveCaption();
        Boolean other$removeCaption = other.getRemoveCaption();
        if (this$removeCaption == null ? other$removeCaption != null : !((Object)this$removeCaption).equals(other$removeCaption)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$fromChatId = this.getFromChatId();
        String other$fromChatId = other.getFromChatId();
        if (this$fromChatId == null ? other$fromChatId != null : !this$fromChatId.equals(other$fromChatId)) {
            return false;
        }
        List<Integer> this$messageIds = this.getMessageIds();
        List<Integer> other$messageIds = other.getMessageIds();
        return !(this$messageIds == null ? other$messageIds != null : !((Object)this$messageIds).equals(other$messageIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CopyMessages;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        Boolean $removeCaption = this.getRemoveCaption();
        result = result * 59 + ($removeCaption == null ? 43 : ((Object)$removeCaption).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $fromChatId = this.getFromChatId();
        result = result * 59 + ($fromChatId == null ? 43 : $fromChatId.hashCode());
        List<Integer> $messageIds = this.getMessageIds();
        result = result * 59 + ($messageIds == null ? 43 : ((Object)$messageIds).hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @NonNull
    public String getFromChatId() {
        return this.fromChatId;
    }

    @NonNull
    public List<Integer> getMessageIds() {
        return this.messageIds;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public Boolean getProtectContent() {
        return this.protectContent;
    }

    public Boolean getRemoveCaption() {
        return this.removeCaption;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_thread_id")
    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    @JsonProperty(value="from_chat_id")
    public void setFromChatId(@NonNull String fromChatId) {
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        this.fromChatId = fromChatId;
    }

    @JsonProperty(value="message_ids")
    public void setMessageIds(@NonNull List<Integer> messageIds) {
        if (messageIds == null) {
            throw new NullPointerException("messageIds is marked non-null but is null");
        }
        this.messageIds = messageIds;
    }

    @JsonProperty(value="disable_notification")
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @JsonProperty(value="protect_content")
    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    @JsonProperty(value="remove_caption")
    public void setRemoveCaption(Boolean removeCaption) {
        this.removeCaption = removeCaption;
    }

    public String toString() {
        return "CopyMessages(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", fromChatId=" + this.getFromChatId() + ", messageIds=" + this.getMessageIds() + ", disableNotification=" + this.getDisableNotification() + ", protectContent=" + this.getProtectContent() + ", removeCaption=" + this.getRemoveCaption() + ")";
    }

    public CopyMessages(@NonNull String chatId, @NonNull String fromChatId, @NonNull List<Integer> messageIds) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        if (messageIds == null) {
            throw new NullPointerException("messageIds is marked non-null but is null");
        }
        this.chatId = chatId;
        this.fromChatId = fromChatId;
        this.messageIds = messageIds;
    }

    public CopyMessages() {
    }

    public CopyMessages(@NonNull String chatId, Integer messageThreadId, @NonNull String fromChatId, @NonNull List<Integer> messageIds, Boolean disableNotification, Boolean protectContent, Boolean removeCaption) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        if (messageIds == null) {
            throw new NullPointerException("messageIds is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.fromChatId = fromChatId;
        this.messageIds = messageIds;
        this.disableNotification = disableNotification;
        this.protectContent = protectContent;
        this.removeCaption = removeCaption;
    }

    public static class CopyMessagesBuilder {
        private String chatId;
        private Integer messageThreadId;
        private String fromChatId;
        private ArrayList<Integer> messageIds;
        private Boolean disableNotification;
        private Boolean protectContent;
        private Boolean removeCaption;

        public CopyMessagesBuilder chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        public CopyMessagesBuilder fromChatId(@NonNull Long fromChatId) {
            if (fromChatId == null) {
                throw new NullPointerException("fromChatId is marked non-null but is null");
            }
            this.fromChatId = fromChatId.toString();
            return this;
        }

        CopyMessagesBuilder() {
        }

        @JsonProperty(value="chat_id")
        public CopyMessagesBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="message_thread_id")
        public CopyMessagesBuilder messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return this;
        }

        @JsonProperty(value="from_chat_id")
        public CopyMessagesBuilder fromChatId(@NonNull String fromChatId) {
            if (fromChatId == null) {
                throw new NullPointerException("fromChatId is marked non-null but is null");
            }
            this.fromChatId = fromChatId;
            return this;
        }

        public CopyMessagesBuilder messageId(Integer messageId) {
            if (this.messageIds == null) {
                this.messageIds = new ArrayList();
            }
            this.messageIds.add(messageId);
            return this;
        }

        @JsonProperty(value="message_ids")
        public CopyMessagesBuilder messageIds(Collection<? extends Integer> messageIds) {
            if (messageIds == null) {
                throw new NullPointerException("messageIds cannot be null");
            }
            if (this.messageIds == null) {
                this.messageIds = new ArrayList();
            }
            this.messageIds.addAll(messageIds);
            return this;
        }

        public CopyMessagesBuilder clearMessageIds() {
            if (this.messageIds != null) {
                this.messageIds.clear();
            }
            return this;
        }

        @JsonProperty(value="disable_notification")
        public CopyMessagesBuilder disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        @JsonProperty(value="protect_content")
        public CopyMessagesBuilder protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return this;
        }

        @JsonProperty(value="remove_caption")
        public CopyMessagesBuilder removeCaption(Boolean removeCaption) {
            this.removeCaption = removeCaption;
            return this;
        }

        public CopyMessages build() {
            return new CopyMessages(this.chatId, this.messageThreadId, this.fromChatId, switch (this.messageIds == null ? 0 : this.messageIds.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.messageIds.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Integer>(this.messageIds));
            }, this.disableNotification, this.protectContent, this.removeCaption);
        }

        public String toString() {
            return "CopyMessages.CopyMessagesBuilder(chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", fromChatId=" + this.fromChatId + ", messageIds=" + this.messageIds + ", disableNotification=" + this.disableNotification + ", protectContent=" + this.protectContent + ", removeCaption=" + this.removeCaption + ")";
        }
    }
}

