/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.BotApiMethod;
import org.telegram.telegrambots.meta.api.objects.MessageId;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class ForwardMessages
extends BotApiMethod<ArrayList<MessageId>> {
    public static final String PATH = "forwardMessages";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String MESSAGE_THREAD_ID_FIELD = "message_thread_id";
    private static final String FROM_CHAT_ID_FIELD = "from_chat_id";
    private static final String MESSAGE_IDS_FIELD = "message_ids";
    private static final String DISABLE_NOTIFICATION_FIELD = "disable_notification";
    private static final String PROTECT_CONTENT_FIELD = "protect_content";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_thread_id")
    private Integer messageThreadId;
    @JsonProperty(value="from_chat_id")
    @NonNull
    private String fromChatId;
    @JsonProperty(value="message_ids")
    @NonNull
    private List<Integer> messageIds;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="protect_content")
    private Boolean protectContent;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void setFromChatId(@NonNull Long fromChatId) {
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        this.fromChatId = fromChatId.toString();
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId can't be empty", this);
        }
        if (this.fromChatId.isEmpty()) {
            throw new TelegramApiValidationException("FromChatId can't be empty", this);
        }
        if (this.messageIds.isEmpty() || this.messageIds.size() > 100) {
            throw new TelegramApiValidationException("MessageIds parameter items count must be between 1 and 100", this);
        }
    }

    @Override
    public ArrayList<MessageId> deserializeResponse(String answer) throws TelegramApiRequestException {
        return (ArrayList)this.deserializeResponseArray(answer, MessageId.class);
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    public static ForwardMessagesBuilder builder() {
        return new ForwardMessagesBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ForwardMessages)) {
            return false;
        }
        ForwardMessages other = (ForwardMessages)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$fromChatId = this.getFromChatId();
        String other$fromChatId = other.getFromChatId();
        if (this$fromChatId == null ? other$fromChatId != null : !this$fromChatId.equals(other$fromChatId)) {
            return false;
        }
        List<Integer> this$messageIds = this.getMessageIds();
        List<Integer> other$messageIds = other.getMessageIds();
        return !(this$messageIds == null ? other$messageIds != null : !((Object)this$messageIds).equals(other$messageIds));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ForwardMessages;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $fromChatId = this.getFromChatId();
        result = result * 59 + ($fromChatId == null ? 43 : $fromChatId.hashCode());
        List<Integer> $messageIds = this.getMessageIds();
        result = result * 59 + ($messageIds == null ? 43 : ((Object)$messageIds).hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @NonNull
    public String getFromChatId() {
        return this.fromChatId;
    }

    @NonNull
    public List<Integer> getMessageIds() {
        return this.messageIds;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public Boolean getProtectContent() {
        return this.protectContent;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_thread_id")
    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    @JsonProperty(value="from_chat_id")
    public void setFromChatId(@NonNull String fromChatId) {
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        this.fromChatId = fromChatId;
    }

    @JsonProperty(value="message_ids")
    public void setMessageIds(@NonNull List<Integer> messageIds) {
        if (messageIds == null) {
            throw new NullPointerException("messageIds is marked non-null but is null");
        }
        this.messageIds = messageIds;
    }

    @JsonProperty(value="disable_notification")
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @JsonProperty(value="protect_content")
    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    public String toString() {
        return "ForwardMessages(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", fromChatId=" + this.getFromChatId() + ", messageIds=" + this.getMessageIds() + ", disableNotification=" + this.getDisableNotification() + ", protectContent=" + this.getProtectContent() + ")";
    }

    public ForwardMessages() {
    }

    public ForwardMessages(@NonNull String chatId, @NonNull String fromChatId, @NonNull List<Integer> messageIds) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        if (messageIds == null) {
            throw new NullPointerException("messageIds is marked non-null but is null");
        }
        this.chatId = chatId;
        this.fromChatId = fromChatId;
        this.messageIds = messageIds;
    }

    public ForwardMessages(@NonNull String chatId, Integer messageThreadId, @NonNull String fromChatId, @NonNull List<Integer> messageIds, Boolean disableNotification, Boolean protectContent) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (fromChatId == null) {
            throw new NullPointerException("fromChatId is marked non-null but is null");
        }
        if (messageIds == null) {
            throw new NullPointerException("messageIds is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.fromChatId = fromChatId;
        this.messageIds = messageIds;
        this.disableNotification = disableNotification;
        this.protectContent = protectContent;
    }

    public static class ForwardMessagesBuilder {
        private String chatId;
        private Integer messageThreadId;
        private String fromChatId;
        private ArrayList<Integer> messageIds;
        private Boolean disableNotification;
        private Boolean protectContent;

        public ForwardMessagesBuilder chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        public ForwardMessagesBuilder fromChatId(@NonNull Long fromChatId) {
            if (fromChatId == null) {
                throw new NullPointerException("fromChatId is marked non-null but is null");
            }
            this.fromChatId = fromChatId.toString();
            return this;
        }

        ForwardMessagesBuilder() {
        }

        @JsonProperty(value="chat_id")
        public ForwardMessagesBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="message_thread_id")
        public ForwardMessagesBuilder messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return this;
        }

        @JsonProperty(value="from_chat_id")
        public ForwardMessagesBuilder fromChatId(@NonNull String fromChatId) {
            if (fromChatId == null) {
                throw new NullPointerException("fromChatId is marked non-null but is null");
            }
            this.fromChatId = fromChatId;
            return this;
        }

        public ForwardMessagesBuilder messageId(Integer messageId) {
            if (this.messageIds == null) {
                this.messageIds = new ArrayList();
            }
            this.messageIds.add(messageId);
            return this;
        }

        @JsonProperty(value="message_ids")
        public ForwardMessagesBuilder messageIds(Collection<? extends Integer> messageIds) {
            if (messageIds == null) {
                throw new NullPointerException("messageIds cannot be null");
            }
            if (this.messageIds == null) {
                this.messageIds = new ArrayList();
            }
            this.messageIds.addAll(messageIds);
            return this;
        }

        public ForwardMessagesBuilder clearMessageIds() {
            if (this.messageIds != null) {
                this.messageIds.clear();
            }
            return this;
        }

        @JsonProperty(value="disable_notification")
        public ForwardMessagesBuilder disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        @JsonProperty(value="protect_content")
        public ForwardMessagesBuilder protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return this;
        }

        public ForwardMessages build() {
            return new ForwardMessages(this.chatId, this.messageThreadId, this.fromChatId, switch (this.messageIds == null ? 0 : this.messageIds.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.messageIds.get(0));
                default -> Collections.unmodifiableList(new ArrayList<Integer>(this.messageIds));
            }, this.disableNotification, this.protectContent);
        }

        public String toString() {
            return "ForwardMessages.ForwardMessagesBuilder(chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", fromChatId=" + this.fromChatId + ", messageIds=" + this.messageIds + ", disableNotification=" + this.disableNotification + ", protectContent=" + this.protectContent + ")";
        }
    }
}

