/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.polls;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.botapimethods.BotApiMethodMessage;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.ReplyParameters;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.ReplyKeyboard;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SendPoll
extends BotApiMethodMessage {
    public static final String PATH = "sendPoll";
    private static final String CHATID_FIELD = "chat_id";
    private static final String MESSAGETHREADID_FIELD = "message_thread_id";
    private static final String QUESTION_FIELD = "question";
    private static final String OPTIONS_FIELD = "options";
    private static final String ISANONYMOUS_FIELD = "is_anonymous";
    private static final String TYPE_FIELD = "type";
    private static final String ALLOWMULTIPLEANSWERS_FIELD = "allows_multiple_answers";
    private static final String CORRECTOPTIONID_FIELD = "correct_option_id";
    private static final String ISCLOSED_FIELD = "is_closed";
    private static final String DISABLENOTIFICATION_FIELD = "disable_notification";
    private static final String REPLYTOMESSAGEID_FIELD = "reply_to_message_id";
    private static final String REPLYMARKUP_FIELD = "reply_markup";
    private static final String OPENPERIOD_FIELD = "open_period";
    private static final String CLOSEDATE_FIELD = "close_date";
    private static final String EXPLANATION_FIELD = "explanation";
    private static final String EXPLANATIONPARSEMODE_FIELD = "explanation_parse_mode";
    private static final String EXPLANATION_ENTITIES_FIELD = "explanation_entities";
    private static final String ALLOWSENDINGWITHOUTREPLY_FIELD = "allow_sending_without_reply";
    private static final String PROTECTCONTENT_FIELD = "protect_content";
    private static final String REPLY_PARAMETERS_FIELD = "reply_parameters";
    @JsonProperty(value="chat_id")
    @NonNull
    private String chatId;
    @JsonProperty(value="message_thread_id")
    private Integer messageThreadId;
    @JsonProperty(value="question")
    @NonNull
    private String question;
    @JsonProperty(value="options")
    @NonNull
    private List<String> options;
    @JsonProperty(value="is_anonymous")
    private Boolean isAnonymous;
    @JsonProperty(value="type")
    private String type;
    @JsonProperty(value="allows_multiple_answers")
    private Boolean allowMultipleAnswers;
    @JsonProperty(value="correct_option_id")
    private Integer correctOptionId;
    @JsonProperty(value="is_closed")
    private Boolean isClosed;
    @JsonProperty(value="disable_notification")
    private Boolean disableNotification;
    @JsonProperty(value="reply_to_message_id")
    private Integer replyToMessageId;
    @JsonProperty(value="reply_markup")
    @JsonDeserialize
    private ReplyKeyboard replyMarkup;
    @JsonProperty(value="open_period")
    private Integer openPeriod;
    @JsonProperty(value="close_date")
    private Integer closeDate;
    @JsonProperty(value="explanation")
    private String explanation;
    @JsonProperty(value="explanation_parse_mode")
    private String explanationParseMode;
    @JsonProperty(value="explanation_entities")
    private List<MessageEntity> explanationEntities;
    @JsonProperty(value="allow_sending_without_reply")
    private Boolean allowSendingWithoutReply;
    @JsonProperty(value="protect_content")
    private Boolean protectContent;
    @JsonProperty(value="reply_parameters")
    private ReplyParameters replyParameters;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void enableNotification() {
        this.disableNotification = null;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.question.isEmpty()) {
            throw new TelegramApiValidationException("Question parameter can't be empty", this);
        }
        if (this.options.size() < 2 || this.options.size() > 10) {
            throw new TelegramApiValidationException("Options parameter must be between 2 and 10 item", this);
        }
        if (this.openPeriod != null && this.closeDate != null) {
            throw new TelegramApiValidationException("Only one of Open Period and Close Date are allowed", this);
        }
        if (this.openPeriod != null && (this.openPeriod < 5 || this.openPeriod > 600)) {
            throw new TelegramApiValidationException("Open period can only be between 5 and 600", this);
        }
        if (this.explanation != null && this.explanation.length() > 200) {
            throw new TelegramApiValidationException("Explanation can only have up to 200 characters", this);
        }
        if (this.options.parallelStream().anyMatch(x -> x.isEmpty() || x.length() > 100)) {
            throw new TelegramApiValidationException("Options parameter values must be between 1 and 100 chars length", this);
        }
        if (this.explanationParseMode != null && this.explanationEntities != null && !this.explanationEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
        if (this.replyParameters != null) {
            this.replyParameters.validate();
        }
    }

    public static SendPollBuilder builder() {
        return new SendPollBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendPoll)) {
            return false;
        }
        SendPoll other = (SendPoll)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Boolean this$isAnonymous = this.getIsAnonymous();
        Boolean other$isAnonymous = other.getIsAnonymous();
        if (this$isAnonymous == null ? other$isAnonymous != null : !((Object)this$isAnonymous).equals(other$isAnonymous)) {
            return false;
        }
        Boolean this$allowMultipleAnswers = this.getAllowMultipleAnswers();
        Boolean other$allowMultipleAnswers = other.getAllowMultipleAnswers();
        if (this$allowMultipleAnswers == null ? other$allowMultipleAnswers != null : !((Object)this$allowMultipleAnswers).equals(other$allowMultipleAnswers)) {
            return false;
        }
        Integer this$correctOptionId = this.getCorrectOptionId();
        Integer other$correctOptionId = other.getCorrectOptionId();
        if (this$correctOptionId == null ? other$correctOptionId != null : !((Object)this$correctOptionId).equals(other$correctOptionId)) {
            return false;
        }
        Boolean this$isClosed = this.getIsClosed();
        Boolean other$isClosed = other.getIsClosed();
        if (this$isClosed == null ? other$isClosed != null : !((Object)this$isClosed).equals(other$isClosed)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Integer this$replyToMessageId = this.getReplyToMessageId();
        Integer other$replyToMessageId = other.getReplyToMessageId();
        if (this$replyToMessageId == null ? other$replyToMessageId != null : !((Object)this$replyToMessageId).equals(other$replyToMessageId)) {
            return false;
        }
        Integer this$openPeriod = this.getOpenPeriod();
        Integer other$openPeriod = other.getOpenPeriod();
        if (this$openPeriod == null ? other$openPeriod != null : !((Object)this$openPeriod).equals(other$openPeriod)) {
            return false;
        }
        Integer this$closeDate = this.getCloseDate();
        Integer other$closeDate = other.getCloseDate();
        if (this$closeDate == null ? other$closeDate != null : !((Object)this$closeDate).equals(other$closeDate)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$question = this.getQuestion();
        String other$question = other.getQuestion();
        if (this$question == null ? other$question != null : !this$question.equals(other$question)) {
            return false;
        }
        List<String> this$options = this.getOptions();
        List<String> other$options = other.getOptions();
        if (this$options == null ? other$options != null : !((Object)this$options).equals(other$options)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        ReplyKeyboard this$replyMarkup = this.getReplyMarkup();
        ReplyKeyboard other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !this$replyMarkup.equals(other$replyMarkup)) {
            return false;
        }
        String this$explanation = this.getExplanation();
        String other$explanation = other.getExplanation();
        if (this$explanation == null ? other$explanation != null : !this$explanation.equals(other$explanation)) {
            return false;
        }
        String this$explanationParseMode = this.getExplanationParseMode();
        String other$explanationParseMode = other.getExplanationParseMode();
        if (this$explanationParseMode == null ? other$explanationParseMode != null : !this$explanationParseMode.equals(other$explanationParseMode)) {
            return false;
        }
        List<MessageEntity> this$explanationEntities = this.getExplanationEntities();
        List<MessageEntity> other$explanationEntities = other.getExplanationEntities();
        if (this$explanationEntities == null ? other$explanationEntities != null : !((Object)this$explanationEntities).equals(other$explanationEntities)) {
            return false;
        }
        ReplyParameters this$replyParameters = this.getReplyParameters();
        ReplyParameters other$replyParameters = other.getReplyParameters();
        return !(this$replyParameters == null ? other$replyParameters != null : !((Object)this$replyParameters).equals(other$replyParameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendPoll;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Boolean $isAnonymous = this.getIsAnonymous();
        result = result * 59 + ($isAnonymous == null ? 43 : ((Object)$isAnonymous).hashCode());
        Boolean $allowMultipleAnswers = this.getAllowMultipleAnswers();
        result = result * 59 + ($allowMultipleAnswers == null ? 43 : ((Object)$allowMultipleAnswers).hashCode());
        Integer $correctOptionId = this.getCorrectOptionId();
        result = result * 59 + ($correctOptionId == null ? 43 : ((Object)$correctOptionId).hashCode());
        Boolean $isClosed = this.getIsClosed();
        result = result * 59 + ($isClosed == null ? 43 : ((Object)$isClosed).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Integer $replyToMessageId = this.getReplyToMessageId();
        result = result * 59 + ($replyToMessageId == null ? 43 : ((Object)$replyToMessageId).hashCode());
        Integer $openPeriod = this.getOpenPeriod();
        result = result * 59 + ($openPeriod == null ? 43 : ((Object)$openPeriod).hashCode());
        Integer $closeDate = this.getCloseDate();
        result = result * 59 + ($closeDate == null ? 43 : ((Object)$closeDate).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $question = this.getQuestion();
        result = result * 59 + ($question == null ? 43 : $question.hashCode());
        List<String> $options = this.getOptions();
        result = result * 59 + ($options == null ? 43 : ((Object)$options).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        ReplyKeyboard $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : $replyMarkup.hashCode());
        String $explanation = this.getExplanation();
        result = result * 59 + ($explanation == null ? 43 : $explanation.hashCode());
        String $explanationParseMode = this.getExplanationParseMode();
        result = result * 59 + ($explanationParseMode == null ? 43 : $explanationParseMode.hashCode());
        List<MessageEntity> $explanationEntities = this.getExplanationEntities();
        result = result * 59 + ($explanationEntities == null ? 43 : ((Object)$explanationEntities).hashCode());
        ReplyParameters $replyParameters = this.getReplyParameters();
        result = result * 59 + ($replyParameters == null ? 43 : ((Object)$replyParameters).hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @NonNull
    public String getQuestion() {
        return this.question;
    }

    @NonNull
    public List<String> getOptions() {
        return this.options;
    }

    public Boolean getIsAnonymous() {
        return this.isAnonymous;
    }

    public String getType() {
        return this.type;
    }

    public Boolean getAllowMultipleAnswers() {
        return this.allowMultipleAnswers;
    }

    public Integer getCorrectOptionId() {
        return this.correctOptionId;
    }

    public Boolean getIsClosed() {
        return this.isClosed;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public ReplyKeyboard getReplyMarkup() {
        return this.replyMarkup;
    }

    public Integer getOpenPeriod() {
        return this.openPeriod;
    }

    public Integer getCloseDate() {
        return this.closeDate;
    }

    public String getExplanation() {
        return this.explanation;
    }

    public String getExplanationParseMode() {
        return this.explanationParseMode;
    }

    public List<MessageEntity> getExplanationEntities() {
        return this.explanationEntities;
    }

    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    public Boolean getProtectContent() {
        return this.protectContent;
    }

    public ReplyParameters getReplyParameters() {
        return this.replyParameters;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    @JsonProperty(value="message_thread_id")
    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    @JsonProperty(value="question")
    public void setQuestion(@NonNull String question) {
        if (question == null) {
            throw new NullPointerException("question is marked non-null but is null");
        }
        this.question = question;
    }

    @JsonProperty(value="options")
    public void setOptions(@NonNull List<String> options) {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.options = options;
    }

    @JsonProperty(value="is_anonymous")
    public void setIsAnonymous(Boolean isAnonymous) {
        this.isAnonymous = isAnonymous;
    }

    @JsonProperty(value="type")
    public void setType(String type) {
        this.type = type;
    }

    @JsonProperty(value="allows_multiple_answers")
    public void setAllowMultipleAnswers(Boolean allowMultipleAnswers) {
        this.allowMultipleAnswers = allowMultipleAnswers;
    }

    @JsonProperty(value="correct_option_id")
    public void setCorrectOptionId(Integer correctOptionId) {
        this.correctOptionId = correctOptionId;
    }

    @JsonProperty(value="is_closed")
    public void setIsClosed(Boolean isClosed) {
        this.isClosed = isClosed;
    }

    @JsonProperty(value="disable_notification")
    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    @JsonProperty(value="reply_to_message_id")
    public void setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
    }

    @JsonProperty(value="reply_markup")
    @JsonDeserialize
    public void setReplyMarkup(ReplyKeyboard replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="open_period")
    public void setOpenPeriod(Integer openPeriod) {
        this.openPeriod = openPeriod;
    }

    @JsonProperty(value="close_date")
    public void setCloseDate(Integer closeDate) {
        this.closeDate = closeDate;
    }

    @JsonProperty(value="explanation")
    public void setExplanation(String explanation) {
        this.explanation = explanation;
    }

    @JsonProperty(value="explanation_parse_mode")
    public void setExplanationParseMode(String explanationParseMode) {
        this.explanationParseMode = explanationParseMode;
    }

    @JsonProperty(value="explanation_entities")
    public void setExplanationEntities(List<MessageEntity> explanationEntities) {
        this.explanationEntities = explanationEntities;
    }

    @JsonProperty(value="allow_sending_without_reply")
    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    @JsonProperty(value="protect_content")
    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    @JsonProperty(value="reply_parameters")
    public void setReplyParameters(ReplyParameters replyParameters) {
        this.replyParameters = replyParameters;
    }

    public String toString() {
        return "SendPoll(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", question=" + this.getQuestion() + ", options=" + this.getOptions() + ", isAnonymous=" + this.getIsAnonymous() + ", type=" + this.getType() + ", allowMultipleAnswers=" + this.getAllowMultipleAnswers() + ", correctOptionId=" + this.getCorrectOptionId() + ", isClosed=" + this.getIsClosed() + ", disableNotification=" + this.getDisableNotification() + ", replyToMessageId=" + this.getReplyToMessageId() + ", replyMarkup=" + this.getReplyMarkup() + ", openPeriod=" + this.getOpenPeriod() + ", closeDate=" + this.getCloseDate() + ", explanation=" + this.getExplanation() + ", explanationParseMode=" + this.getExplanationParseMode() + ", explanationEntities=" + this.getExplanationEntities() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ", protectContent=" + this.getProtectContent() + ", replyParameters=" + this.getReplyParameters() + ")";
    }

    public SendPoll(@NonNull String chatId, @NonNull String question, @NonNull List<String> options) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (question == null) {
            throw new NullPointerException("question is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.chatId = chatId;
        this.question = question;
        this.options = options;
    }

    public SendPoll() {
    }

    public SendPoll(@NonNull String chatId, Integer messageThreadId, @NonNull String question, @NonNull List<String> options, Boolean isAnonymous, String type, Boolean allowMultipleAnswers, Integer correctOptionId, Boolean isClosed, Boolean disableNotification, Integer replyToMessageId, ReplyKeyboard replyMarkup, Integer openPeriod, Integer closeDate, String explanation, String explanationParseMode, List<MessageEntity> explanationEntities, Boolean allowSendingWithoutReply, Boolean protectContent, ReplyParameters replyParameters) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (question == null) {
            throw new NullPointerException("question is marked non-null but is null");
        }
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.question = question;
        this.options = options;
        this.isAnonymous = isAnonymous;
        this.type = type;
        this.allowMultipleAnswers = allowMultipleAnswers;
        this.correctOptionId = correctOptionId;
        this.isClosed = isClosed;
        this.disableNotification = disableNotification;
        this.replyToMessageId = replyToMessageId;
        this.replyMarkup = replyMarkup;
        this.openPeriod = openPeriod;
        this.closeDate = closeDate;
        this.explanation = explanation;
        this.explanationParseMode = explanationParseMode;
        this.explanationEntities = explanationEntities;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
        this.protectContent = protectContent;
        this.replyParameters = replyParameters;
    }

    public static class SendPollBuilder {
        private String chatId;
        private Integer messageThreadId;
        private String question;
        private ArrayList<String> options;
        private Boolean isAnonymous;
        private String type;
        private Boolean allowMultipleAnswers;
        private Integer correctOptionId;
        private Boolean isClosed;
        private Boolean disableNotification;
        private Integer replyToMessageId;
        private ReplyKeyboard replyMarkup;
        private Integer openPeriod;
        private Integer closeDate;
        private String explanation;
        private String explanationParseMode;
        private ArrayList<MessageEntity> explanationEntities;
        private Boolean allowSendingWithoutReply;
        private Boolean protectContent;
        private ReplyParameters replyParameters;

        public SendPollBuilder chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        SendPollBuilder() {
        }

        @JsonProperty(value="chat_id")
        public SendPollBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="message_thread_id")
        public SendPollBuilder messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return this;
        }

        @JsonProperty(value="question")
        public SendPollBuilder question(@NonNull String question) {
            if (question == null) {
                throw new NullPointerException("question is marked non-null but is null");
            }
            this.question = question;
            return this;
        }

        public SendPollBuilder option(String option) {
            if (this.options == null) {
                this.options = new ArrayList();
            }
            this.options.add(option);
            return this;
        }

        @JsonProperty(value="options")
        public SendPollBuilder options(Collection<? extends String> options) {
            if (options == null) {
                throw new NullPointerException("options cannot be null");
            }
            if (this.options == null) {
                this.options = new ArrayList();
            }
            this.options.addAll(options);
            return this;
        }

        public SendPollBuilder clearOptions() {
            if (this.options != null) {
                this.options.clear();
            }
            return this;
        }

        @JsonProperty(value="is_anonymous")
        public SendPollBuilder isAnonymous(Boolean isAnonymous) {
            this.isAnonymous = isAnonymous;
            return this;
        }

        @JsonProperty(value="type")
        public SendPollBuilder type(String type) {
            this.type = type;
            return this;
        }

        @JsonProperty(value="allows_multiple_answers")
        public SendPollBuilder allowMultipleAnswers(Boolean allowMultipleAnswers) {
            this.allowMultipleAnswers = allowMultipleAnswers;
            return this;
        }

        @JsonProperty(value="correct_option_id")
        public SendPollBuilder correctOptionId(Integer correctOptionId) {
            this.correctOptionId = correctOptionId;
            return this;
        }

        @JsonProperty(value="is_closed")
        public SendPollBuilder isClosed(Boolean isClosed) {
            this.isClosed = isClosed;
            return this;
        }

        @JsonProperty(value="disable_notification")
        public SendPollBuilder disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        @JsonProperty(value="reply_to_message_id")
        public SendPollBuilder replyToMessageId(Integer replyToMessageId) {
            this.replyToMessageId = replyToMessageId;
            return this;
        }

        @JsonProperty(value="reply_markup")
        @JsonDeserialize
        public SendPollBuilder replyMarkup(ReplyKeyboard replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        @JsonProperty(value="open_period")
        public SendPollBuilder openPeriod(Integer openPeriod) {
            this.openPeriod = openPeriod;
            return this;
        }

        @JsonProperty(value="close_date")
        public SendPollBuilder closeDate(Integer closeDate) {
            this.closeDate = closeDate;
            return this;
        }

        @JsonProperty(value="explanation")
        public SendPollBuilder explanation(String explanation) {
            this.explanation = explanation;
            return this;
        }

        @JsonProperty(value="explanation_parse_mode")
        public SendPollBuilder explanationParseMode(String explanationParseMode) {
            this.explanationParseMode = explanationParseMode;
            return this;
        }

        public SendPollBuilder explanationEntity(MessageEntity explanationEntity) {
            if (this.explanationEntities == null) {
                this.explanationEntities = new ArrayList();
            }
            this.explanationEntities.add(explanationEntity);
            return this;
        }

        @JsonProperty(value="explanation_entities")
        public SendPollBuilder explanationEntities(Collection<? extends MessageEntity> explanationEntities) {
            if (explanationEntities == null) {
                throw new NullPointerException("explanationEntities cannot be null");
            }
            if (this.explanationEntities == null) {
                this.explanationEntities = new ArrayList();
            }
            this.explanationEntities.addAll(explanationEntities);
            return this;
        }

        public SendPollBuilder clearExplanationEntities() {
            if (this.explanationEntities != null) {
                this.explanationEntities.clear();
            }
            return this;
        }

        @JsonProperty(value="allow_sending_without_reply")
        public SendPollBuilder allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return this;
        }

        @JsonProperty(value="protect_content")
        public SendPollBuilder protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return this;
        }

        @JsonProperty(value="reply_parameters")
        public SendPollBuilder replyParameters(ReplyParameters replyParameters) {
            this.replyParameters = replyParameters;
            return this;
        }

        public SendPoll build() {
            return new SendPoll(this.chatId, this.messageThreadId, this.question, switch (this.options == null ? 0 : this.options.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.options.get(0));
                default -> Collections.unmodifiableList(new ArrayList<String>(this.options));
            }, this.isAnonymous, this.type, this.allowMultipleAnswers, this.correctOptionId, this.isClosed, this.disableNotification, this.replyToMessageId, this.replyMarkup, this.openPeriod, this.closeDate, this.explanation, this.explanationParseMode, switch (this.explanationEntities == null ? 0 : this.explanationEntities.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.explanationEntities.get(0));
                default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(this.explanationEntities));
            }, this.allowSendingWithoutReply, this.protectContent, this.replyParameters);
        }

        public String toString() {
            return "SendPoll.SendPollBuilder(chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", question=" + this.question + ", options=" + this.options + ", isAnonymous=" + this.isAnonymous + ", type=" + this.type + ", allowMultipleAnswers=" + this.allowMultipleAnswers + ", correctOptionId=" + this.correctOptionId + ", isClosed=" + this.isClosed + ", disableNotification=" + this.disableNotification + ", replyToMessageId=" + this.replyToMessageId + ", replyMarkup=" + this.replyMarkup + ", openPeriod=" + this.openPeriod + ", closeDate=" + this.closeDate + ", explanation=" + this.explanation + ", explanationParseMode=" + this.explanationParseMode + ", explanationEntities=" + this.explanationEntities + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ", protectContent=" + this.protectContent + ", replyParameters=" + this.replyParameters + ")";
        }
    }
}

