/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.send;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.Message;
import org.telegram.telegrambots.meta.api.objects.ReplyParameters;
import org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaAnimation;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaAudio;
import org.telegram.telegrambots.meta.api.objects.media.InputMediaDocument;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class SendMediaGroup
extends PartialBotApiMethod<ArrayList<Message>> {
    public static final String PATH = "sendMediaGroup";
    public static final String CHAT_ID_FIELD = "chat_id";
    public static final String MESSAGE_THREAD_ID_FIELD = "message_thread_id";
    public static final String MEDIA_FIELD = "media";
    public static final String REPLY_TO_MESSAGE_ID_FIELD = "reply_to_message_id";
    public static final String DISABLE_NOTIFICATION_FIELD = "disable_notification";
    public static final String ALLOW_SENDING_WITHOUT_REPLY_FIELD = "allow_sending_without_reply";
    public static final String PROTECT_CONTENT_FIELD = "protect_content";
    public static final String REPLY_PARAMETERS_FIELD = "reply_parameters";
    @NonNull
    private String chatId;
    private Integer messageThreadId;
    @NonNull
    private List<InputMedia> medias;
    private Integer replyToMessageId;
    private Boolean disableNotification;
    private Boolean allowSendingWithoutReply;
    private Boolean protectContent;
    private ReplyParameters replyParameters;

    public void setChatId(@NonNull Long chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId.toString();
    }

    public void enableNotification() {
        this.disableNotification = false;
    }

    public void disableNotification() {
        this.disableNotification = true;
    }

    @Override
    public ArrayList<Message> deserializeResponse(String answer) throws TelegramApiRequestException {
        return (ArrayList)this.deserializeResponseArray(answer, Message.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty", this);
        }
        if (this.medias.isEmpty()) {
            throw new TelegramApiValidationException("Media parameter can't be empty", this);
        }
        if (this.medias.size() < 2 || this.medias.size() > 10) {
            throw new TelegramApiValidationException("Number of media should be between 2 and 10", this);
        }
        for (InputMedia inputMedia : this.medias) {
            if (inputMedia == null) {
                throw new TelegramApiValidationException("Media parameter can not be empty", this);
            }
            if (inputMedia instanceof InputMediaAnimation) {
                throw new TelegramApiValidationException("Media parameter can not be an Animation", this);
            }
            inputMedia.validate();
        }
        if (this.medias.stream().anyMatch(x -> x instanceof InputMediaAudio)) {
            if (!this.medias.stream().allMatch(x -> x instanceof InputMediaAudio)) {
                throw new TelegramApiValidationException("Media parameter containing Audio can not have other types", this);
            }
        } else if (this.medias.stream().anyMatch(x -> x instanceof InputMediaDocument) && !this.medias.stream().allMatch(x -> x instanceof InputMediaDocument)) {
            throw new TelegramApiValidationException("Media parameter containing Document can not have other types", this);
        }
        if (this.replyParameters != null) {
            this.replyParameters.validate();
        }
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    public static SendMediaGroupBuilder builder() {
        return new SendMediaGroupBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SendMediaGroup)) {
            return false;
        }
        SendMediaGroup other = (SendMediaGroup)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageThreadId = this.getMessageThreadId();
        Integer other$messageThreadId = other.getMessageThreadId();
        if (this$messageThreadId == null ? other$messageThreadId != null : !((Object)this$messageThreadId).equals(other$messageThreadId)) {
            return false;
        }
        Integer this$replyToMessageId = this.getReplyToMessageId();
        Integer other$replyToMessageId = other.getReplyToMessageId();
        if (this$replyToMessageId == null ? other$replyToMessageId != null : !((Object)this$replyToMessageId).equals(other$replyToMessageId)) {
            return false;
        }
        Boolean this$disableNotification = this.getDisableNotification();
        Boolean other$disableNotification = other.getDisableNotification();
        if (this$disableNotification == null ? other$disableNotification != null : !((Object)this$disableNotification).equals(other$disableNotification)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        Boolean this$protectContent = this.getProtectContent();
        Boolean other$protectContent = other.getProtectContent();
        if (this$protectContent == null ? other$protectContent != null : !((Object)this$protectContent).equals(other$protectContent)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        List<InputMedia> this$medias = this.getMedias();
        List<InputMedia> other$medias = other.getMedias();
        if (this$medias == null ? other$medias != null : !((Object)this$medias).equals(other$medias)) {
            return false;
        }
        ReplyParameters this$replyParameters = this.getReplyParameters();
        ReplyParameters other$replyParameters = other.getReplyParameters();
        return !(this$replyParameters == null ? other$replyParameters != null : !((Object)this$replyParameters).equals(other$replyParameters));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SendMediaGroup;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageThreadId = this.getMessageThreadId();
        result = result * 59 + ($messageThreadId == null ? 43 : ((Object)$messageThreadId).hashCode());
        Integer $replyToMessageId = this.getReplyToMessageId();
        result = result * 59 + ($replyToMessageId == null ? 43 : ((Object)$replyToMessageId).hashCode());
        Boolean $disableNotification = this.getDisableNotification();
        result = result * 59 + ($disableNotification == null ? 43 : ((Object)$disableNotification).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        Boolean $protectContent = this.getProtectContent();
        result = result * 59 + ($protectContent == null ? 43 : ((Object)$protectContent).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        List<InputMedia> $medias = this.getMedias();
        result = result * 59 + ($medias == null ? 43 : ((Object)$medias).hashCode());
        ReplyParameters $replyParameters = this.getReplyParameters();
        result = result * 59 + ($replyParameters == null ? 43 : ((Object)$replyParameters).hashCode());
        return result;
    }

    @NonNull
    public String getChatId() {
        return this.chatId;
    }

    public Integer getMessageThreadId() {
        return this.messageThreadId;
    }

    @NonNull
    public List<InputMedia> getMedias() {
        return this.medias;
    }

    public Integer getReplyToMessageId() {
        return this.replyToMessageId;
    }

    public Boolean getDisableNotification() {
        return this.disableNotification;
    }

    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    public Boolean getProtectContent() {
        return this.protectContent;
    }

    public ReplyParameters getReplyParameters() {
        return this.replyParameters;
    }

    public void setChatId(@NonNull String chatId) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        this.chatId = chatId;
    }

    public void setMessageThreadId(Integer messageThreadId) {
        this.messageThreadId = messageThreadId;
    }

    public void setMedias(@NonNull List<InputMedia> medias) {
        if (medias == null) {
            throw new NullPointerException("medias is marked non-null but is null");
        }
        this.medias = medias;
    }

    public void setReplyToMessageId(Integer replyToMessageId) {
        this.replyToMessageId = replyToMessageId;
    }

    public void setDisableNotification(Boolean disableNotification) {
        this.disableNotification = disableNotification;
    }

    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    public void setProtectContent(Boolean protectContent) {
        this.protectContent = protectContent;
    }

    public void setReplyParameters(ReplyParameters replyParameters) {
        this.replyParameters = replyParameters;
    }

    public String toString() {
        return "SendMediaGroup(chatId=" + this.getChatId() + ", messageThreadId=" + this.getMessageThreadId() + ", medias=" + this.getMedias() + ", replyToMessageId=" + this.getReplyToMessageId() + ", disableNotification=" + this.getDisableNotification() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ", protectContent=" + this.getProtectContent() + ", replyParameters=" + this.getReplyParameters() + ")";
    }

    public SendMediaGroup(@NonNull String chatId, @NonNull List<InputMedia> medias) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (medias == null) {
            throw new NullPointerException("medias is marked non-null but is null");
        }
        this.chatId = chatId;
        this.medias = medias;
    }

    public SendMediaGroup() {
    }

    public SendMediaGroup(@NonNull String chatId, Integer messageThreadId, @NonNull List<InputMedia> medias, Integer replyToMessageId, Boolean disableNotification, Boolean allowSendingWithoutReply, Boolean protectContent, ReplyParameters replyParameters) {
        if (chatId == null) {
            throw new NullPointerException("chatId is marked non-null but is null");
        }
        if (medias == null) {
            throw new NullPointerException("medias is marked non-null but is null");
        }
        this.chatId = chatId;
        this.messageThreadId = messageThreadId;
        this.medias = medias;
        this.replyToMessageId = replyToMessageId;
        this.disableNotification = disableNotification;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
        this.protectContent = protectContent;
        this.replyParameters = replyParameters;
    }

    public static class SendMediaGroupBuilder {
        private String chatId;
        private Integer messageThreadId;
        private ArrayList<InputMedia> medias;
        private Integer replyToMessageId;
        private Boolean disableNotification;
        private Boolean allowSendingWithoutReply;
        private Boolean protectContent;
        private ReplyParameters replyParameters;

        public SendMediaGroupBuilder chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        SendMediaGroupBuilder() {
        }

        public SendMediaGroupBuilder chatId(@NonNull String chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId;
            return this;
        }

        public SendMediaGroupBuilder messageThreadId(Integer messageThreadId) {
            this.messageThreadId = messageThreadId;
            return this;
        }

        public SendMediaGroupBuilder media(InputMedia media) {
            if (this.medias == null) {
                this.medias = new ArrayList();
            }
            this.medias.add(media);
            return this;
        }

        public SendMediaGroupBuilder medias(Collection<? extends InputMedia> medias) {
            if (medias == null) {
                throw new NullPointerException("medias cannot be null");
            }
            if (this.medias == null) {
                this.medias = new ArrayList();
            }
            this.medias.addAll(medias);
            return this;
        }

        public SendMediaGroupBuilder clearMedias() {
            if (this.medias != null) {
                this.medias.clear();
            }
            return this;
        }

        public SendMediaGroupBuilder replyToMessageId(Integer replyToMessageId) {
            this.replyToMessageId = replyToMessageId;
            return this;
        }

        public SendMediaGroupBuilder disableNotification(Boolean disableNotification) {
            this.disableNotification = disableNotification;
            return this;
        }

        public SendMediaGroupBuilder allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return this;
        }

        public SendMediaGroupBuilder protectContent(Boolean protectContent) {
            this.protectContent = protectContent;
            return this;
        }

        public SendMediaGroupBuilder replyParameters(ReplyParameters replyParameters) {
            this.replyParameters = replyParameters;
            return this;
        }

        public SendMediaGroup build() {
            return new SendMediaGroup(this.chatId, this.messageThreadId, switch (this.medias == null ? 0 : this.medias.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.medias.get(0));
                default -> Collections.unmodifiableList(new ArrayList<InputMedia>(this.medias));
            }, this.replyToMessageId, this.disableNotification, this.allowSendingWithoutReply, this.protectContent, this.replyParameters);
        }

        public String toString() {
            return "SendMediaGroup.SendMediaGroupBuilder(chatId=" + this.chatId + ", messageThreadId=" + this.messageThreadId + ", medias=" + this.medias + ", replyToMessageId=" + this.replyToMessageId + ", disableNotification=" + this.disableNotification + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ", protectContent=" + this.protectContent + ", replyParameters=" + this.replyParameters + ")";
        }
    }
}

