/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.stickers.InputSticker;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class AddStickerToSet
extends PartialBotApiMethod<Boolean> {
    public static final String PATH = "addStickerToSet";
    public static final String USERID_FIELD = "user_id";
    public static final String NAME_FIELD = "name";
    public static final String STICKER_FIELD = "sticker";
    @NonNull
    private Long userId;
    @NonNull
    private String name;
    @NonNull
    private InputSticker sticker;

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Boolean.class);
    }

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.userId <= 0L) {
            throw new TelegramApiValidationException("userId can't be empty", this);
        }
        if (this.name.isEmpty()) {
            throw new TelegramApiValidationException("name can't be empty", this);
        }
        if (this.sticker == null) {
            throw new TelegramApiValidationException("Sticker can't be empty", this);
        }
        this.sticker.validate();
    }

    public static AddStickerToSetBuilder builder() {
        return new AddStickerToSetBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AddStickerToSet)) {
            return false;
        }
        AddStickerToSet other = (AddStickerToSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        InputSticker this$sticker = this.getSticker();
        InputSticker other$sticker = other.getSticker();
        return !(this$sticker == null ? other$sticker != null : !((Object)this$sticker).equals(other$sticker));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AddStickerToSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        InputSticker $sticker = this.getSticker();
        result = result * 59 + ($sticker == null ? 43 : ((Object)$sticker).hashCode());
        return result;
    }

    @NonNull
    public Long getUserId() {
        return this.userId;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public InputSticker getSticker() {
        return this.sticker;
    }

    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setSticker(@NonNull InputSticker sticker) {
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.sticker = sticker;
    }

    public String toString() {
        return "AddStickerToSet(userId=" + this.getUserId() + ", name=" + this.getName() + ", sticker=" + this.getSticker() + ")";
    }

    public AddStickerToSet() {
    }

    public AddStickerToSet(@NonNull Long userId, @NonNull String name, @NonNull InputSticker sticker) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (sticker == null) {
            throw new NullPointerException("sticker is marked non-null but is null");
        }
        this.userId = userId;
        this.name = name;
        this.sticker = sticker;
    }

    public static class AddStickerToSetBuilder {
        private Long userId;
        private String name;
        private InputSticker sticker;

        AddStickerToSetBuilder() {
        }

        public AddStickerToSetBuilder userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        public AddStickerToSetBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public AddStickerToSetBuilder sticker(@NonNull InputSticker sticker) {
            if (sticker == null) {
                throw new NullPointerException("sticker is marked non-null but is null");
            }
            this.sticker = sticker;
            return this;
        }

        public AddStickerToSet build() {
            return new AddStickerToSet(this.userId, this.name, this.sticker);
        }

        public String toString() {
            return "AddStickerToSet.AddStickerToSetBuilder(userId=" + this.userId + ", name=" + this.name + ", sticker=" + this.sticker + ")";
        }
    }
}

