/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.methods.stickers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.methods.PartialBotApiMethod;
import org.telegram.telegrambots.meta.api.objects.stickers.InputSticker;
import org.telegram.telegrambots.meta.exceptions.TelegramApiRequestException;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class CreateNewStickerSet
extends PartialBotApiMethod<Boolean> {
    public static final String PATH = "createNewStickerSet";
    public static final String USER_ID_FIELD = "user_id";
    public static final String STICKERS_FIELD = "stickers";
    public static final String NAME_FIELD = "name";
    public static final String TITLE_FIELD = "title";
    public static final String STICKER_FORMAT_FIELD = "sticker_format";
    public static final String STICKER_TYPE_FIELD = "sticker_type";
    public static final String NEEDS_REPAINTING_FIELD = "needs_repainting";
    @NonNull
    private Long userId;
    @NonNull
    private String name;
    @NonNull
    private String title;
    @NonNull
    private List<InputSticker> stickers;
    @NonNull
    private String stickerFormat;
    private Boolean needsRepainting;
    private String stickerType;

    @Override
    public String getMethod() {
        return PATH;
    }

    @Override
    public Boolean deserializeResponse(String answer) throws TelegramApiRequestException {
        return this.deserializeResponse(answer, Boolean.class);
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.userId <= 0L) {
            throw new TelegramApiValidationException("userId can't be empty", this);
        }
        if (this.name.isEmpty() || this.name.length() > 64) {
            throw new TelegramApiValidationException("name must be between 1 and 64 characters", this);
        }
        if (this.title.isEmpty() || this.title.length() > 64) {
            throw new TelegramApiValidationException("title must be between 1 and 64 characters", this);
        }
        if (!Arrays.asList("regular", "mask", "custom_emoji").contains(this.stickerType)) {
            throw new TelegramApiValidationException("Stickertype must be 'regular', 'mask' or 'custom_emoji'", this);
        }
        if (!Arrays.asList("static", "animated", "video").contains(this.stickerFormat)) {
            throw new TelegramApiValidationException("StickerFormat must be 'static', 'animated', 'video'", this);
        }
        if (this.needsRepainting != null && !"custom_emoji".equals(this.stickerType)) {
            throw new TelegramApiValidationException("needsRepainting is only allowed with custom emojis", this);
        }
        if (this.stickers.isEmpty()) {
            throw new TelegramApiValidationException("sticker can't be empty", this);
        }
        for (InputSticker sticker : this.stickers) {
            sticker.validate();
        }
    }

    private static String $default$stickerType() {
        return "regular";
    }

    public static CreateNewStickerSetBuilder builder() {
        return new CreateNewStickerSetBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateNewStickerSet)) {
            return false;
        }
        CreateNewStickerSet other = (CreateNewStickerSet)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$userId = this.getUserId();
        Long other$userId = other.getUserId();
        if (this$userId == null ? other$userId != null : !((Object)this$userId).equals(other$userId)) {
            return false;
        }
        Boolean this$needsRepainting = this.getNeedsRepainting();
        Boolean other$needsRepainting = other.getNeedsRepainting();
        if (this$needsRepainting == null ? other$needsRepainting != null : !((Object)this$needsRepainting).equals(other$needsRepainting)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        List<InputSticker> this$stickers = this.getStickers();
        List<InputSticker> other$stickers = other.getStickers();
        if (this$stickers == null ? other$stickers != null : !((Object)this$stickers).equals(other$stickers)) {
            return false;
        }
        String this$stickerFormat = this.getStickerFormat();
        String other$stickerFormat = other.getStickerFormat();
        if (this$stickerFormat == null ? other$stickerFormat != null : !this$stickerFormat.equals(other$stickerFormat)) {
            return false;
        }
        String this$stickerType = this.getStickerType();
        String other$stickerType = other.getStickerType();
        return !(this$stickerType == null ? other$stickerType != null : !this$stickerType.equals(other$stickerType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateNewStickerSet;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $userId = this.getUserId();
        result = result * 59 + ($userId == null ? 43 : ((Object)$userId).hashCode());
        Boolean $needsRepainting = this.getNeedsRepainting();
        result = result * 59 + ($needsRepainting == null ? 43 : ((Object)$needsRepainting).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        List<InputSticker> $stickers = this.getStickers();
        result = result * 59 + ($stickers == null ? 43 : ((Object)$stickers).hashCode());
        String $stickerFormat = this.getStickerFormat();
        result = result * 59 + ($stickerFormat == null ? 43 : $stickerFormat.hashCode());
        String $stickerType = this.getStickerType();
        result = result * 59 + ($stickerType == null ? 43 : $stickerType.hashCode());
        return result;
    }

    @NonNull
    public Long getUserId() {
        return this.userId;
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public List<InputSticker> getStickers() {
        return this.stickers;
    }

    @NonNull
    public String getStickerFormat() {
        return this.stickerFormat;
    }

    public Boolean getNeedsRepainting() {
        return this.needsRepainting;
    }

    public String getStickerType() {
        return this.stickerType;
    }

    public void setUserId(@NonNull Long userId) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        this.userId = userId;
    }

    public void setName(@NonNull String name) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        this.name = name;
    }

    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    public void setStickers(@NonNull List<InputSticker> stickers) {
        if (stickers == null) {
            throw new NullPointerException("stickers is marked non-null but is null");
        }
        this.stickers = stickers;
    }

    public void setStickerFormat(@NonNull String stickerFormat) {
        if (stickerFormat == null) {
            throw new NullPointerException("stickerFormat is marked non-null but is null");
        }
        this.stickerFormat = stickerFormat;
    }

    public void setNeedsRepainting(Boolean needsRepainting) {
        this.needsRepainting = needsRepainting;
    }

    public void setStickerType(String stickerType) {
        this.stickerType = stickerType;
    }

    public String toString() {
        return "CreateNewStickerSet(userId=" + this.getUserId() + ", name=" + this.getName() + ", title=" + this.getTitle() + ", stickers=" + this.getStickers() + ", stickerFormat=" + this.getStickerFormat() + ", needsRepainting=" + this.getNeedsRepainting() + ", stickerType=" + this.getStickerType() + ")";
    }

    public CreateNewStickerSet(@NonNull Long userId, @NonNull String name, @NonNull String title, @NonNull List<InputSticker> stickers, @NonNull String stickerFormat) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (stickers == null) {
            throw new NullPointerException("stickers is marked non-null but is null");
        }
        if (stickerFormat == null) {
            throw new NullPointerException("stickerFormat is marked non-null but is null");
        }
        this.userId = userId;
        this.name = name;
        this.title = title;
        this.stickers = stickers;
        this.stickerFormat = stickerFormat;
        this.stickerType = CreateNewStickerSet.$default$stickerType();
    }

    public CreateNewStickerSet() {
        this.stickerType = CreateNewStickerSet.$default$stickerType();
    }

    public CreateNewStickerSet(@NonNull Long userId, @NonNull String name, @NonNull String title, @NonNull List<InputSticker> stickers, @NonNull String stickerFormat, Boolean needsRepainting, String stickerType) {
        if (userId == null) {
            throw new NullPointerException("userId is marked non-null but is null");
        }
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (stickers == null) {
            throw new NullPointerException("stickers is marked non-null but is null");
        }
        if (stickerFormat == null) {
            throw new NullPointerException("stickerFormat is marked non-null but is null");
        }
        this.userId = userId;
        this.name = name;
        this.title = title;
        this.stickers = stickers;
        this.stickerFormat = stickerFormat;
        this.needsRepainting = needsRepainting;
        this.stickerType = stickerType;
    }

    public static class CreateNewStickerSetBuilder {
        private Long userId;
        private String name;
        private String title;
        private ArrayList<InputSticker> stickers;
        private String stickerFormat;
        private Boolean needsRepainting;
        private boolean stickerType$set;
        private String stickerType$value;

        CreateNewStickerSetBuilder() {
        }

        public CreateNewStickerSetBuilder userId(@NonNull Long userId) {
            if (userId == null) {
                throw new NullPointerException("userId is marked non-null but is null");
            }
            this.userId = userId;
            return this;
        }

        public CreateNewStickerSetBuilder name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public CreateNewStickerSetBuilder title(@NonNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return this;
        }

        public CreateNewStickerSetBuilder sticker(InputSticker sticker) {
            if (this.stickers == null) {
                this.stickers = new ArrayList();
            }
            this.stickers.add(sticker);
            return this;
        }

        public CreateNewStickerSetBuilder stickers(Collection<? extends InputSticker> stickers) {
            if (stickers == null) {
                throw new NullPointerException("stickers cannot be null");
            }
            if (this.stickers == null) {
                this.stickers = new ArrayList();
            }
            this.stickers.addAll(stickers);
            return this;
        }

        public CreateNewStickerSetBuilder clearStickers() {
            if (this.stickers != null) {
                this.stickers.clear();
            }
            return this;
        }

        public CreateNewStickerSetBuilder stickerFormat(@NonNull String stickerFormat) {
            if (stickerFormat == null) {
                throw new NullPointerException("stickerFormat is marked non-null but is null");
            }
            this.stickerFormat = stickerFormat;
            return this;
        }

        public CreateNewStickerSetBuilder needsRepainting(Boolean needsRepainting) {
            this.needsRepainting = needsRepainting;
            return this;
        }

        public CreateNewStickerSetBuilder stickerType(String stickerType) {
            this.stickerType$value = stickerType;
            this.stickerType$set = true;
            return this;
        }

        public CreateNewStickerSet build() {
            List<InputSticker> stickers = switch (this.stickers == null ? 0 : this.stickers.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.stickers.get(0));
                default -> Collections.unmodifiableList(new ArrayList<InputSticker>(this.stickers));
            };
            String stickerType$value = this.stickerType$value;
            if (!this.stickerType$set) {
                stickerType$value = CreateNewStickerSet.$default$stickerType();
            }
            return new CreateNewStickerSet(this.userId, this.name, this.title, stickers, this.stickerFormat, this.needsRepainting, stickerType$value);
        }

        public String toString() {
            return "CreateNewStickerSet.CreateNewStickerSetBuilder(userId=" + this.userId + ", name=" + this.name + ", title=" + this.title + ", stickers=" + this.stickers + ", stickerFormat=" + this.stickerFormat + ", needsRepainting=" + this.needsRepainting + ", stickerType$value=" + this.stickerType$value + ")";
        }
    }
}

