/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.interfaces.BotApiObject;
import org.telegram.telegrambots.meta.api.interfaces.Validable;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

public class ReplyParameters
implements BotApiObject,
Validable {
    private static final String MESSAGE_ID_FIELD = "message_id";
    private static final String CHAT_ID_FIELD = "chat_id";
    private static final String ALLOW_SENDING_WITHOUT_REPLY_FIELD = "allow_sending_without_reply";
    private static final String QUOTE_PARSE_MODE_FIELD = "quote_parse_mode";
    private static final String QUOTE_FIELD = "quote";
    private static final String QUOTE_ENTITIES_FIELD = "quote_entities";
    private static final String QUOTE_POSITION_FIELD = "quote_position";
    @JsonProperty(value="message_id")
    @NonNull
    private Integer messageId;
    @JsonProperty(value="chat_id")
    private String chatId;
    @JsonProperty(value="allow_sending_without_reply")
    private Boolean allowSendingWithoutReply;
    @JsonProperty(value="quote")
    private String quote;
    @JsonProperty(value="quote_parse_mode")
    private String quoteParseMode;
    @JsonProperty(value="quote_entities")
    private List<MessageEntity> quoteEntities;
    @JsonProperty(value="quote_position")
    private Integer quotePosition;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.chatId != null && this.chatId.isEmpty()) {
            throw new TelegramApiValidationException("ChatId parameter can't be empty string", this);
        }
    }

    public static ReplyParametersBuilder builder() {
        return new ReplyParametersBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReplyParameters)) {
            return false;
        }
        ReplyParameters other = (ReplyParameters)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$messageId = this.getMessageId();
        Integer other$messageId = other.getMessageId();
        if (this$messageId == null ? other$messageId != null : !((Object)this$messageId).equals(other$messageId)) {
            return false;
        }
        Boolean this$allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        Boolean other$allowSendingWithoutReply = other.getAllowSendingWithoutReply();
        if (this$allowSendingWithoutReply == null ? other$allowSendingWithoutReply != null : !((Object)this$allowSendingWithoutReply).equals(other$allowSendingWithoutReply)) {
            return false;
        }
        Integer this$quotePosition = this.getQuotePosition();
        Integer other$quotePosition = other.getQuotePosition();
        if (this$quotePosition == null ? other$quotePosition != null : !((Object)this$quotePosition).equals(other$quotePosition)) {
            return false;
        }
        String this$chatId = this.getChatId();
        String other$chatId = other.getChatId();
        if (this$chatId == null ? other$chatId != null : !this$chatId.equals(other$chatId)) {
            return false;
        }
        String this$quote = this.getQuote();
        String other$quote = other.getQuote();
        if (this$quote == null ? other$quote != null : !this$quote.equals(other$quote)) {
            return false;
        }
        String this$quoteParseMode = this.getQuoteParseMode();
        String other$quoteParseMode = other.getQuoteParseMode();
        if (this$quoteParseMode == null ? other$quoteParseMode != null : !this$quoteParseMode.equals(other$quoteParseMode)) {
            return false;
        }
        List<MessageEntity> this$quoteEntities = this.getQuoteEntities();
        List<MessageEntity> other$quoteEntities = other.getQuoteEntities();
        return !(this$quoteEntities == null ? other$quoteEntities != null : !((Object)this$quoteEntities).equals(other$quoteEntities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ReplyParameters;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $messageId = this.getMessageId();
        result = result * 59 + ($messageId == null ? 43 : ((Object)$messageId).hashCode());
        Boolean $allowSendingWithoutReply = this.getAllowSendingWithoutReply();
        result = result * 59 + ($allowSendingWithoutReply == null ? 43 : ((Object)$allowSendingWithoutReply).hashCode());
        Integer $quotePosition = this.getQuotePosition();
        result = result * 59 + ($quotePosition == null ? 43 : ((Object)$quotePosition).hashCode());
        String $chatId = this.getChatId();
        result = result * 59 + ($chatId == null ? 43 : $chatId.hashCode());
        String $quote = this.getQuote();
        result = result * 59 + ($quote == null ? 43 : $quote.hashCode());
        String $quoteParseMode = this.getQuoteParseMode();
        result = result * 59 + ($quoteParseMode == null ? 43 : $quoteParseMode.hashCode());
        List<MessageEntity> $quoteEntities = this.getQuoteEntities();
        result = result * 59 + ($quoteEntities == null ? 43 : ((Object)$quoteEntities).hashCode());
        return result;
    }

    @NonNull
    public Integer getMessageId() {
        return this.messageId;
    }

    public String getChatId() {
        return this.chatId;
    }

    public Boolean getAllowSendingWithoutReply() {
        return this.allowSendingWithoutReply;
    }

    public String getQuote() {
        return this.quote;
    }

    public String getQuoteParseMode() {
        return this.quoteParseMode;
    }

    public List<MessageEntity> getQuoteEntities() {
        return this.quoteEntities;
    }

    public Integer getQuotePosition() {
        return this.quotePosition;
    }

    @JsonProperty(value="message_id")
    public void setMessageId(@NonNull Integer messageId) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.messageId = messageId;
    }

    @JsonProperty(value="chat_id")
    public void setChatId(String chatId) {
        this.chatId = chatId;
    }

    @JsonProperty(value="allow_sending_without_reply")
    public void setAllowSendingWithoutReply(Boolean allowSendingWithoutReply) {
        this.allowSendingWithoutReply = allowSendingWithoutReply;
    }

    @JsonProperty(value="quote")
    public void setQuote(String quote) {
        this.quote = quote;
    }

    @JsonProperty(value="quote_parse_mode")
    public void setQuoteParseMode(String quoteParseMode) {
        this.quoteParseMode = quoteParseMode;
    }

    @JsonProperty(value="quote_entities")
    public void setQuoteEntities(List<MessageEntity> quoteEntities) {
        this.quoteEntities = quoteEntities;
    }

    @JsonProperty(value="quote_position")
    public void setQuotePosition(Integer quotePosition) {
        this.quotePosition = quotePosition;
    }

    public String toString() {
        return "ReplyParameters(messageId=" + this.getMessageId() + ", chatId=" + this.getChatId() + ", allowSendingWithoutReply=" + this.getAllowSendingWithoutReply() + ", quote=" + this.getQuote() + ", quoteParseMode=" + this.getQuoteParseMode() + ", quoteEntities=" + this.getQuoteEntities() + ", quotePosition=" + this.getQuotePosition() + ")";
    }

    public ReplyParameters() {
    }

    public ReplyParameters(@NonNull Integer messageId) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.messageId = messageId;
    }

    public ReplyParameters(@NonNull Integer messageId, String chatId, Boolean allowSendingWithoutReply, String quote, String quoteParseMode, List<MessageEntity> quoteEntities, Integer quotePosition) {
        if (messageId == null) {
            throw new NullPointerException("messageId is marked non-null but is null");
        }
        this.messageId = messageId;
        this.chatId = chatId;
        this.allowSendingWithoutReply = allowSendingWithoutReply;
        this.quote = quote;
        this.quoteParseMode = quoteParseMode;
        this.quoteEntities = quoteEntities;
        this.quotePosition = quotePosition;
    }

    public static class ReplyParametersBuilder {
        private Integer messageId;
        private String chatId;
        private Boolean allowSendingWithoutReply;
        private String quote;
        private String quoteParseMode;
        private ArrayList<MessageEntity> quoteEntities;
        private Integer quotePosition;

        public ReplyParametersBuilder chatId(@NonNull Long chatId) {
            if (chatId == null) {
                throw new NullPointerException("chatId is marked non-null but is null");
            }
            this.chatId = chatId.toString();
            return this;
        }

        ReplyParametersBuilder() {
        }

        @JsonProperty(value="message_id")
        public ReplyParametersBuilder messageId(@NonNull Integer messageId) {
            if (messageId == null) {
                throw new NullPointerException("messageId is marked non-null but is null");
            }
            this.messageId = messageId;
            return this;
        }

        @JsonProperty(value="chat_id")
        public ReplyParametersBuilder chatId(String chatId) {
            this.chatId = chatId;
            return this;
        }

        @JsonProperty(value="allow_sending_without_reply")
        public ReplyParametersBuilder allowSendingWithoutReply(Boolean allowSendingWithoutReply) {
            this.allowSendingWithoutReply = allowSendingWithoutReply;
            return this;
        }

        @JsonProperty(value="quote")
        public ReplyParametersBuilder quote(String quote) {
            this.quote = quote;
            return this;
        }

        @JsonProperty(value="quote_parse_mode")
        public ReplyParametersBuilder quoteParseMode(String quoteParseMode) {
            this.quoteParseMode = quoteParseMode;
            return this;
        }

        public ReplyParametersBuilder quoteEntity(MessageEntity quoteEntity) {
            if (this.quoteEntities == null) {
                this.quoteEntities = new ArrayList();
            }
            this.quoteEntities.add(quoteEntity);
            return this;
        }

        @JsonProperty(value="quote_entities")
        public ReplyParametersBuilder quoteEntities(Collection<? extends MessageEntity> quoteEntities) {
            if (quoteEntities == null) {
                throw new NullPointerException("quoteEntities cannot be null");
            }
            if (this.quoteEntities == null) {
                this.quoteEntities = new ArrayList();
            }
            this.quoteEntities.addAll(quoteEntities);
            return this;
        }

        public ReplyParametersBuilder clearQuoteEntities() {
            if (this.quoteEntities != null) {
                this.quoteEntities.clear();
            }
            return this;
        }

        @JsonProperty(value="quote_position")
        public ReplyParametersBuilder quotePosition(Integer quotePosition) {
            this.quotePosition = quotePosition;
            return this;
        }

        public ReplyParameters build() {
            return new ReplyParameters(this.messageId, this.chatId, this.allowSendingWithoutReply, this.quote, this.quoteParseMode, switch (this.quoteEntities == null ? 0 : this.quoteEntities.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.quoteEntities.get(0));
                default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(this.quoteEntities));
            }, this.quotePosition);
        }

        public String toString() {
            return "ReplyParameters.ReplyParametersBuilder(messageId=" + this.messageId + ", chatId=" + this.chatId + ", allowSendingWithoutReply=" + this.allowSendingWithoutReply + ", quote=" + this.quote + ", quoteParseMode=" + this.quoteParseMode + ", quoteEntities=" + this.quoteEntities + ", quotePosition=" + this.quotePosition + ")";
        }
    }
}

