/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InlineQueryResultDocument
implements InlineQueryResult {
    private static final String TYPE_FIELD = "type";
    private static final String ID_FIELD = "id";
    private static final String TITLE_FIELD = "title";
    private static final String DOCUMENTURL_FIELD = "document_url";
    private static final String MIMETYPE_FIELD = "mime_type";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String CAPTION_FIELD = "caption";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String INPUTMESSAGECONTENT_FIELD = "input_message_content";
    private static final String THUMBNAIL_URL_FIELD = "thumbnail_url";
    private static final String THUMBNAIL_WIDTH_FIELD = "thumbnail_width";
    private static final String THUMBNAUK_HEIGHT_FIELD = "thumbnail_height";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    @JsonProperty(value="type")
    private final String type = "document";
    @JsonProperty(value="id")
    @NonNull
    private String id;
    @JsonProperty(value="title")
    @NonNull
    private String title;
    @JsonProperty(value="document_url")
    @NonNull
    private String documentUrl;
    @JsonProperty(value="mime_type")
    @NonNull
    private String mimeType;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContent;
    @JsonProperty(value="thumbnail_url")
    private String thumbnailUrl;
    @JsonProperty(value="thumbnail_width")
    private Integer thumbnailWidth;
    @JsonProperty(value="thumbnail_height")
    private Integer thumbnailHeight;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id.isEmpty()) {
            throw new TelegramApiValidationException("ID parameter can't be empty", this);
        }
        if (this.mimeType.isEmpty()) {
            throw new TelegramApiValidationException("Mimetype parameter can't be empty", this);
        }
        if (this.documentUrl.isEmpty()) {
            throw new TelegramApiValidationException("DocumentUrl parameter can't be empty", this);
        }
        if (this.title.isEmpty()) {
            throw new TelegramApiValidationException("Title parameter can't be empty", this);
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.thumbnailUrl != null && !"image/jpeg".equalsIgnoreCase(this.thumbnailUrl)) {
            throw new TelegramApiValidationException("Thumbnail Url must be JPEG", this);
        }
        if (this.inputMessageContent != null) {
            this.inputMessageContent.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public static InlineQueryResultDocumentBuilder builder() {
        return new InlineQueryResultDocumentBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineQueryResultDocument)) {
            return false;
        }
        InlineQueryResultDocument other = (InlineQueryResultDocument)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$thumbnailWidth = this.getThumbnailWidth();
        Integer other$thumbnailWidth = other.getThumbnailWidth();
        if (this$thumbnailWidth == null ? other$thumbnailWidth != null : !((Object)this$thumbnailWidth).equals(other$thumbnailWidth)) {
            return false;
        }
        Integer this$thumbnailHeight = this.getThumbnailHeight();
        Integer other$thumbnailHeight = other.getThumbnailHeight();
        if (this$thumbnailHeight == null ? other$thumbnailHeight != null : !((Object)this$thumbnailHeight).equals(other$thumbnailHeight)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$documentUrl = this.getDocumentUrl();
        String other$documentUrl = other.getDocumentUrl();
        if (this$documentUrl == null ? other$documentUrl != null : !this$documentUrl.equals(other$documentUrl)) {
            return false;
        }
        String this$mimeType = this.getMimeType();
        String other$mimeType = other.getMimeType();
        if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        InputMessageContent this$inputMessageContent = this.getInputMessageContent();
        InputMessageContent other$inputMessageContent = other.getInputMessageContent();
        if (this$inputMessageContent == null ? other$inputMessageContent != null : !this$inputMessageContent.equals(other$inputMessageContent)) {
            return false;
        }
        String this$thumbnailUrl = this.getThumbnailUrl();
        String other$thumbnailUrl = other.getThumbnailUrl();
        if (this$thumbnailUrl == null ? other$thumbnailUrl != null : !this$thumbnailUrl.equals(other$thumbnailUrl)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        return !(this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineQueryResultDocument;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $thumbnailWidth = this.getThumbnailWidth();
        result = result * 59 + ($thumbnailWidth == null ? 43 : ((Object)$thumbnailWidth).hashCode());
        Integer $thumbnailHeight = this.getThumbnailHeight();
        result = result * 59 + ($thumbnailHeight == null ? 43 : ((Object)$thumbnailHeight).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $documentUrl = this.getDocumentUrl();
        result = result * 59 + ($documentUrl == null ? 43 : $documentUrl.hashCode());
        String $mimeType = this.getMimeType();
        result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        InputMessageContent $inputMessageContent = this.getInputMessageContent();
        result = result * 59 + ($inputMessageContent == null ? 43 : $inputMessageContent.hashCode());
        String $thumbnailUrl = this.getThumbnailUrl();
        result = result * 59 + ($thumbnailUrl == null ? 43 : $thumbnailUrl.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        return result;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public String getDocumentUrl() {
        return this.documentUrl;
    }

    @NonNull
    public String getMimeType() {
        return this.mimeType;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCaption() {
        return this.caption;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public InputMessageContent getInputMessageContent() {
        return this.inputMessageContent;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public Integer getThumbnailWidth() {
        return this.thumbnailWidth;
    }

    public Integer getThumbnailHeight() {
        return this.thumbnailHeight;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @JsonProperty(value="id")
    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="title")
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @JsonProperty(value="document_url")
    public void setDocumentUrl(@NonNull String documentUrl) {
        if (documentUrl == null) {
            throw new NullPointerException("documentUrl is marked non-null but is null");
        }
        this.documentUrl = documentUrl;
    }

    @JsonProperty(value="mime_type")
    public void setMimeType(@NonNull String mimeType) {
        if (mimeType == null) {
            throw new NullPointerException("mimeType is marked non-null but is null");
        }
        this.mimeType = mimeType;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="caption")
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="input_message_content")
    public void setInputMessageContent(InputMessageContent inputMessageContent) {
        this.inputMessageContent = inputMessageContent;
    }

    @JsonProperty(value="thumbnail_url")
    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    @JsonProperty(value="thumbnail_width")
    public void setThumbnailWidth(Integer thumbnailWidth) {
        this.thumbnailWidth = thumbnailWidth;
    }

    @JsonProperty(value="thumbnail_height")
    public void setThumbnailHeight(Integer thumbnailHeight) {
        this.thumbnailHeight = thumbnailHeight;
    }

    @JsonProperty(value="parse_mode")
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="caption_entities")
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    public String toString() {
        return "InlineQueryResultDocument(type=" + this.getType() + ", id=" + this.getId() + ", title=" + this.getTitle() + ", documentUrl=" + this.getDocumentUrl() + ", mimeType=" + this.getMimeType() + ", description=" + this.getDescription() + ", caption=" + this.getCaption() + ", replyMarkup=" + this.getReplyMarkup() + ", inputMessageContent=" + this.getInputMessageContent() + ", thumbnailUrl=" + this.getThumbnailUrl() + ", thumbnailWidth=" + this.getThumbnailWidth() + ", thumbnailHeight=" + this.getThumbnailHeight() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ")";
    }

    public InlineQueryResultDocument(@NonNull String id, @NonNull String title, @NonNull String documentUrl, @NonNull String mimeType) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (documentUrl == null) {
            throw new NullPointerException("documentUrl is marked non-null but is null");
        }
        if (mimeType == null) {
            throw new NullPointerException("mimeType is marked non-null but is null");
        }
        this.id = id;
        this.title = title;
        this.documentUrl = documentUrl;
        this.mimeType = mimeType;
    }

    public InlineQueryResultDocument() {
    }

    public InlineQueryResultDocument(@NonNull String id, @NonNull String title, @NonNull String documentUrl, @NonNull String mimeType, String description, String caption, InlineKeyboardMarkup replyMarkup, InputMessageContent inputMessageContent, String thumbnailUrl, Integer thumbnailWidth, Integer thumbnailHeight, String parseMode, List<MessageEntity> captionEntities) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (documentUrl == null) {
            throw new NullPointerException("documentUrl is marked non-null but is null");
        }
        if (mimeType == null) {
            throw new NullPointerException("mimeType is marked non-null but is null");
        }
        this.id = id;
        this.title = title;
        this.documentUrl = documentUrl;
        this.mimeType = mimeType;
        this.description = description;
        this.caption = caption;
        this.replyMarkup = replyMarkup;
        this.inputMessageContent = inputMessageContent;
        this.thumbnailUrl = thumbnailUrl;
        this.thumbnailWidth = thumbnailWidth;
        this.thumbnailHeight = thumbnailHeight;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
    }

    public static class InlineQueryResultDocumentBuilder {
        private String id;
        private String title;
        private String documentUrl;
        private String mimeType;
        private String description;
        private String caption;
        private InlineKeyboardMarkup replyMarkup;
        private InputMessageContent inputMessageContent;
        private String thumbnailUrl;
        private Integer thumbnailWidth;
        private Integer thumbnailHeight;
        private String parseMode;
        private ArrayList<MessageEntity> captionEntities;

        InlineQueryResultDocumentBuilder() {
        }

        @JsonProperty(value="id")
        public InlineQueryResultDocumentBuilder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @JsonProperty(value="title")
        public InlineQueryResultDocumentBuilder title(@NonNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return this;
        }

        @JsonProperty(value="document_url")
        public InlineQueryResultDocumentBuilder documentUrl(@NonNull String documentUrl) {
            if (documentUrl == null) {
                throw new NullPointerException("documentUrl is marked non-null but is null");
            }
            this.documentUrl = documentUrl;
            return this;
        }

        @JsonProperty(value="mime_type")
        public InlineQueryResultDocumentBuilder mimeType(@NonNull String mimeType) {
            if (mimeType == null) {
                throw new NullPointerException("mimeType is marked non-null but is null");
            }
            this.mimeType = mimeType;
            return this;
        }

        @JsonProperty(value="description")
        public InlineQueryResultDocumentBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="caption")
        public InlineQueryResultDocumentBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @JsonProperty(value="reply_markup")
        public InlineQueryResultDocumentBuilder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        @JsonProperty(value="input_message_content")
        public InlineQueryResultDocumentBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.inputMessageContent = inputMessageContent;
            return this;
        }

        @JsonProperty(value="thumbnail_url")
        public InlineQueryResultDocumentBuilder thumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            return this;
        }

        @JsonProperty(value="thumbnail_width")
        public InlineQueryResultDocumentBuilder thumbnailWidth(Integer thumbnailWidth) {
            this.thumbnailWidth = thumbnailWidth;
            return this;
        }

        @JsonProperty(value="thumbnail_height")
        public InlineQueryResultDocumentBuilder thumbnailHeight(Integer thumbnailHeight) {
            this.thumbnailHeight = thumbnailHeight;
            return this;
        }

        @JsonProperty(value="parse_mode")
        public InlineQueryResultDocumentBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public InlineQueryResultDocumentBuilder captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return this;
        }

        @JsonProperty(value="caption_entities")
        public InlineQueryResultDocumentBuilder captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return this;
        }

        public InlineQueryResultDocumentBuilder clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return this;
        }

        public InlineQueryResultDocument build() {
            return new InlineQueryResultDocument(this.id, this.title, this.documentUrl, this.mimeType, this.description, this.caption, this.replyMarkup, this.inputMessageContent, this.thumbnailUrl, this.thumbnailWidth, this.thumbnailHeight, this.parseMode, switch (this.captionEntities == null ? 0 : this.captionEntities.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.captionEntities.get(0));
                default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(this.captionEntities));
            });
        }

        public String toString() {
            return "InlineQueryResultDocument.InlineQueryResultDocumentBuilder(id=" + this.id + ", title=" + this.title + ", documentUrl=" + this.documentUrl + ", mimeType=" + this.mimeType + ", description=" + this.description + ", caption=" + this.caption + ", replyMarkup=" + this.replyMarkup + ", inputMessageContent=" + this.inputMessageContent + ", thumbnailUrl=" + this.thumbnailUrl + ", thumbnailWidth=" + this.thumbnailWidth + ", thumbnailHeight=" + this.thumbnailHeight + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ")";
        }
    }
}

