/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InlineQueryResultPhoto
implements InlineQueryResult {
    private static final String TYPE_FIELD = "type";
    private static final String ID_FIELD = "id";
    private static final String PHOTOURL_FIELD = "photo_url";
    private static final String MIMETYPE_FIELD = "mime_type";
    private static final String PHOTOWIDTH_FIELD = "photo_width";
    private static final String PHOTOHEIGHT_FIELD = "photo_height";
    private static final String THUMBNAIL_URL_FIELD = "thumbnail_url";
    private static final String TITLE_FIELD = "title";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String CAPTION_FIELD = "caption";
    private static final String INPUTMESSAGECONTENT_FIELD = "input_message_content";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    @JsonProperty(value="type")
    private final String type = "photo";
    @JsonProperty(value="id")
    @NonNull
    private String id;
    @JsonProperty(value="photo_url")
    @NonNull
    private String photoUrl;
    @JsonProperty(value="mime_type")
    private String mimeType;
    @JsonProperty(value="photo_width")
    private Integer photoWidth;
    @JsonProperty(value="photo_height")
    private Integer photoHeight;
    @JsonProperty(value="thumbnail_url")
    private String thumbnailUrl;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContent;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id.isEmpty()) {
            throw new TelegramApiValidationException("ID parameter can't be empty", this);
        }
        if (this.photoUrl.isEmpty()) {
            throw new TelegramApiValidationException("PhotoUrl parameter can't be empty", this);
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.inputMessageContent != null) {
            this.inputMessageContent.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public static InlineQueryResultPhotoBuilder builder() {
        return new InlineQueryResultPhotoBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineQueryResultPhoto)) {
            return false;
        }
        InlineQueryResultPhoto other = (InlineQueryResultPhoto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$photoWidth = this.getPhotoWidth();
        Integer other$photoWidth = other.getPhotoWidth();
        if (this$photoWidth == null ? other$photoWidth != null : !((Object)this$photoWidth).equals(other$photoWidth)) {
            return false;
        }
        Integer this$photoHeight = this.getPhotoHeight();
        Integer other$photoHeight = other.getPhotoHeight();
        if (this$photoHeight == null ? other$photoHeight != null : !((Object)this$photoHeight).equals(other$photoHeight)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$photoUrl = this.getPhotoUrl();
        String other$photoUrl = other.getPhotoUrl();
        if (this$photoUrl == null ? other$photoUrl != null : !this$photoUrl.equals(other$photoUrl)) {
            return false;
        }
        String this$mimeType = this.getMimeType();
        String other$mimeType = other.getMimeType();
        if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
            return false;
        }
        String this$thumbnailUrl = this.getThumbnailUrl();
        String other$thumbnailUrl = other.getThumbnailUrl();
        if (this$thumbnailUrl == null ? other$thumbnailUrl != null : !this$thumbnailUrl.equals(other$thumbnailUrl)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        InputMessageContent this$inputMessageContent = this.getInputMessageContent();
        InputMessageContent other$inputMessageContent = other.getInputMessageContent();
        if (this$inputMessageContent == null ? other$inputMessageContent != null : !this$inputMessageContent.equals(other$inputMessageContent)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        return !(this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineQueryResultPhoto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $photoWidth = this.getPhotoWidth();
        result = result * 59 + ($photoWidth == null ? 43 : ((Object)$photoWidth).hashCode());
        Integer $photoHeight = this.getPhotoHeight();
        result = result * 59 + ($photoHeight == null ? 43 : ((Object)$photoHeight).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $photoUrl = this.getPhotoUrl();
        result = result * 59 + ($photoUrl == null ? 43 : $photoUrl.hashCode());
        String $mimeType = this.getMimeType();
        result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
        String $thumbnailUrl = this.getThumbnailUrl();
        result = result * 59 + ($thumbnailUrl == null ? 43 : $thumbnailUrl.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        InputMessageContent $inputMessageContent = this.getInputMessageContent();
        result = result * 59 + ($inputMessageContent == null ? 43 : $inputMessageContent.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        return result;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getPhotoUrl() {
        return this.photoUrl;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public Integer getPhotoWidth() {
        return this.photoWidth;
    }

    public Integer getPhotoHeight() {
        return this.photoHeight;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCaption() {
        return this.caption;
    }

    public InputMessageContent getInputMessageContent() {
        return this.inputMessageContent;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @JsonProperty(value="id")
    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="photo_url")
    public void setPhotoUrl(@NonNull String photoUrl) {
        if (photoUrl == null) {
            throw new NullPointerException("photoUrl is marked non-null but is null");
        }
        this.photoUrl = photoUrl;
    }

    @JsonProperty(value="mime_type")
    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    @JsonProperty(value="photo_width")
    public void setPhotoWidth(Integer photoWidth) {
        this.photoWidth = photoWidth;
    }

    @JsonProperty(value="photo_height")
    public void setPhotoHeight(Integer photoHeight) {
        this.photoHeight = photoHeight;
    }

    @JsonProperty(value="thumbnail_url")
    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="caption")
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="input_message_content")
    public void setInputMessageContent(InputMessageContent inputMessageContent) {
        this.inputMessageContent = inputMessageContent;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="parse_mode")
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="caption_entities")
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    public String toString() {
        return "InlineQueryResultPhoto(type=" + this.getType() + ", id=" + this.getId() + ", photoUrl=" + this.getPhotoUrl() + ", mimeType=" + this.getMimeType() + ", photoWidth=" + this.getPhotoWidth() + ", photoHeight=" + this.getPhotoHeight() + ", thumbnailUrl=" + this.getThumbnailUrl() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", caption=" + this.getCaption() + ", inputMessageContent=" + this.getInputMessageContent() + ", replyMarkup=" + this.getReplyMarkup() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ")";
    }

    public InlineQueryResultPhoto(@NonNull String id, @NonNull String photoUrl) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (photoUrl == null) {
            throw new NullPointerException("photoUrl is marked non-null but is null");
        }
        this.id = id;
        this.photoUrl = photoUrl;
    }

    public InlineQueryResultPhoto() {
    }

    public InlineQueryResultPhoto(@NonNull String id, @NonNull String photoUrl, String mimeType, Integer photoWidth, Integer photoHeight, String thumbnailUrl, String title, String description, String caption, InputMessageContent inputMessageContent, InlineKeyboardMarkup replyMarkup, String parseMode, List<MessageEntity> captionEntities) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (photoUrl == null) {
            throw new NullPointerException("photoUrl is marked non-null but is null");
        }
        this.id = id;
        this.photoUrl = photoUrl;
        this.mimeType = mimeType;
        this.photoWidth = photoWidth;
        this.photoHeight = photoHeight;
        this.thumbnailUrl = thumbnailUrl;
        this.title = title;
        this.description = description;
        this.caption = caption;
        this.inputMessageContent = inputMessageContent;
        this.replyMarkup = replyMarkup;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
    }

    public static class InlineQueryResultPhotoBuilder {
        private String id;
        private String photoUrl;
        private String mimeType;
        private Integer photoWidth;
        private Integer photoHeight;
        private String thumbnailUrl;
        private String title;
        private String description;
        private String caption;
        private InputMessageContent inputMessageContent;
        private InlineKeyboardMarkup replyMarkup;
        private String parseMode;
        private ArrayList<MessageEntity> captionEntities;

        InlineQueryResultPhotoBuilder() {
        }

        @JsonProperty(value="id")
        public InlineQueryResultPhotoBuilder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @JsonProperty(value="photo_url")
        public InlineQueryResultPhotoBuilder photoUrl(@NonNull String photoUrl) {
            if (photoUrl == null) {
                throw new NullPointerException("photoUrl is marked non-null but is null");
            }
            this.photoUrl = photoUrl;
            return this;
        }

        @JsonProperty(value="mime_type")
        public InlineQueryResultPhotoBuilder mimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        @JsonProperty(value="photo_width")
        public InlineQueryResultPhotoBuilder photoWidth(Integer photoWidth) {
            this.photoWidth = photoWidth;
            return this;
        }

        @JsonProperty(value="photo_height")
        public InlineQueryResultPhotoBuilder photoHeight(Integer photoHeight) {
            this.photoHeight = photoHeight;
            return this;
        }

        @JsonProperty(value="thumbnail_url")
        public InlineQueryResultPhotoBuilder thumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            return this;
        }

        @JsonProperty(value="title")
        public InlineQueryResultPhotoBuilder title(String title) {
            this.title = title;
            return this;
        }

        @JsonProperty(value="description")
        public InlineQueryResultPhotoBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="caption")
        public InlineQueryResultPhotoBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @JsonProperty(value="input_message_content")
        public InlineQueryResultPhotoBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.inputMessageContent = inputMessageContent;
            return this;
        }

        @JsonProperty(value="reply_markup")
        public InlineQueryResultPhotoBuilder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        @JsonProperty(value="parse_mode")
        public InlineQueryResultPhotoBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public InlineQueryResultPhotoBuilder captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return this;
        }

        @JsonProperty(value="caption_entities")
        public InlineQueryResultPhotoBuilder captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return this;
        }

        public InlineQueryResultPhotoBuilder clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return this;
        }

        public InlineQueryResultPhoto build() {
            return new InlineQueryResultPhoto(this.id, this.photoUrl, this.mimeType, this.photoWidth, this.photoHeight, this.thumbnailUrl, this.title, this.description, this.caption, this.inputMessageContent, this.replyMarkup, this.parseMode, switch (this.captionEntities == null ? 0 : this.captionEntities.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.captionEntities.get(0));
                default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(this.captionEntities));
            });
        }

        public String toString() {
            return "InlineQueryResultPhoto.InlineQueryResultPhotoBuilder(id=" + this.id + ", photoUrl=" + this.photoUrl + ", mimeType=" + this.mimeType + ", photoWidth=" + this.photoWidth + ", photoHeight=" + this.photoHeight + ", thumbnailUrl=" + this.thumbnailUrl + ", title=" + this.title + ", description=" + this.description + ", caption=" + this.caption + ", inputMessageContent=" + this.inputMessageContent + ", replyMarkup=" + this.replyMarkup + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ")";
        }
    }
}

