/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InlineQueryResultVideo
implements InlineQueryResult {
    private static final String TYPE_FIELD = "type";
    private static final String ID_FIELD = "id";
    private static final String MIMETYPE_FIELD = "mime_type";
    private static final String VIDEOURL_FIELD = "video_url";
    private static final String VIDEOWIDTH_FIELD = "video_width";
    private static final String VIDEOHEIGHT_FIELD = "video_height";
    private static final String VIDEODURATION_FIELD = "video_duration";
    private static final String THUMBNAILURL_FIELD = "thumbnail_url";
    private static final String TITLE_FIELD = "title";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String CAPTION_FIELD = "caption";
    private static final String INPUTMESSAGECONTENT_FIELD = "input_message_content";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    @JsonProperty(value="type")
    private final String type = "video";
    @JsonProperty(value="id")
    @NonNull
    private String id;
    @JsonProperty(value="mime_type")
    @NonNull
    private String mimeType;
    @JsonProperty(value="video_url")
    @NonNull
    private String videoUrl;
    @JsonProperty(value="video_width")
    private Integer videoWidth;
    @JsonProperty(value="video_height")
    private Integer videoHeight;
    @JsonProperty(value="video_duration")
    private Integer videoDuration;
    @JsonProperty(value="thumbnail_url")
    private String thumbnailUrl;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContent;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id.isEmpty()) {
            throw new TelegramApiValidationException("ID parameter can't be empty", this);
        }
        if (this.videoUrl.isEmpty()) {
            throw new TelegramApiValidationException("VideoUrl parameter can't be empty", this);
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.thumbnailUrl != null && !"image/jpeg".equalsIgnoreCase(this.thumbnailUrl)) {
            throw new TelegramApiValidationException("Thumbnail Url must be JPEG", this);
        }
        if (this.inputMessageContent != null) {
            this.inputMessageContent.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public static InlineQueryResultVideoBuilder builder() {
        return new InlineQueryResultVideoBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineQueryResultVideo)) {
            return false;
        }
        InlineQueryResultVideo other = (InlineQueryResultVideo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$videoWidth = this.getVideoWidth();
        Integer other$videoWidth = other.getVideoWidth();
        if (this$videoWidth == null ? other$videoWidth != null : !((Object)this$videoWidth).equals(other$videoWidth)) {
            return false;
        }
        Integer this$videoHeight = this.getVideoHeight();
        Integer other$videoHeight = other.getVideoHeight();
        if (this$videoHeight == null ? other$videoHeight != null : !((Object)this$videoHeight).equals(other$videoHeight)) {
            return false;
        }
        Integer this$videoDuration = this.getVideoDuration();
        Integer other$videoDuration = other.getVideoDuration();
        if (this$videoDuration == null ? other$videoDuration != null : !((Object)this$videoDuration).equals(other$videoDuration)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$mimeType = this.getMimeType();
        String other$mimeType = other.getMimeType();
        if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
            return false;
        }
        String this$videoUrl = this.getVideoUrl();
        String other$videoUrl = other.getVideoUrl();
        if (this$videoUrl == null ? other$videoUrl != null : !this$videoUrl.equals(other$videoUrl)) {
            return false;
        }
        String this$thumbnailUrl = this.getThumbnailUrl();
        String other$thumbnailUrl = other.getThumbnailUrl();
        if (this$thumbnailUrl == null ? other$thumbnailUrl != null : !this$thumbnailUrl.equals(other$thumbnailUrl)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        InputMessageContent this$inputMessageContent = this.getInputMessageContent();
        InputMessageContent other$inputMessageContent = other.getInputMessageContent();
        if (this$inputMessageContent == null ? other$inputMessageContent != null : !this$inputMessageContent.equals(other$inputMessageContent)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        return !(this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineQueryResultVideo;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $videoWidth = this.getVideoWidth();
        result = result * 59 + ($videoWidth == null ? 43 : ((Object)$videoWidth).hashCode());
        Integer $videoHeight = this.getVideoHeight();
        result = result * 59 + ($videoHeight == null ? 43 : ((Object)$videoHeight).hashCode());
        Integer $videoDuration = this.getVideoDuration();
        result = result * 59 + ($videoDuration == null ? 43 : ((Object)$videoDuration).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $mimeType = this.getMimeType();
        result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
        String $videoUrl = this.getVideoUrl();
        result = result * 59 + ($videoUrl == null ? 43 : $videoUrl.hashCode());
        String $thumbnailUrl = this.getThumbnailUrl();
        result = result * 59 + ($thumbnailUrl == null ? 43 : $thumbnailUrl.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        InputMessageContent $inputMessageContent = this.getInputMessageContent();
        result = result * 59 + ($inputMessageContent == null ? 43 : $inputMessageContent.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        return result;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getMimeType() {
        return this.mimeType;
    }

    @NonNull
    public String getVideoUrl() {
        return this.videoUrl;
    }

    public Integer getVideoWidth() {
        return this.videoWidth;
    }

    public Integer getVideoHeight() {
        return this.videoHeight;
    }

    public Integer getVideoDuration() {
        return this.videoDuration;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCaption() {
        return this.caption;
    }

    public InputMessageContent getInputMessageContent() {
        return this.inputMessageContent;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @JsonProperty(value="id")
    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="mime_type")
    public void setMimeType(@NonNull String mimeType) {
        if (mimeType == null) {
            throw new NullPointerException("mimeType is marked non-null but is null");
        }
        this.mimeType = mimeType;
    }

    @JsonProperty(value="video_url")
    public void setVideoUrl(@NonNull String videoUrl) {
        if (videoUrl == null) {
            throw new NullPointerException("videoUrl is marked non-null but is null");
        }
        this.videoUrl = videoUrl;
    }

    @JsonProperty(value="video_width")
    public void setVideoWidth(Integer videoWidth) {
        this.videoWidth = videoWidth;
    }

    @JsonProperty(value="video_height")
    public void setVideoHeight(Integer videoHeight) {
        this.videoHeight = videoHeight;
    }

    @JsonProperty(value="video_duration")
    public void setVideoDuration(Integer videoDuration) {
        this.videoDuration = videoDuration;
    }

    @JsonProperty(value="thumbnail_url")
    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="caption")
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="input_message_content")
    public void setInputMessageContent(InputMessageContent inputMessageContent) {
        this.inputMessageContent = inputMessageContent;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="parse_mode")
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="caption_entities")
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    public String toString() {
        return "InlineQueryResultVideo(type=" + this.getType() + ", id=" + this.getId() + ", mimeType=" + this.getMimeType() + ", videoUrl=" + this.getVideoUrl() + ", videoWidth=" + this.getVideoWidth() + ", videoHeight=" + this.getVideoHeight() + ", videoDuration=" + this.getVideoDuration() + ", thumbnailUrl=" + this.getThumbnailUrl() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", caption=" + this.getCaption() + ", inputMessageContent=" + this.getInputMessageContent() + ", replyMarkup=" + this.getReplyMarkup() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ")";
    }

    public InlineQueryResultVideo(@NonNull String id, @NonNull String mimeType, @NonNull String videoUrl) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (mimeType == null) {
            throw new NullPointerException("mimeType is marked non-null but is null");
        }
        if (videoUrl == null) {
            throw new NullPointerException("videoUrl is marked non-null but is null");
        }
        this.id = id;
        this.mimeType = mimeType;
        this.videoUrl = videoUrl;
    }

    public InlineQueryResultVideo() {
    }

    public InlineQueryResultVideo(@NonNull String id, @NonNull String mimeType, @NonNull String videoUrl, Integer videoWidth, Integer videoHeight, Integer videoDuration, String thumbnailUrl, String title, String description, String caption, InputMessageContent inputMessageContent, InlineKeyboardMarkup replyMarkup, String parseMode, List<MessageEntity> captionEntities) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (mimeType == null) {
            throw new NullPointerException("mimeType is marked non-null but is null");
        }
        if (videoUrl == null) {
            throw new NullPointerException("videoUrl is marked non-null but is null");
        }
        this.id = id;
        this.mimeType = mimeType;
        this.videoUrl = videoUrl;
        this.videoWidth = videoWidth;
        this.videoHeight = videoHeight;
        this.videoDuration = videoDuration;
        this.thumbnailUrl = thumbnailUrl;
        this.title = title;
        this.description = description;
        this.caption = caption;
        this.inputMessageContent = inputMessageContent;
        this.replyMarkup = replyMarkup;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
    }

    public static class InlineQueryResultVideoBuilder {
        private String id;
        private String mimeType;
        private String videoUrl;
        private Integer videoWidth;
        private Integer videoHeight;
        private Integer videoDuration;
        private String thumbnailUrl;
        private String title;
        private String description;
        private String caption;
        private InputMessageContent inputMessageContent;
        private InlineKeyboardMarkup replyMarkup;
        private String parseMode;
        private ArrayList<MessageEntity> captionEntities;

        InlineQueryResultVideoBuilder() {
        }

        @JsonProperty(value="id")
        public InlineQueryResultVideoBuilder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @JsonProperty(value="mime_type")
        public InlineQueryResultVideoBuilder mimeType(@NonNull String mimeType) {
            if (mimeType == null) {
                throw new NullPointerException("mimeType is marked non-null but is null");
            }
            this.mimeType = mimeType;
            return this;
        }

        @JsonProperty(value="video_url")
        public InlineQueryResultVideoBuilder videoUrl(@NonNull String videoUrl) {
            if (videoUrl == null) {
                throw new NullPointerException("videoUrl is marked non-null but is null");
            }
            this.videoUrl = videoUrl;
            return this;
        }

        @JsonProperty(value="video_width")
        public InlineQueryResultVideoBuilder videoWidth(Integer videoWidth) {
            this.videoWidth = videoWidth;
            return this;
        }

        @JsonProperty(value="video_height")
        public InlineQueryResultVideoBuilder videoHeight(Integer videoHeight) {
            this.videoHeight = videoHeight;
            return this;
        }

        @JsonProperty(value="video_duration")
        public InlineQueryResultVideoBuilder videoDuration(Integer videoDuration) {
            this.videoDuration = videoDuration;
            return this;
        }

        @JsonProperty(value="thumbnail_url")
        public InlineQueryResultVideoBuilder thumbnailUrl(String thumbnailUrl) {
            this.thumbnailUrl = thumbnailUrl;
            return this;
        }

        @JsonProperty(value="title")
        public InlineQueryResultVideoBuilder title(String title) {
            this.title = title;
            return this;
        }

        @JsonProperty(value="description")
        public InlineQueryResultVideoBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="caption")
        public InlineQueryResultVideoBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @JsonProperty(value="input_message_content")
        public InlineQueryResultVideoBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.inputMessageContent = inputMessageContent;
            return this;
        }

        @JsonProperty(value="reply_markup")
        public InlineQueryResultVideoBuilder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        @JsonProperty(value="parse_mode")
        public InlineQueryResultVideoBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public InlineQueryResultVideoBuilder captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return this;
        }

        @JsonProperty(value="caption_entities")
        public InlineQueryResultVideoBuilder captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return this;
        }

        public InlineQueryResultVideoBuilder clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return this;
        }

        public InlineQueryResultVideo build() {
            return new InlineQueryResultVideo(this.id, this.mimeType, this.videoUrl, this.videoWidth, this.videoHeight, this.videoDuration, this.thumbnailUrl, this.title, this.description, this.caption, this.inputMessageContent, this.replyMarkup, this.parseMode, switch (this.captionEntities == null ? 0 : this.captionEntities.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.captionEntities.get(0));
                default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(this.captionEntities));
            });
        }

        public String toString() {
            return "InlineQueryResultVideo.InlineQueryResultVideoBuilder(id=" + this.id + ", mimeType=" + this.mimeType + ", videoUrl=" + this.videoUrl + ", videoWidth=" + this.videoWidth + ", videoHeight=" + this.videoHeight + ", videoDuration=" + this.videoDuration + ", thumbnailUrl=" + this.thumbnailUrl + ", title=" + this.title + ", description=" + this.description + ", caption=" + this.caption + ", inputMessageContent=" + this.inputMessageContent + ", replyMarkup=" + this.replyMarkup + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ")";
        }
    }
}

