/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InlineQueryResultVoice
implements InlineQueryResult {
    private static final String TYPE_FIELD = "type";
    private static final String ID_FIELD = "id";
    private static final String VOICEURL_FIELD = "voice_url";
    private static final String TITLE_FIELD = "title";
    private static final String VOICE_DURATION_FIELD = "voice_duration";
    private static final String INPUTMESSAGECONTENT_FIELD = "input_message_content";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String CAPTION_FIELD = "caption";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    @JsonProperty(value="type")
    private final String type = "voice";
    @JsonProperty(value="id")
    @NonNull
    private String id;
    @JsonProperty(value="voice_url")
    @NonNull
    private String voiceUrl;
    @JsonProperty(value="title")
    @NonNull
    private String title;
    @JsonProperty(value="voice_duration")
    private Integer voiceDuration;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContent;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id == null || this.id.isEmpty()) {
            throw new TelegramApiValidationException("ID parameter can't be empty", this);
        }
        if (this.voiceUrl == null || this.voiceUrl.isEmpty()) {
            throw new TelegramApiValidationException("VoiceUrl parameter can't be empty", this);
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.inputMessageContent != null) {
            this.inputMessageContent.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public static InlineQueryResultVoiceBuilder builder() {
        return new InlineQueryResultVoiceBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineQueryResultVoice)) {
            return false;
        }
        InlineQueryResultVoice other = (InlineQueryResultVoice)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$voiceDuration = this.getVoiceDuration();
        Integer other$voiceDuration = other.getVoiceDuration();
        if (this$voiceDuration == null ? other$voiceDuration != null : !((Object)this$voiceDuration).equals(other$voiceDuration)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$voiceUrl = this.getVoiceUrl();
        String other$voiceUrl = other.getVoiceUrl();
        if (this$voiceUrl == null ? other$voiceUrl != null : !this$voiceUrl.equals(other$voiceUrl)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        InputMessageContent this$inputMessageContent = this.getInputMessageContent();
        InputMessageContent other$inputMessageContent = other.getInputMessageContent();
        if (this$inputMessageContent == null ? other$inputMessageContent != null : !this$inputMessageContent.equals(other$inputMessageContent)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        return !(this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineQueryResultVoice;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $voiceDuration = this.getVoiceDuration();
        result = result * 59 + ($voiceDuration == null ? 43 : ((Object)$voiceDuration).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $voiceUrl = this.getVoiceUrl();
        result = result * 59 + ($voiceUrl == null ? 43 : $voiceUrl.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        InputMessageContent $inputMessageContent = this.getInputMessageContent();
        result = result * 59 + ($inputMessageContent == null ? 43 : $inputMessageContent.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        return result;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getVoiceUrl() {
        return this.voiceUrl;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    public Integer getVoiceDuration() {
        return this.voiceDuration;
    }

    public InputMessageContent getInputMessageContent() {
        return this.inputMessageContent;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public String getCaption() {
        return this.caption;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @JsonProperty(value="id")
    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="voice_url")
    public void setVoiceUrl(@NonNull String voiceUrl) {
        if (voiceUrl == null) {
            throw new NullPointerException("voiceUrl is marked non-null but is null");
        }
        this.voiceUrl = voiceUrl;
    }

    @JsonProperty(value="title")
    public void setTitle(@NonNull String title) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.title = title;
    }

    @JsonProperty(value="voice_duration")
    public void setVoiceDuration(Integer voiceDuration) {
        this.voiceDuration = voiceDuration;
    }

    @JsonProperty(value="input_message_content")
    public void setInputMessageContent(InputMessageContent inputMessageContent) {
        this.inputMessageContent = inputMessageContent;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="caption")
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="parse_mode")
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="caption_entities")
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    public String toString() {
        return "InlineQueryResultVoice(type=" + this.getType() + ", id=" + this.getId() + ", voiceUrl=" + this.getVoiceUrl() + ", title=" + this.getTitle() + ", voiceDuration=" + this.getVoiceDuration() + ", inputMessageContent=" + this.getInputMessageContent() + ", replyMarkup=" + this.getReplyMarkup() + ", caption=" + this.getCaption() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ")";
    }

    public InlineQueryResultVoice(@NonNull String id, @NonNull String voiceUrl, @NonNull String title) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (voiceUrl == null) {
            throw new NullPointerException("voiceUrl is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.id = id;
        this.voiceUrl = voiceUrl;
        this.title = title;
    }

    public InlineQueryResultVoice() {
    }

    public InlineQueryResultVoice(@NonNull String id, @NonNull String voiceUrl, @NonNull String title, Integer voiceDuration, InputMessageContent inputMessageContent, InlineKeyboardMarkup replyMarkup, String caption, String parseMode, List<MessageEntity> captionEntities) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (voiceUrl == null) {
            throw new NullPointerException("voiceUrl is marked non-null but is null");
        }
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        this.id = id;
        this.voiceUrl = voiceUrl;
        this.title = title;
        this.voiceDuration = voiceDuration;
        this.inputMessageContent = inputMessageContent;
        this.replyMarkup = replyMarkup;
        this.caption = caption;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
    }

    public static class InlineQueryResultVoiceBuilder {
        private String id;
        private String voiceUrl;
        private String title;
        private Integer voiceDuration;
        private InputMessageContent inputMessageContent;
        private InlineKeyboardMarkup replyMarkup;
        private String caption;
        private String parseMode;
        private ArrayList<MessageEntity> captionEntities;

        InlineQueryResultVoiceBuilder() {
        }

        @JsonProperty(value="id")
        public InlineQueryResultVoiceBuilder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @JsonProperty(value="voice_url")
        public InlineQueryResultVoiceBuilder voiceUrl(@NonNull String voiceUrl) {
            if (voiceUrl == null) {
                throw new NullPointerException("voiceUrl is marked non-null but is null");
            }
            this.voiceUrl = voiceUrl;
            return this;
        }

        @JsonProperty(value="title")
        public InlineQueryResultVoiceBuilder title(@NonNull String title) {
            if (title == null) {
                throw new NullPointerException("title is marked non-null but is null");
            }
            this.title = title;
            return this;
        }

        @JsonProperty(value="voice_duration")
        public InlineQueryResultVoiceBuilder voiceDuration(Integer voiceDuration) {
            this.voiceDuration = voiceDuration;
            return this;
        }

        @JsonProperty(value="input_message_content")
        public InlineQueryResultVoiceBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.inputMessageContent = inputMessageContent;
            return this;
        }

        @JsonProperty(value="reply_markup")
        public InlineQueryResultVoiceBuilder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        @JsonProperty(value="caption")
        public InlineQueryResultVoiceBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @JsonProperty(value="parse_mode")
        public InlineQueryResultVoiceBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public InlineQueryResultVoiceBuilder captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return this;
        }

        @JsonProperty(value="caption_entities")
        public InlineQueryResultVoiceBuilder captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return this;
        }

        public InlineQueryResultVoiceBuilder clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return this;
        }

        public InlineQueryResultVoice build() {
            return new InlineQueryResultVoice(this.id, this.voiceUrl, this.title, this.voiceDuration, this.inputMessageContent, this.replyMarkup, this.caption, this.parseMode, switch (this.captionEntities == null ? 0 : this.captionEntities.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.captionEntities.get(0));
                default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(this.captionEntities));
            });
        }

        public String toString() {
            return "InlineQueryResultVoice.InlineQueryResultVoiceBuilder(id=" + this.id + ", voiceUrl=" + this.voiceUrl + ", title=" + this.title + ", voiceDuration=" + this.voiceDuration + ", inputMessageContent=" + this.inputMessageContent + ", replyMarkup=" + this.replyMarkup + ", caption=" + this.caption + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ")";
        }
    }
}

