/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.inlinequery.result.cached;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.inlinequery.inputmessagecontent.InputMessageContent;
import org.telegram.telegrambots.meta.api.objects.inlinequery.result.InlineQueryResult;
import org.telegram.telegrambots.meta.api.objects.replykeyboard.InlineKeyboardMarkup;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InlineQueryResultCachedPhoto
implements InlineQueryResult {
    private static final String TYPE_FIELD = "type";
    private static final String ID_FIELD = "id";
    private static final String PHOTOFILEID_FIELD = "photo_file_id";
    private static final String TITLE_FIELD = "title";
    private static final String DESCRIPTION_FIELD = "description";
    private static final String CAPTION_FIELD = "caption";
    private static final String INPUTMESSAGECONTENT_FIELD = "input_message_content";
    private static final String REPLY_MARKUP_FIELD = "reply_markup";
    private static final String PARSEMODE_FIELD = "parse_mode";
    private static final String CAPTION_ENTITIES_FIELD = "caption_entities";
    @JsonProperty(value="type")
    private final String type = "photo";
    @JsonProperty(value="id")
    @NonNull
    private String id;
    @JsonProperty(value="photo_file_id")
    @NonNull
    private String photoFileId;
    @JsonProperty(value="title")
    private String title;
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="caption")
    private String caption;
    @JsonProperty(value="input_message_content")
    private InputMessageContent inputMessageContent;
    @JsonProperty(value="reply_markup")
    private InlineKeyboardMarkup replyMarkup;
    @JsonProperty(value="parse_mode")
    private String parseMode;
    @JsonProperty(value="caption_entities")
    private List<MessageEntity> captionEntities;

    @Override
    public void validate() throws TelegramApiValidationException {
        if (this.id == null || this.id.isEmpty()) {
            throw new TelegramApiValidationException("ID parameter can't be empty", this);
        }
        if (this.photoFileId == null || this.photoFileId.isEmpty()) {
            throw new TelegramApiValidationException("PhotoFileId parameter can't be empty", this);
        }
        if (this.parseMode != null && this.captionEntities != null && !this.captionEntities.isEmpty()) {
            throw new TelegramApiValidationException("Parse mode can't be enabled if Entities are provided", this);
        }
        if (this.inputMessageContent != null) {
            this.inputMessageContent.validate();
        }
        if (this.replyMarkup != null) {
            this.replyMarkup.validate();
        }
    }

    public static InlineQueryResultCachedPhotoBuilder builder() {
        return new InlineQueryResultCachedPhotoBuilder();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InlineQueryResultCachedPhoto)) {
            return false;
        }
        InlineQueryResultCachedPhoto other = (InlineQueryResultCachedPhoto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$photoFileId = this.getPhotoFileId();
        String other$photoFileId = other.getPhotoFileId();
        if (this$photoFileId == null ? other$photoFileId != null : !this$photoFileId.equals(other$photoFileId)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$caption = this.getCaption();
        String other$caption = other.getCaption();
        if (this$caption == null ? other$caption != null : !this$caption.equals(other$caption)) {
            return false;
        }
        InputMessageContent this$inputMessageContent = this.getInputMessageContent();
        InputMessageContent other$inputMessageContent = other.getInputMessageContent();
        if (this$inputMessageContent == null ? other$inputMessageContent != null : !this$inputMessageContent.equals(other$inputMessageContent)) {
            return false;
        }
        InlineKeyboardMarkup this$replyMarkup = this.getReplyMarkup();
        InlineKeyboardMarkup other$replyMarkup = other.getReplyMarkup();
        if (this$replyMarkup == null ? other$replyMarkup != null : !((Object)this$replyMarkup).equals(other$replyMarkup)) {
            return false;
        }
        String this$parseMode = this.getParseMode();
        String other$parseMode = other.getParseMode();
        if (this$parseMode == null ? other$parseMode != null : !this$parseMode.equals(other$parseMode)) {
            return false;
        }
        List<MessageEntity> this$captionEntities = this.getCaptionEntities();
        List<MessageEntity> other$captionEntities = other.getCaptionEntities();
        return !(this$captionEntities == null ? other$captionEntities != null : !((Object)this$captionEntities).equals(other$captionEntities));
    }

    protected boolean canEqual(Object other) {
        return other instanceof InlineQueryResultCachedPhoto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $photoFileId = this.getPhotoFileId();
        result = result * 59 + ($photoFileId == null ? 43 : $photoFileId.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $caption = this.getCaption();
        result = result * 59 + ($caption == null ? 43 : $caption.hashCode());
        InputMessageContent $inputMessageContent = this.getInputMessageContent();
        result = result * 59 + ($inputMessageContent == null ? 43 : $inputMessageContent.hashCode());
        InlineKeyboardMarkup $replyMarkup = this.getReplyMarkup();
        result = result * 59 + ($replyMarkup == null ? 43 : ((Object)$replyMarkup).hashCode());
        String $parseMode = this.getParseMode();
        result = result * 59 + ($parseMode == null ? 43 : $parseMode.hashCode());
        List<MessageEntity> $captionEntities = this.getCaptionEntities();
        result = result * 59 + ($captionEntities == null ? 43 : ((Object)$captionEntities).hashCode());
        return result;
    }

    public String getType() {
        return this.type;
    }

    @NonNull
    public String getId() {
        return this.id;
    }

    @NonNull
    public String getPhotoFileId() {
        return this.photoFileId;
    }

    public String getTitle() {
        return this.title;
    }

    public String getDescription() {
        return this.description;
    }

    public String getCaption() {
        return this.caption;
    }

    public InputMessageContent getInputMessageContent() {
        return this.inputMessageContent;
    }

    public InlineKeyboardMarkup getReplyMarkup() {
        return this.replyMarkup;
    }

    public String getParseMode() {
        return this.parseMode;
    }

    public List<MessageEntity> getCaptionEntities() {
        return this.captionEntities;
    }

    @JsonProperty(value="id")
    public void setId(@NonNull String id) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        this.id = id;
    }

    @JsonProperty(value="photo_file_id")
    public void setPhotoFileId(@NonNull String photoFileId) {
        if (photoFileId == null) {
            throw new NullPointerException("photoFileId is marked non-null but is null");
        }
        this.photoFileId = photoFileId;
    }

    @JsonProperty(value="title")
    public void setTitle(String title) {
        this.title = title;
    }

    @JsonProperty(value="description")
    public void setDescription(String description) {
        this.description = description;
    }

    @JsonProperty(value="caption")
    public void setCaption(String caption) {
        this.caption = caption;
    }

    @JsonProperty(value="input_message_content")
    public void setInputMessageContent(InputMessageContent inputMessageContent) {
        this.inputMessageContent = inputMessageContent;
    }

    @JsonProperty(value="reply_markup")
    public void setReplyMarkup(InlineKeyboardMarkup replyMarkup) {
        this.replyMarkup = replyMarkup;
    }

    @JsonProperty(value="parse_mode")
    public void setParseMode(String parseMode) {
        this.parseMode = parseMode;
    }

    @JsonProperty(value="caption_entities")
    public void setCaptionEntities(List<MessageEntity> captionEntities) {
        this.captionEntities = captionEntities;
    }

    public String toString() {
        return "InlineQueryResultCachedPhoto(type=" + this.getType() + ", id=" + this.getId() + ", photoFileId=" + this.getPhotoFileId() + ", title=" + this.getTitle() + ", description=" + this.getDescription() + ", caption=" + this.getCaption() + ", inputMessageContent=" + this.getInputMessageContent() + ", replyMarkup=" + this.getReplyMarkup() + ", parseMode=" + this.getParseMode() + ", captionEntities=" + this.getCaptionEntities() + ")";
    }

    public InlineQueryResultCachedPhoto(@NonNull String id, @NonNull String photoFileId) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (photoFileId == null) {
            throw new NullPointerException("photoFileId is marked non-null but is null");
        }
        this.id = id;
        this.photoFileId = photoFileId;
    }

    public InlineQueryResultCachedPhoto() {
    }

    public InlineQueryResultCachedPhoto(@NonNull String id, @NonNull String photoFileId, String title, String description, String caption, InputMessageContent inputMessageContent, InlineKeyboardMarkup replyMarkup, String parseMode, List<MessageEntity> captionEntities) {
        if (id == null) {
            throw new NullPointerException("id is marked non-null but is null");
        }
        if (photoFileId == null) {
            throw new NullPointerException("photoFileId is marked non-null but is null");
        }
        this.id = id;
        this.photoFileId = photoFileId;
        this.title = title;
        this.description = description;
        this.caption = caption;
        this.inputMessageContent = inputMessageContent;
        this.replyMarkup = replyMarkup;
        this.parseMode = parseMode;
        this.captionEntities = captionEntities;
    }

    public static class InlineQueryResultCachedPhotoBuilder {
        private String id;
        private String photoFileId;
        private String title;
        private String description;
        private String caption;
        private InputMessageContent inputMessageContent;
        private InlineKeyboardMarkup replyMarkup;
        private String parseMode;
        private ArrayList<MessageEntity> captionEntities;

        InlineQueryResultCachedPhotoBuilder() {
        }

        @JsonProperty(value="id")
        public InlineQueryResultCachedPhotoBuilder id(@NonNull String id) {
            if (id == null) {
                throw new NullPointerException("id is marked non-null but is null");
            }
            this.id = id;
            return this;
        }

        @JsonProperty(value="photo_file_id")
        public InlineQueryResultCachedPhotoBuilder photoFileId(@NonNull String photoFileId) {
            if (photoFileId == null) {
                throw new NullPointerException("photoFileId is marked non-null but is null");
            }
            this.photoFileId = photoFileId;
            return this;
        }

        @JsonProperty(value="title")
        public InlineQueryResultCachedPhotoBuilder title(String title) {
            this.title = title;
            return this;
        }

        @JsonProperty(value="description")
        public InlineQueryResultCachedPhotoBuilder description(String description) {
            this.description = description;
            return this;
        }

        @JsonProperty(value="caption")
        public InlineQueryResultCachedPhotoBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        @JsonProperty(value="input_message_content")
        public InlineQueryResultCachedPhotoBuilder inputMessageContent(InputMessageContent inputMessageContent) {
            this.inputMessageContent = inputMessageContent;
            return this;
        }

        @JsonProperty(value="reply_markup")
        public InlineQueryResultCachedPhotoBuilder replyMarkup(InlineKeyboardMarkup replyMarkup) {
            this.replyMarkup = replyMarkup;
            return this;
        }

        @JsonProperty(value="parse_mode")
        public InlineQueryResultCachedPhotoBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public InlineQueryResultCachedPhotoBuilder captionEntity(MessageEntity captionEntity) {
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.add(captionEntity);
            return this;
        }

        @JsonProperty(value="caption_entities")
        public InlineQueryResultCachedPhotoBuilder captionEntities(Collection<? extends MessageEntity> captionEntities) {
            if (captionEntities == null) {
                throw new NullPointerException("captionEntities cannot be null");
            }
            if (this.captionEntities == null) {
                this.captionEntities = new ArrayList();
            }
            this.captionEntities.addAll(captionEntities);
            return this;
        }

        public InlineQueryResultCachedPhotoBuilder clearCaptionEntities() {
            if (this.captionEntities != null) {
                this.captionEntities.clear();
            }
            return this;
        }

        public InlineQueryResultCachedPhoto build() {
            return new InlineQueryResultCachedPhoto(this.id, this.photoFileId, this.title, this.description, this.caption, this.inputMessageContent, this.replyMarkup, this.parseMode, switch (this.captionEntities == null ? 0 : this.captionEntities.size()) {
                case 0 -> Collections.emptyList();
                case 1 -> Collections.singletonList(this.captionEntities.get(0));
                default -> Collections.unmodifiableList(new ArrayList<MessageEntity>(this.captionEntities));
            });
        }

        public String toString() {
            return "InlineQueryResultCachedPhoto.InlineQueryResultCachedPhotoBuilder(id=" + this.id + ", photoFileId=" + this.photoFileId + ", title=" + this.title + ", description=" + this.description + ", caption=" + this.caption + ", inputMessageContent=" + this.inputMessageContent + ", replyMarkup=" + this.replyMarkup + ", parseMode=" + this.parseMode + ", captionEntities=" + this.captionEntities + ")";
        }
    }
}

