/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.telegrambots.meta.api.objects.media;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import lombok.NonNull;
import org.telegram.telegrambots.meta.api.objects.InputFile;
import org.telegram.telegrambots.meta.api.objects.MessageEntity;
import org.telegram.telegrambots.meta.api.objects.media.InputMedia;
import org.telegram.telegrambots.meta.exceptions.TelegramApiValidationException;

@JsonDeserialize
public class InputMediaAnimation
extends InputMedia {
    private static final String TYPE = "animation";
    public static final String WIDTH_FIELD = "width";
    public static final String HEIGHT_FIELD = "height";
    public static final String DURATION_FIELD = "duration";
    public static final String THUMBNAIL_FIELD = "thumbnail";
    public static final String HASSPOILER_FIELD = "has_spoiler";
    @JsonProperty(value="width")
    private Integer width;
    @JsonProperty(value="height")
    private Integer height;
    @JsonProperty(value="duration")
    private Integer duration;
    private InputFile thumbnail;
    @JsonProperty(value="has_spoiler")
    private Boolean hasSpoiler;

    public InputMediaAnimation() {
    }

    public InputMediaAnimation(@NonNull String media) {
        super(media);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
    }

    public InputMediaAnimation(@NonNull String media, String caption, String parseMode, List<MessageEntity> entities, boolean isNewMedia, String mediaName, File newMediaFile, InputStream newMediaStream, Integer width, Integer height, Integer duration, InputFile thumbnail, Boolean hasSpoiler) {
        super(media, caption, parseMode, entities, isNewMedia, mediaName, newMediaFile, newMediaStream);
        if (media == null) {
            throw new NullPointerException("media is marked non-null but is null");
        }
        this.width = width;
        this.height = height;
        this.duration = duration;
        this.thumbnail = thumbnail;
        this.hasSpoiler = hasSpoiler;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    public void validate() throws TelegramApiValidationException {
        super.validate();
    }

    public static InputMediaAnimationBuilder builder() {
        return new InputMediaAnimationBuilder();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputMediaAnimation)) {
            return false;
        }
        InputMediaAnimation other = (InputMediaAnimation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$height = this.getHeight();
        Integer other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Integer this$duration = this.getDuration();
        Integer other$duration = other.getDuration();
        if (this$duration == null ? other$duration != null : !((Object)this$duration).equals(other$duration)) {
            return false;
        }
        Boolean this$hasSpoiler = this.getHasSpoiler();
        Boolean other$hasSpoiler = other.getHasSpoiler();
        if (this$hasSpoiler == null ? other$hasSpoiler != null : !((Object)this$hasSpoiler).equals(other$hasSpoiler)) {
            return false;
        }
        InputFile this$thumbnail = this.getThumbnail();
        InputFile other$thumbnail = other.getThumbnail();
        return !(this$thumbnail == null ? other$thumbnail != null : !((Object)this$thumbnail).equals(other$thumbnail));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof InputMediaAnimation;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Integer $duration = this.getDuration();
        result = result * 59 + ($duration == null ? 43 : ((Object)$duration).hashCode());
        Boolean $hasSpoiler = this.getHasSpoiler();
        result = result * 59 + ($hasSpoiler == null ? 43 : ((Object)$hasSpoiler).hashCode());
        InputFile $thumbnail = this.getThumbnail();
        result = result * 59 + ($thumbnail == null ? 43 : ((Object)$thumbnail).hashCode());
        return result;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public Integer getDuration() {
        return this.duration;
    }

    public InputFile getThumbnail() {
        return this.thumbnail;
    }

    public Boolean getHasSpoiler() {
        return this.hasSpoiler;
    }

    @JsonProperty(value="width")
    public void setWidth(Integer width) {
        this.width = width;
    }

    @JsonProperty(value="height")
    public void setHeight(Integer height) {
        this.height = height;
    }

    @JsonProperty(value="duration")
    public void setDuration(Integer duration) {
        this.duration = duration;
    }

    public void setThumbnail(InputFile thumbnail) {
        this.thumbnail = thumbnail;
    }

    @JsonProperty(value="has_spoiler")
    public void setHasSpoiler(Boolean hasSpoiler) {
        this.hasSpoiler = hasSpoiler;
    }

    @Override
    public String toString() {
        return "InputMediaAnimation(width=" + this.getWidth() + ", height=" + this.getHeight() + ", duration=" + this.getDuration() + ", thumbnail=" + this.getThumbnail() + ", hasSpoiler=" + this.getHasSpoiler() + ")";
    }

    public static class InputMediaAnimationBuilder {
        private String media;
        private String caption;
        private String parseMode;
        private List<MessageEntity> entities;
        private boolean isNewMedia;
        private String mediaName;
        private File newMediaFile;
        private InputStream newMediaStream;
        private Integer width;
        private Integer height;
        private Integer duration;
        private InputFile thumbnail;
        private Boolean hasSpoiler;

        InputMediaAnimationBuilder() {
        }

        public InputMediaAnimationBuilder media(@NonNull String media) {
            if (media == null) {
                throw new NullPointerException("media is marked non-null but is null");
            }
            this.media = media;
            return this;
        }

        public InputMediaAnimationBuilder caption(String caption) {
            this.caption = caption;
            return this;
        }

        public InputMediaAnimationBuilder parseMode(String parseMode) {
            this.parseMode = parseMode;
            return this;
        }

        public InputMediaAnimationBuilder entities(List<MessageEntity> entities) {
            this.entities = entities;
            return this;
        }

        public InputMediaAnimationBuilder isNewMedia(boolean isNewMedia) {
            this.isNewMedia = isNewMedia;
            return this;
        }

        public InputMediaAnimationBuilder mediaName(String mediaName) {
            this.mediaName = mediaName;
            return this;
        }

        public InputMediaAnimationBuilder newMediaFile(File newMediaFile) {
            this.newMediaFile = newMediaFile;
            return this;
        }

        public InputMediaAnimationBuilder newMediaStream(InputStream newMediaStream) {
            this.newMediaStream = newMediaStream;
            return this;
        }

        public InputMediaAnimationBuilder width(Integer width) {
            this.width = width;
            return this;
        }

        public InputMediaAnimationBuilder height(Integer height) {
            this.height = height;
            return this;
        }

        public InputMediaAnimationBuilder duration(Integer duration) {
            this.duration = duration;
            return this;
        }

        public InputMediaAnimationBuilder thumbnail(InputFile thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public InputMediaAnimationBuilder hasSpoiler(Boolean hasSpoiler) {
            this.hasSpoiler = hasSpoiler;
            return this;
        }

        public InputMediaAnimation build() {
            return new InputMediaAnimation(this.media, this.caption, this.parseMode, this.entities, this.isNewMedia, this.mediaName, this.newMediaFile, this.newMediaStream, this.width, this.height, this.duration, this.thumbnail, this.hasSpoiler);
        }

        public String toString() {
            return "InputMediaAnimation.InputMediaAnimationBuilder(media=" + this.media + ", caption=" + this.caption + ", parseMode=" + this.parseMode + ", entities=" + this.entities + ", isNewMedia=" + this.isNewMedia + ", mediaName=" + this.mediaName + ", newMediaFile=" + this.newMediaFile + ", newMediaStream=" + this.newMediaStream + ", width=" + this.width + ", height=" + this.height + ", duration=" + this.duration + ", thumbnail=" + this.thumbnail + ", hasSpoiler=" + this.hasSpoiler + ")";
        }
    }
}

